/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.FixedAssetType;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_FIXED_ASSET_CATEGORY", indexes={@Index(columnList="name"), @Index(columnList="fixed_asset_type"), @Index(columnList="company"), @Index(columnList="journal"), @Index(columnList="charge_account"), @Index(columnList="depreciation_account"), @Index(columnList="analytic_distribution_template")})
public class FixedAssetCategory
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_FIXED_ASSET_CATEGORY_SEQ")
    @SequenceGenerator(name="ACCOUNT_FIXED_ASSET_CATEGORY_SEQ", sequenceName="ACCOUNT_FIXED_ASSET_CATEGORY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Fixed asset type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FixedAssetType fixedAssetType;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Computation method", selection="account.fixed.type.category.computation.method.select")
    private String computationMethodSelect;
    @Widget(title="Degressive coef")
    private BigDecimal degressiveCoef = BigDecimal.ZERO;
    @Widget(title="Validate automatically fixed assets generated from invoice")
    private Boolean isValidateFixedAsset = Boolean.FALSE;
    @Widget(title="Periodicity in month")
    private Integer periodicityInMonth = 12;
    @Widget(title="Number of depreciation")
    private Integer numberOfDepreciation = 1;
    @Widget(title="Duration in month")
    private Integer durationInMonth = 0;
    @Widget(title="Prorata temporis")
    private Boolean isProrataTemporis = Boolean.FALSE;
    @Widget(title="Journal")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Charge account")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account chargeAccount;
    @Widget(title="Depreciation account")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account depreciationAccount;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public FixedAssetCategory() {
    }

    public FixedAssetCategory(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FixedAssetType getFixedAssetType() {
        return this.fixedAssetType;
    }

    public void setFixedAssetType(FixedAssetType fixedAssetType) {
        this.fixedAssetType = fixedAssetType;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getComputationMethodSelect() {
        return this.computationMethodSelect;
    }

    public void setComputationMethodSelect(String computationMethodSelect) {
        this.computationMethodSelect = computationMethodSelect;
    }

    public BigDecimal getDegressiveCoef() {
        return this.degressiveCoef == null ? BigDecimal.ZERO : this.degressiveCoef;
    }

    public void setDegressiveCoef(BigDecimal degressiveCoef) {
        this.degressiveCoef = degressiveCoef;
    }

    public Boolean getIsValidateFixedAsset() {
        return this.isValidateFixedAsset == null ? Boolean.FALSE : this.isValidateFixedAsset;
    }

    public void setIsValidateFixedAsset(Boolean isValidateFixedAsset) {
        this.isValidateFixedAsset = isValidateFixedAsset;
    }

    public Integer getPeriodicityInMonth() {
        return this.periodicityInMonth == null ? 0 : this.periodicityInMonth;
    }

    public void setPeriodicityInMonth(Integer periodicityInMonth) {
        this.periodicityInMonth = periodicityInMonth;
    }

    public Integer getNumberOfDepreciation() {
        return this.numberOfDepreciation == null ? 0 : this.numberOfDepreciation;
    }

    public void setNumberOfDepreciation(Integer numberOfDepreciation) {
        this.numberOfDepreciation = numberOfDepreciation;
    }

    public Integer getDurationInMonth() {
        return this.durationInMonth == null ? 0 : this.durationInMonth;
    }

    public void setDurationInMonth(Integer durationInMonth) {
        this.durationInMonth = durationInMonth;
    }

    public Boolean getIsProrataTemporis() {
        return this.isProrataTemporis == null ? Boolean.FALSE : this.isProrataTemporis;
    }

    public void setIsProrataTemporis(Boolean isProrataTemporis) {
        this.isProrataTemporis = isProrataTemporis;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Account getChargeAccount() {
        return this.chargeAccount;
    }

    public void setChargeAccount(Account chargeAccount) {
        this.chargeAccount = chargeAccount;
    }

    public Account getDepreciationAccount() {
        return this.depreciationAccount;
    }

    public void setDepreciationAccount(Account depreciationAccount) {
        this.depreciationAccount = depreciationAccount;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FixedAssetCategory)) {
            return false;
        }
        FixedAssetCategory other = (FixedAssetCategory)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("computationMethodSelect", (Object)this.getComputationMethodSelect()).add("degressiveCoef", (Object)this.getDegressiveCoef()).add("isValidateFixedAsset", (Object)this.getIsValidateFixedAsset()).add("periodicityInMonth", (Object)this.getPeriodicityInMonth()).add("numberOfDepreciation", (Object)this.getNumberOfDepreciation()).add("durationInMonth", (Object)this.getDurationInMonth()).add("isProrataTemporis", (Object)this.getIsProrataTemporis()).omitNullValues().toString();
    }
}

