/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.InterbankCode;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_INTERBANK_CODE_LINE", indexes={@Index(columnList="code"), @Index(columnList="name"), @Index(columnList="interbank_code")})
public class InterbankCodeLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INTERBANK_CODE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_INTERBANK_CODE_LINE_SEQ", sequenceName="ACCOUNT_INTERBANK_CODE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Standard label")
    @NotNull
    private String name;
    @Widget(title="Usage rule", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Wire Transfer")
    private Boolean transferCfonbOk = Boolean.FALSE;
    @Widget(title="Direct debit/IPO/Electronic Payment Order (EPO) CFONB")
    private Boolean directDebitAndTipCfonbOk = Boolean.FALSE;
    @Widget(title="Direct debit SEPA")
    private Boolean directDebitSepaOk = Boolean.FALSE;
    @Widget(title="LCR/BOR")
    private Boolean lcrBorOk = Boolean.FALSE;
    @Widget(title="Cheque")
    private Boolean chequeOk = Boolean.FALSE;
    @Widget(title="Interbank codes list")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCode interbankCode;
    @Widget(title="Technical Rejection")
    private Boolean technicalRejectOk = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public InterbankCodeLine() {
    }

    public InterbankCodeLine(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getTransferCfonbOk() {
        return this.transferCfonbOk == null ? Boolean.FALSE : this.transferCfonbOk;
    }

    public void setTransferCfonbOk(Boolean transferCfonbOk) {
        this.transferCfonbOk = transferCfonbOk;
    }

    public Boolean getDirectDebitAndTipCfonbOk() {
        return this.directDebitAndTipCfonbOk == null ? Boolean.FALSE : this.directDebitAndTipCfonbOk;
    }

    public void setDirectDebitAndTipCfonbOk(Boolean directDebitAndTipCfonbOk) {
        this.directDebitAndTipCfonbOk = directDebitAndTipCfonbOk;
    }

    public Boolean getDirectDebitSepaOk() {
        return this.directDebitSepaOk == null ? Boolean.FALSE : this.directDebitSepaOk;
    }

    public void setDirectDebitSepaOk(Boolean directDebitSepaOk) {
        this.directDebitSepaOk = directDebitSepaOk;
    }

    public Boolean getLcrBorOk() {
        return this.lcrBorOk == null ? Boolean.FALSE : this.lcrBorOk;
    }

    public void setLcrBorOk(Boolean lcrBorOk) {
        this.lcrBorOk = lcrBorOk;
    }

    public Boolean getChequeOk() {
        return this.chequeOk == null ? Boolean.FALSE : this.chequeOk;
    }

    public void setChequeOk(Boolean chequeOk) {
        this.chequeOk = chequeOk;
    }

    public InterbankCode getInterbankCode() {
        return this.interbankCode;
    }

    public void setInterbankCode(InterbankCode interbankCode) {
        this.interbankCode = interbankCode;
    }

    public Boolean getTechnicalRejectOk() {
        return this.technicalRejectOk == null ? Boolean.FALSE : this.technicalRejectOk;
    }

    public void setTechnicalRejectOk(Boolean technicalRejectOk) {
        this.technicalRejectOk = technicalRejectOk;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InterbankCodeLine)) {
            return false;
        }
        InterbankCodeLine other = (InterbankCodeLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("transferCfonbOk", (Object)this.getTransferCfonbOk()).add("directDebitAndTipCfonbOk", (Object)this.getDirectDebitAndTipCfonbOk()).add("directDebitSepaOk", (Object)this.getDirectDebitSepaOk()).add("lcrBorOk", (Object)this.getLcrBorOk()).add("chequeOk", (Object)this.getChequeOk()).add("technicalRejectOk", (Object)this.getTechnicalRejectOk()).omitNullValues().toString();
    }
}

