/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.DirectDebitManagement;
import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoiceLineTax;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.ManagementObject;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.SubrogationRelease;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PrintingSettings;
import com.axelor.apps.base.db.StopReason;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_INVOICE", uniqueConstraints={@UniqueConstraint(columnNames={"invoiceId", "company"})}, indexes={@Index(columnList="canceled_payment_schedule"), @Index(columnList="invoiceId"), @Index(columnList="company"), @Index(columnList="partner"), @Index(columnList="contact_partner"), @Index(columnList="payment_mode"), @Index(columnList="payment_condition"), @Index(columnList="bank_details"), @Index(columnList="partner_account"), @Index(columnList="address"), @Index(columnList="price_list"), @Index(columnList="payment_schedule"), @Index(columnList="journal"), @Index(columnList="move"), @Index(columnList="old_move"), @Index(columnList="currency"), @Index(columnList="ventilated_by_user"), @Index(columnList="original_invoice"), @Index(columnList="management_object"), @Index(columnList="standard_invoice"), @Index(columnList="debit_blocking_reason"), @Index(columnList="debit_blocking_by_user"), @Index(columnList="debt_recovery_blocking_reason"), @Index(columnList="debt_recovery_blocking_by_user"), @Index(columnList="direct_debit_management"), @Index(columnList="reject_move_line"), @Index(columnList="interbank_code_line"), @Index(columnList="payment_move"), @Index(columnList="printedpdf"), @Index(columnList="validated_by_user"), @Index(columnList="company_bank_details"), @Index(columnList="invoice_message_template"), @Index(columnList="invoice_message_template_on_validate"), @Index(columnList="trading_name"), @Index(columnList="printing_settings"), @Index(columnList="subrogation_release"), @Index(columnList="subrogation_release_move"), @Index(columnList="pfp_validator_user"), @Index(columnList="reason_of_refusal_to_pay")})
@Track(fields={@TrackField(name="invoiceId"), @TrackField(name="partner"), @TrackField(name="statusSelect", on={TrackEvent.UPDATE})}, messages={@TrackMessage(message="Invoice created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Validated", condition="statusSelect == 2", tag="important"), @TrackMessage(message="Ventilated", condition="statusSelect == 3", tag="success"), @TrackMessage(message="Important", condition="statusSelect == 3 && dueDate.isAfter(__date__)")})
public class Invoice
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INVOICE_SEQ")
    @SequenceGenerator(name="ACCOUNT_INVOICE_SEQ", sequenceName="ACCOUNT_INVOICE_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentSchedule canceledPaymentSchedule;
    @Widget(title="Invoice N\u00b0", readonly=true)
    @NameColumn
    private String invoiceId;
    @Widget(title="Document Type", selection="iinvoice.operation.type.select")
    @NotNull
    private Integer operationTypeSelect = 0;
    @Widget(title="Document Subtype", selection="iinvoice.operation.sub.type.select")
    @NotNull
    private Integer operationSubTypeSelect = 1;
    @Widget(title="Customer tax number")
    private String partnerTaxNbr;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Partner")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Contact")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="Payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Payment condition")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @Widget(title="Bank Details")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Partner account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account partnerAccount;
    @Widget(title="Address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address address;
    @Widget(title="Address", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String addressStr;
    @Widget(title="Internal Ref.")
    private String internalReference;
    @Widget(title="External Ref.")
    private String externalReference;
    @Widget(title="Price list")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PriceList priceList;
    @Widget(title="Hide Discount on prints")
    private Boolean hideDiscount = Boolean.FALSE;
    @Widget(title="Invoice Date")
    private LocalDate invoiceDate;
    @Widget(title="Due Date")
    private LocalDate dueDate;
    @Widget(title="Origin date")
    private LocalDate originDate;
    @Widget(title="Belong to a payment schedule")
    private Boolean schedulePaymentOk = Boolean.FALSE;
    @Widget(title="Payment Schedule", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentSchedule paymentSchedule;
    @Widget(title="Journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move move;
    @Widget(title="Previous Move", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move oldMove;
    @Widget(title="Doubtful Customer")
    private Boolean doubtfulCustomerOk = Boolean.FALSE;
    @Widget(title="Currency")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Payments")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InvoicePayment> invoicePaymentList;
    @Widget(title="Ventilated Date", readonly=true)
    private LocalDate ventilatedDate;
    @Widget(title="Ventilated by", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User ventilatedByUser;
    @Widget(title="Invoice Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InvoiceLine> invoiceLineList;
    @Widget(title="Tax Lines", readonly=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoice", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<InvoiceLineTax> invoiceLineTaxList;
    @Widget(title="Already printed")
    private Boolean alreadyPrintedOk = Boolean.TRUE;
    @Widget(title="Invoice of origin")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice originalInvoice;
    @Widget(title="Refunds")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="originalInvoice", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Invoice> refundInvoiceList;
    @Widget(title="Irrecoverable status", readonly=true, selection="iaccount.account.schedule.irrecoverable.status.select")
    private Integer irrecoverableStatusSelect = 0;
    @Widget(title="Irrecoverable shifting reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManagementObject managementObject;
    @Widget(title="Standard Invoice")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice standardInvoice;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Direct debit blocking")
    private Boolean debitBlockingOk = Boolean.FALSE;
    @Widget(title="Blocking reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason debitBlockingReason;
    @Widget(title="Blocking until")
    private LocalDate debitBlockingToDate;
    @Widget(title="Blocking done by")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User debitBlockingByUser;
    @Widget(title="Debt recovery blocking")
    private Boolean debtRecoveryBlockingOk = Boolean.FALSE;
    @Widget(title="Blocking reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StopReason debtRecoveryBlockingReason;
    @Widget(title="Blocking until")
    private LocalDate debtRecoveryBlockingToDate;
    @Widget(title="Blocking done by")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User debtRecoveryBlockingByUser;
    @Widget(title="Direct Debit N\u00b0")
    private String debitNumber;
    @Widget(title="Direct debit list")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DirectDebitManagement directDebitManagement;
    @Widget(title="Rejection move line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine rejectMoveLine;
    @Widget(title="Transfer(ed) to usher")
    private Boolean usherPassageOk = Boolean.FALSE;
    @Widget(title="Rejected amount")
    private BigDecimal amountRejected = BigDecimal.ZERO;
    @Widget(title="Rejection date")
    private LocalDate rejectDate;
    @Widget(title="Rejection reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine interbankCodeLine;
    @Widget(title="Debited amount", readonly=true)
    private BigDecimal directDebitAmount = BigDecimal.ZERO;
    @Widget(title="Payment Move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move paymentMove;
    @Widget(selection="grade.1.up.to.10.select")
    private Integer invoicesCopySelect = 1;
    @Widget(title="Notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String note;
    @Widget(title="Specific notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String specificNotes;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile printedPDF;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total Tax", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Amount paid", readonly=true)
    private BigDecimal amountPaid = BigDecimal.ZERO;
    @Widget(title="Amount remaining", readonly=true)
    private BigDecimal amountRemaining = BigDecimal.ZERO;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total Tax", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Widget(title="Remaining to pay", readonly=true)
    private BigDecimal companyInTaxTotalRemaining = BigDecimal.ZERO;
    @Widget(readonly=true)
    private Boolean hasPendingPayments = Boolean.FALSE;
    @Widget(title="Status", readonly=true, selection="iaccount.invoice.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Validated by", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedByUser;
    @Widget(title="Validated Date", readonly=true)
    private LocalDate validatedDate;
    @Widget(title="In ATI")
    private Boolean inAti = Boolean.FALSE;
    @Widget(title="Supplier invoice number")
    private String supplierInvoiceNb;
    @Widget(title="Company bank")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @Widget(title="Send email on invoice ventilation")
    private Boolean invoiceAutomaticMail = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template invoiceMessageTemplate;
    @Widget(title="Send email on invoice validate")
    private Boolean invoiceAutomaticMailOnValidate = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template invoiceMessageTemplateOnValidate;
    @Widget(title="Advance payments")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Invoice> advancePaymentInvoiceSet;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TradingName tradingName;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PrintingSettings printingSettings;
    @Widget(title="From")
    private LocalDate subscriptionFromDate;
    @Widget(title="To")
    private LocalDate subscriptionToDate;
    @Widget(title="Subrogation release")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SubrogationRelease subrogationRelease;
    @Widget(title="Subrogation release Move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move subrogationReleaseMove;
    @Widget(title="PFP decision date", readonly=true)
    private LocalDate decisionPfpTakenDate;
    @Widget(title="PFP Validator")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User pfpValidatorUser;
    @Widget(title="Status", readonly=true, selection="invoice.pfp.validate.status.select")
    private Integer pfpValidateStatusSelect = 1;
    @Widget(title="Reason of refusal to pay")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CancelReason reasonOfRefusalToPay;
    @Widget(title="Reason of refusal to pay")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String reasonOfRefusalToPayStr;
    @Widget(title="Comment to display on proforma")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String proformaComments;
    @Widget(title="Head office address")
    private String headOfficeAddress;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PaymentSchedule getCanceledPaymentSchedule() {
        return this.canceledPaymentSchedule;
    }

    public void setCanceledPaymentSchedule(PaymentSchedule canceledPaymentSchedule) {
        this.canceledPaymentSchedule = canceledPaymentSchedule;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public Integer getOperationTypeSelect() {
        return this.operationTypeSelect == null ? 0 : this.operationTypeSelect;
    }

    public void setOperationTypeSelect(Integer operationTypeSelect) {
        this.operationTypeSelect = operationTypeSelect;
    }

    public Integer getOperationSubTypeSelect() {
        return this.operationSubTypeSelect == null ? 0 : this.operationSubTypeSelect;
    }

    public void setOperationSubTypeSelect(Integer operationSubTypeSelect) {
        this.operationSubTypeSelect = operationSubTypeSelect;
    }

    public String getPartnerTaxNbr() {
        return this.partnerTaxNbr;
    }

    public void setPartnerTaxNbr(String partnerTaxNbr) {
        this.partnerTaxNbr = partnerTaxNbr;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public Account getPartnerAccount() {
        return this.partnerAccount;
    }

    public void setPartnerAccount(Account partnerAccount) {
        this.partnerAccount = partnerAccount;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getAddressStr() {
        return this.addressStr;
    }

    public void setAddressStr(String addressStr) {
        this.addressStr = addressStr;
    }

    public String getInternalReference() {
        return this.internalReference;
    }

    public void setInternalReference(String internalReference) {
        this.internalReference = internalReference;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public void setPriceList(PriceList priceList) {
        this.priceList = priceList;
    }

    public Boolean getHideDiscount() {
        return this.hideDiscount == null ? Boolean.FALSE : this.hideDiscount;
    }

    public void setHideDiscount(Boolean hideDiscount) {
        this.hideDiscount = hideDiscount;
    }

    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public LocalDate getOriginDate() {
        return this.originDate;
    }

    public void setOriginDate(LocalDate originDate) {
        this.originDate = originDate;
    }

    public Boolean getSchedulePaymentOk() {
        return this.schedulePaymentOk == null ? Boolean.FALSE : this.schedulePaymentOk;
    }

    public void setSchedulePaymentOk(Boolean schedulePaymentOk) {
        this.schedulePaymentOk = schedulePaymentOk;
    }

    public PaymentSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public void setPaymentSchedule(PaymentSchedule paymentSchedule) {
        this.paymentSchedule = paymentSchedule;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public Move getOldMove() {
        return this.oldMove;
    }

    public void setOldMove(Move oldMove) {
        this.oldMove = oldMove;
    }

    public Boolean getDoubtfulCustomerOk() {
        return this.doubtfulCustomerOk == null ? Boolean.FALSE : this.doubtfulCustomerOk;
    }

    public void setDoubtfulCustomerOk(Boolean doubtfulCustomerOk) {
        this.doubtfulCustomerOk = doubtfulCustomerOk;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public List<InvoicePayment> getInvoicePaymentList() {
        return this.invoicePaymentList;
    }

    public void setInvoicePaymentList(List<InvoicePayment> invoicePaymentList) {
        this.invoicePaymentList = invoicePaymentList;
    }

    public void addInvoicePaymentListItem(InvoicePayment item) {
        if (this.getInvoicePaymentList() == null) {
            this.setInvoicePaymentList(new ArrayList<InvoicePayment>());
        }
        this.getInvoicePaymentList().add(item);
        item.setInvoice(this);
    }

    public void removeInvoicePaymentListItem(InvoicePayment item) {
        if (this.getInvoicePaymentList() == null) {
            return;
        }
        this.getInvoicePaymentList().remove((Object)item);
    }

    public void clearInvoicePaymentList() {
        if (this.getInvoicePaymentList() != null) {
            this.getInvoicePaymentList().clear();
        }
    }

    public LocalDate getVentilatedDate() {
        return this.ventilatedDate;
    }

    public void setVentilatedDate(LocalDate ventilatedDate) {
        this.ventilatedDate = ventilatedDate;
    }

    public User getVentilatedByUser() {
        return this.ventilatedByUser;
    }

    public void setVentilatedByUser(User ventilatedByUser) {
        this.ventilatedByUser = ventilatedByUser;
    }

    public List<InvoiceLine> getInvoiceLineList() {
        return this.invoiceLineList;
    }

    public void setInvoiceLineList(List<InvoiceLine> invoiceLineList) {
        this.invoiceLineList = invoiceLineList;
    }

    public void addInvoiceLineListItem(InvoiceLine item) {
        if (this.getInvoiceLineList() == null) {
            this.setInvoiceLineList(new ArrayList<InvoiceLine>());
        }
        this.getInvoiceLineList().add(item);
        item.setInvoice(this);
    }

    public void removeInvoiceLineListItem(InvoiceLine item) {
        if (this.getInvoiceLineList() == null) {
            return;
        }
        this.getInvoiceLineList().remove((Object)item);
    }

    public void clearInvoiceLineList() {
        if (this.getInvoiceLineList() != null) {
            this.getInvoiceLineList().clear();
        }
    }

    public List<InvoiceLineTax> getInvoiceLineTaxList() {
        return this.invoiceLineTaxList;
    }

    public void setInvoiceLineTaxList(List<InvoiceLineTax> invoiceLineTaxList) {
        this.invoiceLineTaxList = invoiceLineTaxList;
    }

    public void addInvoiceLineTaxListItem(InvoiceLineTax item) {
        if (this.getInvoiceLineTaxList() == null) {
            this.setInvoiceLineTaxList(new ArrayList<InvoiceLineTax>());
        }
        this.getInvoiceLineTaxList().add(item);
        item.setInvoice(this);
    }

    public void removeInvoiceLineTaxListItem(InvoiceLineTax item) {
        if (this.getInvoiceLineTaxList() == null) {
            return;
        }
        this.getInvoiceLineTaxList().remove((Object)item);
    }

    public void clearInvoiceLineTaxList() {
        if (this.getInvoiceLineTaxList() != null) {
            this.getInvoiceLineTaxList().clear();
        }
    }

    public Boolean getAlreadyPrintedOk() {
        return this.alreadyPrintedOk == null ? Boolean.FALSE : this.alreadyPrintedOk;
    }

    public void setAlreadyPrintedOk(Boolean alreadyPrintedOk) {
        this.alreadyPrintedOk = alreadyPrintedOk;
    }

    public Invoice getOriginalInvoice() {
        return this.originalInvoice;
    }

    public void setOriginalInvoice(Invoice originalInvoice) {
        this.originalInvoice = originalInvoice;
    }

    public List<Invoice> getRefundInvoiceList() {
        return this.refundInvoiceList;
    }

    public void setRefundInvoiceList(List<Invoice> refundInvoiceList) {
        this.refundInvoiceList = refundInvoiceList;
    }

    public void addRefundInvoiceListItem(Invoice item) {
        if (this.getRefundInvoiceList() == null) {
            this.setRefundInvoiceList(new ArrayList<Invoice>());
        }
        this.getRefundInvoiceList().add(item);
        item.setOriginalInvoice(this);
    }

    public void removeRefundInvoiceListItem(Invoice item) {
        if (this.getRefundInvoiceList() == null) {
            return;
        }
        this.getRefundInvoiceList().remove((Object)item);
    }

    public void clearRefundInvoiceList() {
        if (this.getRefundInvoiceList() != null) {
            this.getRefundInvoiceList().clear();
        }
    }

    public Integer getIrrecoverableStatusSelect() {
        return this.irrecoverableStatusSelect == null ? 0 : this.irrecoverableStatusSelect;
    }

    public void setIrrecoverableStatusSelect(Integer irrecoverableStatusSelect) {
        this.irrecoverableStatusSelect = irrecoverableStatusSelect;
    }

    public ManagementObject getManagementObject() {
        return this.managementObject;
    }

    public void setManagementObject(ManagementObject managementObject) {
        this.managementObject = managementObject;
    }

    public Invoice getStandardInvoice() {
        return this.standardInvoice;
    }

    public void setStandardInvoice(Invoice standardInvoice) {
        this.standardInvoice = standardInvoice;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public Boolean getDebitBlockingOk() {
        return this.debitBlockingOk == null ? Boolean.FALSE : this.debitBlockingOk;
    }

    public void setDebitBlockingOk(Boolean debitBlockingOk) {
        this.debitBlockingOk = debitBlockingOk;
    }

    public StopReason getDebitBlockingReason() {
        return this.debitBlockingReason;
    }

    public void setDebitBlockingReason(StopReason debitBlockingReason) {
        this.debitBlockingReason = debitBlockingReason;
    }

    public LocalDate getDebitBlockingToDate() {
        return this.debitBlockingToDate;
    }

    public void setDebitBlockingToDate(LocalDate debitBlockingToDate) {
        this.debitBlockingToDate = debitBlockingToDate;
    }

    public User getDebitBlockingByUser() {
        return this.debitBlockingByUser;
    }

    public void setDebitBlockingByUser(User debitBlockingByUser) {
        this.debitBlockingByUser = debitBlockingByUser;
    }

    public Boolean getDebtRecoveryBlockingOk() {
        return this.debtRecoveryBlockingOk == null ? Boolean.FALSE : this.debtRecoveryBlockingOk;
    }

    public void setDebtRecoveryBlockingOk(Boolean debtRecoveryBlockingOk) {
        this.debtRecoveryBlockingOk = debtRecoveryBlockingOk;
    }

    public StopReason getDebtRecoveryBlockingReason() {
        return this.debtRecoveryBlockingReason;
    }

    public void setDebtRecoveryBlockingReason(StopReason debtRecoveryBlockingReason) {
        this.debtRecoveryBlockingReason = debtRecoveryBlockingReason;
    }

    public LocalDate getDebtRecoveryBlockingToDate() {
        return this.debtRecoveryBlockingToDate;
    }

    public void setDebtRecoveryBlockingToDate(LocalDate debtRecoveryBlockingToDate) {
        this.debtRecoveryBlockingToDate = debtRecoveryBlockingToDate;
    }

    public User getDebtRecoveryBlockingByUser() {
        return this.debtRecoveryBlockingByUser;
    }

    public void setDebtRecoveryBlockingByUser(User debtRecoveryBlockingByUser) {
        this.debtRecoveryBlockingByUser = debtRecoveryBlockingByUser;
    }

    public String getDebitNumber() {
        return this.debitNumber;
    }

    public void setDebitNumber(String debitNumber) {
        this.debitNumber = debitNumber;
    }

    public DirectDebitManagement getDirectDebitManagement() {
        return this.directDebitManagement;
    }

    public void setDirectDebitManagement(DirectDebitManagement directDebitManagement) {
        this.directDebitManagement = directDebitManagement;
    }

    public MoveLine getRejectMoveLine() {
        return this.rejectMoveLine;
    }

    public void setRejectMoveLine(MoveLine rejectMoveLine) {
        this.rejectMoveLine = rejectMoveLine;
    }

    public Boolean getUsherPassageOk() {
        return this.usherPassageOk == null ? Boolean.FALSE : this.usherPassageOk;
    }

    public void setUsherPassageOk(Boolean usherPassageOk) {
        this.usherPassageOk = usherPassageOk;
    }

    public BigDecimal getAmountRejected() {
        return this.amountRejected == null ? BigDecimal.ZERO : this.amountRejected;
    }

    public void setAmountRejected(BigDecimal amountRejected) {
        this.amountRejected = amountRejected;
    }

    public LocalDate getRejectDate() {
        return this.rejectDate;
    }

    public void setRejectDate(LocalDate rejectDate) {
        this.rejectDate = rejectDate;
    }

    public InterbankCodeLine getInterbankCodeLine() {
        return this.interbankCodeLine;
    }

    public void setInterbankCodeLine(InterbankCodeLine interbankCodeLine) {
        this.interbankCodeLine = interbankCodeLine;
    }

    public BigDecimal getDirectDebitAmount() {
        return this.directDebitAmount == null ? BigDecimal.ZERO : this.directDebitAmount;
    }

    public void setDirectDebitAmount(BigDecimal directDebitAmount) {
        this.directDebitAmount = directDebitAmount;
    }

    public Move getPaymentMove() {
        return this.paymentMove;
    }

    public void setPaymentMove(Move paymentMove) {
        this.paymentMove = paymentMove;
    }

    public Integer getInvoicesCopySelect() {
        return this.invoicesCopySelect == null ? 0 : this.invoicesCopySelect;
    }

    public void setInvoicesCopySelect(Integer invoicesCopySelect) {
        this.invoicesCopySelect = invoicesCopySelect;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getSpecificNotes() {
        return this.specificNotes;
    }

    public void setSpecificNotes(String specificNotes) {
        this.specificNotes = specificNotes;
    }

    public MetaFile getPrintedPDF() {
        return this.printedPDF;
    }

    public void setPrintedPDF(MetaFile printedPDF) {
        this.printedPDF = printedPDF;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public BigDecimal getAmountPaid() {
        return this.amountPaid == null ? BigDecimal.ZERO : this.amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }

    public BigDecimal getAmountRemaining() {
        return this.amountRemaining == null ? BigDecimal.ZERO : this.amountRemaining;
    }

    public void setAmountRemaining(BigDecimal amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyTaxTotal() {
        return this.companyTaxTotal == null ? BigDecimal.ZERO : this.companyTaxTotal;
    }

    public void setCompanyTaxTotal(BigDecimal companyTaxTotal) {
        this.companyTaxTotal = companyTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotalRemaining() {
        return this.companyInTaxTotalRemaining == null ? BigDecimal.ZERO : this.companyInTaxTotalRemaining;
    }

    public void setCompanyInTaxTotalRemaining(BigDecimal companyInTaxTotalRemaining) {
        this.companyInTaxTotalRemaining = companyInTaxTotalRemaining;
    }

    public Boolean getHasPendingPayments() {
        return this.hasPendingPayments == null ? Boolean.FALSE : this.hasPendingPayments;
    }

    public void setHasPendingPayments(Boolean hasPendingPayments) {
        this.hasPendingPayments = hasPendingPayments;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public User getValidatedByUser() {
        return this.validatedByUser;
    }

    public void setValidatedByUser(User validatedByUser) {
        this.validatedByUser = validatedByUser;
    }

    public LocalDate getValidatedDate() {
        return this.validatedDate;
    }

    public void setValidatedDate(LocalDate validatedDate) {
        this.validatedDate = validatedDate;
    }

    public Boolean getInAti() {
        return this.inAti == null ? Boolean.FALSE : this.inAti;
    }

    public void setInAti(Boolean inAti) {
        this.inAti = inAti;
    }

    public String getSupplierInvoiceNb() {
        return this.supplierInvoiceNb;
    }

    public void setSupplierInvoiceNb(String supplierInvoiceNb) {
        this.supplierInvoiceNb = supplierInvoiceNb;
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public Boolean getInvoiceAutomaticMail() {
        return this.invoiceAutomaticMail == null ? Boolean.FALSE : this.invoiceAutomaticMail;
    }

    public void setInvoiceAutomaticMail(Boolean invoiceAutomaticMail) {
        this.invoiceAutomaticMail = invoiceAutomaticMail;
    }

    public Template getInvoiceMessageTemplate() {
        return this.invoiceMessageTemplate;
    }

    public void setInvoiceMessageTemplate(Template invoiceMessageTemplate) {
        this.invoiceMessageTemplate = invoiceMessageTemplate;
    }

    public Boolean getInvoiceAutomaticMailOnValidate() {
        return this.invoiceAutomaticMailOnValidate == null ? Boolean.FALSE : this.invoiceAutomaticMailOnValidate;
    }

    public void setInvoiceAutomaticMailOnValidate(Boolean invoiceAutomaticMailOnValidate) {
        this.invoiceAutomaticMailOnValidate = invoiceAutomaticMailOnValidate;
    }

    public Template getInvoiceMessageTemplateOnValidate() {
        return this.invoiceMessageTemplateOnValidate;
    }

    public void setInvoiceMessageTemplateOnValidate(Template invoiceMessageTemplateOnValidate) {
        this.invoiceMessageTemplateOnValidate = invoiceMessageTemplateOnValidate;
    }

    public Set<Invoice> getAdvancePaymentInvoiceSet() {
        return this.advancePaymentInvoiceSet;
    }

    public void setAdvancePaymentInvoiceSet(Set<Invoice> advancePaymentInvoiceSet) {
        this.advancePaymentInvoiceSet = advancePaymentInvoiceSet;
    }

    public void addAdvancePaymentInvoiceSetItem(Invoice item) {
        if (this.getAdvancePaymentInvoiceSet() == null) {
            this.setAdvancePaymentInvoiceSet(new HashSet<Invoice>());
        }
        this.getAdvancePaymentInvoiceSet().add(item);
    }

    public void removeAdvancePaymentInvoiceSetItem(Invoice item) {
        if (this.getAdvancePaymentInvoiceSet() == null) {
            return;
        }
        this.getAdvancePaymentInvoiceSet().remove((Object)item);
    }

    public void clearAdvancePaymentInvoiceSet() {
        if (this.getAdvancePaymentInvoiceSet() != null) {
            this.getAdvancePaymentInvoiceSet().clear();
        }
    }

    public TradingName getTradingName() {
        return this.tradingName;
    }

    public void setTradingName(TradingName tradingName) {
        this.tradingName = tradingName;
    }

    public PrintingSettings getPrintingSettings() {
        return this.printingSettings;
    }

    public void setPrintingSettings(PrintingSettings printingSettings) {
        this.printingSettings = printingSettings;
    }

    public LocalDate getSubscriptionFromDate() {
        return this.subscriptionFromDate;
    }

    public void setSubscriptionFromDate(LocalDate subscriptionFromDate) {
        this.subscriptionFromDate = subscriptionFromDate;
    }

    public LocalDate getSubscriptionToDate() {
        return this.subscriptionToDate;
    }

    public void setSubscriptionToDate(LocalDate subscriptionToDate) {
        this.subscriptionToDate = subscriptionToDate;
    }

    public SubrogationRelease getSubrogationRelease() {
        return this.subrogationRelease;
    }

    public void setSubrogationRelease(SubrogationRelease subrogationRelease) {
        this.subrogationRelease = subrogationRelease;
    }

    public Move getSubrogationReleaseMove() {
        return this.subrogationReleaseMove;
    }

    public void setSubrogationReleaseMove(Move subrogationReleaseMove) {
        this.subrogationReleaseMove = subrogationReleaseMove;
    }

    public LocalDate getDecisionPfpTakenDate() {
        return this.decisionPfpTakenDate;
    }

    public void setDecisionPfpTakenDate(LocalDate decisionPfpTakenDate) {
        this.decisionPfpTakenDate = decisionPfpTakenDate;
    }

    public User getPfpValidatorUser() {
        return this.pfpValidatorUser;
    }

    public void setPfpValidatorUser(User pfpValidatorUser) {
        this.pfpValidatorUser = pfpValidatorUser;
    }

    public Integer getPfpValidateStatusSelect() {
        return this.pfpValidateStatusSelect == null ? 0 : this.pfpValidateStatusSelect;
    }

    public void setPfpValidateStatusSelect(Integer pfpValidateStatusSelect) {
        this.pfpValidateStatusSelect = pfpValidateStatusSelect;
    }

    public CancelReason getReasonOfRefusalToPay() {
        return this.reasonOfRefusalToPay;
    }

    public void setReasonOfRefusalToPay(CancelReason reasonOfRefusalToPay) {
        this.reasonOfRefusalToPay = reasonOfRefusalToPay;
    }

    public String getReasonOfRefusalToPayStr() {
        return this.reasonOfRefusalToPayStr;
    }

    public void setReasonOfRefusalToPayStr(String reasonOfRefusalToPayStr) {
        this.reasonOfRefusalToPayStr = reasonOfRefusalToPayStr;
    }

    public String getProformaComments() {
        return this.proformaComments;
    }

    public void setProformaComments(String proformaComments) {
        this.proformaComments = proformaComments;
    }

    public String getHeadOfficeAddress() {
        return this.headOfficeAddress;
    }

    public void setHeadOfficeAddress(String headOfficeAddress) {
        this.headOfficeAddress = headOfficeAddress;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("invoiceId", (Object)this.getInvoiceId()).add("operationTypeSelect", (Object)this.getOperationTypeSelect()).add("operationSubTypeSelect", (Object)this.getOperationSubTypeSelect()).add("partnerTaxNbr", (Object)this.getPartnerTaxNbr()).add("internalReference", (Object)this.getInternalReference()).add("externalReference", (Object)this.getExternalReference()).add("hideDiscount", (Object)this.getHideDiscount()).add("invoiceDate", (Object)this.getInvoiceDate()).add("dueDate", (Object)this.getDueDate()).add("originDate", (Object)this.getOriginDate()).add("schedulePaymentOk", (Object)this.getSchedulePaymentOk()).omitNullValues().toString();
    }
}

