/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Budget;
import com.axelor.apps.account.db.BudgetDistribution;
import com.axelor.apps.account.db.FixedAssetCategory;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_INVOICE_LINE", indexes={@Index(columnList="invoice"), @Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="tax_line"), @Index(columnList="tax_equiv"), @Index(columnList="analytic_distribution_template"), @Index(columnList="budget"), @Index(columnList="account"), @Index(columnList="fixed_asset_category"), @Index(columnList="name")})
public class InvoiceLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INVOICE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_INVOICE_LINE_SEQ", sequenceName="ACCOUNT_INVOICE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Invoice")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @Widget(title="Seq.")
    private Integer sequence = 0;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Product Name")
    private String productName;
    @Widget(title="Product Code")
    private String productCode;
    @Widget(title="Unit price W.T.")
    @Digits(integer=10, fraction=10)
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Unit price A.T.I.")
    @Digits(integer=10, fraction=10)
    private BigDecimal inTaxPrice = BigDecimal.ZERO;
    @Widget(title="Unit price discounted")
    @Digits(integer=10, fraction=10)
    private BigDecimal priceDiscounted = BigDecimal.ZERO;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Qty")
    @Digits(integer=18, fraction=2)
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(hidden=true)
    private BigDecimal oldQty = BigDecimal.ZERO;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.")
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Tax Equiv")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxEquiv taxEquiv;
    @Widget(title="Discount amount")
    @Digits(integer=10, fraction=10)
    private BigDecimal discountAmount = BigDecimal.ZERO;
    @Widget(title="Discount Type", selection="base.price.list.line.amount.type.select")
    private Integer discountTypeSelect = 0;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Fixed Assets")
    private Boolean fixedAssets = Boolean.FALSE;
    @Widget(title="Total W.T. in Acc. currency", hidden=true)
    private BigDecimal companyExTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I. in company currency", hidden=true)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Widget(title="Analytic distribution lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoiceLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AnalyticMoveLine> analyticMoveLineList;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Budget")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Budget budget;
    @Widget(title="Budget Distribution")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="invoiceLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BudgetDistribution> budgetDistributionList;
    @Widget(title="Total amount attributed")
    private BigDecimal budgetDistributionSumAmount = BigDecimal.ZERO;
    @Widget(title="Accounting.Account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account account;
    @Widget(title="Fixed asset category")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FixedAssetCategory fixedAssetCategory;
    @Widget(title="Type", selection="line.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Sub line", readonly=true)
    private Boolean isSubLine = Boolean.FALSE;
    @Widget(title="Pack price select", selection="product.pack.price.select")
    private Integer packPriceSelect = 0;
    @Widget(title="Total for pack lines")
    private BigDecimal totalPack = BigDecimal.ZERO;
    @Widget(readonly=true)
    @Digits(integer=17, fraction=3)
    private BigDecimal taxRate = BigDecimal.ZERO;
    @Widget(readonly=true)
    private String taxCode;
    @Widget(title="Name", search={"invoice", "productName"})
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public InvoiceLine() {
    }

    public InvoiceLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getInTaxPrice() {
        return this.inTaxPrice == null ? BigDecimal.ZERO : this.inTaxPrice;
    }

    public void setInTaxPrice(BigDecimal inTaxPrice) {
        this.inTaxPrice = inTaxPrice;
    }

    public BigDecimal getPriceDiscounted() {
        return this.priceDiscounted == null ? BigDecimal.ZERO : this.priceDiscounted;
    }

    public void setPriceDiscounted(BigDecimal priceDiscounted) {
        this.priceDiscounted = priceDiscounted;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getOldQty() {
        return this.oldQty == null ? BigDecimal.ZERO : this.oldQty;
    }

    public void setOldQty(BigDecimal oldQty) {
        this.oldQty = oldQty;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public TaxEquiv getTaxEquiv() {
        return this.taxEquiv;
    }

    public void setTaxEquiv(TaxEquiv taxEquiv) {
        this.taxEquiv = taxEquiv;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount == null ? BigDecimal.ZERO : this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Integer getDiscountTypeSelect() {
        return this.discountTypeSelect == null ? 0 : this.discountTypeSelect;
    }

    public void setDiscountTypeSelect(Integer discountTypeSelect) {
        this.discountTypeSelect = discountTypeSelect;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getFixedAssets() {
        return this.fixedAssets == null ? Boolean.FALSE : this.fixedAssets;
    }

    public void setFixedAssets(Boolean fixedAssets) {
        this.fixedAssets = fixedAssets;
    }

    public BigDecimal getCompanyExTaxTotal() {
        return this.companyExTaxTotal == null ? BigDecimal.ZERO : this.companyExTaxTotal;
    }

    public void setCompanyExTaxTotal(BigDecimal companyExTaxTotal) {
        this.companyExTaxTotal = companyExTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public List<AnalyticMoveLine> getAnalyticMoveLineList() {
        return this.analyticMoveLineList;
    }

    public void setAnalyticMoveLineList(List<AnalyticMoveLine> analyticMoveLineList) {
        this.analyticMoveLineList = analyticMoveLineList;
    }

    public void addAnalyticMoveLineListItem(AnalyticMoveLine item) {
        if (this.getAnalyticMoveLineList() == null) {
            this.setAnalyticMoveLineList(new ArrayList<AnalyticMoveLine>());
        }
        this.getAnalyticMoveLineList().add(item);
        item.setInvoiceLine(this);
    }

    public void removeAnalyticMoveLineListItem(AnalyticMoveLine item) {
        if (this.getAnalyticMoveLineList() == null) {
            return;
        }
        this.getAnalyticMoveLineList().remove((Object)item);
    }

    public void clearAnalyticMoveLineList() {
        if (this.getAnalyticMoveLineList() != null) {
            this.getAnalyticMoveLineList().clear();
        }
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public List<BudgetDistribution> getBudgetDistributionList() {
        return this.budgetDistributionList;
    }

    public void setBudgetDistributionList(List<BudgetDistribution> budgetDistributionList) {
        this.budgetDistributionList = budgetDistributionList;
    }

    public void addBudgetDistributionListItem(BudgetDistribution item) {
        if (this.getBudgetDistributionList() == null) {
            this.setBudgetDistributionList(new ArrayList<BudgetDistribution>());
        }
        this.getBudgetDistributionList().add(item);
        item.setInvoiceLine(this);
    }

    public void removeBudgetDistributionListItem(BudgetDistribution item) {
        if (this.getBudgetDistributionList() == null) {
            return;
        }
        this.getBudgetDistributionList().remove((Object)item);
    }

    public void clearBudgetDistributionList() {
        if (this.getBudgetDistributionList() != null) {
            this.getBudgetDistributionList().clear();
        }
    }

    public BigDecimal getBudgetDistributionSumAmount() {
        return this.budgetDistributionSumAmount == null ? BigDecimal.ZERO : this.budgetDistributionSumAmount;
    }

    public void setBudgetDistributionSumAmount(BigDecimal budgetDistributionSumAmount) {
        this.budgetDistributionSumAmount = budgetDistributionSumAmount;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public FixedAssetCategory getFixedAssetCategory() {
        return this.fixedAssetCategory;
    }

    public void setFixedAssetCategory(FixedAssetCategory fixedAssetCategory) {
        this.fixedAssetCategory = fixedAssetCategory;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Boolean getIsSubLine() {
        return this.isSubLine == null ? Boolean.FALSE : this.isSubLine;
    }

    public void setIsSubLine(Boolean isSubLine) {
        this.isSubLine = isSubLine;
    }

    public Integer getPackPriceSelect() {
        return this.packPriceSelect == null ? 0 : this.packPriceSelect;
    }

    public void setPackPriceSelect(Integer packPriceSelect) {
        this.packPriceSelect = packPriceSelect;
    }

    public BigDecimal getTotalPack() {
        return this.totalPack == null ? BigDecimal.ZERO : this.totalPack;
    }

    public void setTotalPack(BigDecimal totalPack) {
        this.totalPack = totalPack;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate == null ? BigDecimal.ZERO : this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = "";
        if (this.invoice != null && this.invoice.getInvoiceId() != null) {
            name = name + this.invoice.getInvoiceId();
        }
        if (this.productName != null) {
            name = name + "-";
            name = this.productName.length() > 100 ? name + this.productName.substring(1, 100) : name + this.productName;
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvoiceLine)) {
            return false;
        }
        InvoiceLine other = (InvoiceLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("productName", (Object)this.getProductName()).add("productCode", (Object)this.getProductCode()).add("price", (Object)this.getPrice()).add("inTaxPrice", (Object)this.getInTaxPrice()).add("priceDiscounted", (Object)this.getPriceDiscounted()).add("qty", (Object)this.getQty()).add("oldQty", (Object)this.getOldQty()).add("exTaxTotal", (Object)this.getExTaxTotal()).add("inTaxTotal", (Object)this.getInTaxTotal()).add("discountAmount", (Object)this.getDiscountAmount()).omitNullValues().toString();
    }
}

