/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_INVOICE_LINE_TAX", indexes={@Index(columnList="invoice"), @Index(columnList="tax_line")})
public class InvoiceLineTax
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_INVOICE_LINE_TAX_SEQ")
    @SequenceGenerator(name="ACCOUNT_INVOICE_LINE_TAX_SEQ", sequenceName="ACCOUNT_INVOICE_LINE_TAX_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Invoice")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @Widget(title="Base W.T.")
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxBase = BigDecimal.ZERO;
    @Widget(title="Amount Tax")
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Amount A.T.I.")
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Base W.T. in Acc. currency.", hidden=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyExTaxBase = BigDecimal.ZERO;
    @Widget(title="Amount Tax in Acc. currency", hidden=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyTaxTotal = BigDecimal.ZERO;
    @Widget(title="Amount A.T.I. in Acc. currency", hidden=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal companyInTaxTotal = BigDecimal.ZERO;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    private Boolean reverseCharged = Boolean.FALSE;
    private BigDecimal subTotalExcludingFixedAssets = BigDecimal.ZERO;
    private BigDecimal subTotalOfFixedAssets = BigDecimal.ZERO;
    private BigDecimal companySubTotalExcludingFixedAssets = BigDecimal.ZERO;
    private BigDecimal companySubTotalOfFixedAssets = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public BigDecimal getExTaxBase() {
        return this.exTaxBase == null ? BigDecimal.ZERO : this.exTaxBase;
    }

    public void setExTaxBase(BigDecimal exTaxBase) {
        this.exTaxBase = exTaxBase;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public BigDecimal getCompanyExTaxBase() {
        return this.companyExTaxBase == null ? BigDecimal.ZERO : this.companyExTaxBase;
    }

    public void setCompanyExTaxBase(BigDecimal companyExTaxBase) {
        this.companyExTaxBase = companyExTaxBase;
    }

    public BigDecimal getCompanyTaxTotal() {
        return this.companyTaxTotal == null ? BigDecimal.ZERO : this.companyTaxTotal;
    }

    public void setCompanyTaxTotal(BigDecimal companyTaxTotal) {
        this.companyTaxTotal = companyTaxTotal;
    }

    public BigDecimal getCompanyInTaxTotal() {
        return this.companyInTaxTotal == null ? BigDecimal.ZERO : this.companyInTaxTotal;
    }

    public void setCompanyInTaxTotal(BigDecimal companyInTaxTotal) {
        this.companyInTaxTotal = companyInTaxTotal;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public Boolean getReverseCharged() {
        return this.reverseCharged == null ? Boolean.FALSE : this.reverseCharged;
    }

    public void setReverseCharged(Boolean reverseCharged) {
        this.reverseCharged = reverseCharged;
    }

    public BigDecimal getSubTotalExcludingFixedAssets() {
        return this.subTotalExcludingFixedAssets == null ? BigDecimal.ZERO : this.subTotalExcludingFixedAssets;
    }

    public void setSubTotalExcludingFixedAssets(BigDecimal subTotalExcludingFixedAssets) {
        this.subTotalExcludingFixedAssets = subTotalExcludingFixedAssets;
    }

    public BigDecimal getSubTotalOfFixedAssets() {
        return this.subTotalOfFixedAssets == null ? BigDecimal.ZERO : this.subTotalOfFixedAssets;
    }

    public void setSubTotalOfFixedAssets(BigDecimal subTotalOfFixedAssets) {
        this.subTotalOfFixedAssets = subTotalOfFixedAssets;
    }

    public BigDecimal getCompanySubTotalExcludingFixedAssets() {
        return this.companySubTotalExcludingFixedAssets == null ? BigDecimal.ZERO : this.companySubTotalExcludingFixedAssets;
    }

    public void setCompanySubTotalExcludingFixedAssets(BigDecimal companySubTotalExcludingFixedAssets) {
        this.companySubTotalExcludingFixedAssets = companySubTotalExcludingFixedAssets;
    }

    public BigDecimal getCompanySubTotalOfFixedAssets() {
        return this.companySubTotalOfFixedAssets == null ? BigDecimal.ZERO : this.companySubTotalOfFixedAssets;
    }

    public void setCompanySubTotalOfFixedAssets(BigDecimal companySubTotalOfFixedAssets) {
        this.companySubTotalOfFixedAssets = companySubTotalOfFixedAssets;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvoiceLineTax)) {
            return false;
        }
        InvoiceLineTax other = (InvoiceLineTax)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("exTaxBase", (Object)this.getExTaxBase()).add("taxTotal", (Object)this.getTaxTotal()).add("inTaxTotal", (Object)this.getInTaxTotal()).add("companyExTaxBase", (Object)this.getCompanyExTaxBase()).add("companyTaxTotal", (Object)this.getCompanyTaxTotal()).add("companyInTaxTotal", (Object)this.getCompanyInTaxTotal()).add("reverseCharged", (Object)this.getReverseCharged()).add("subTotalExcludingFixedAssets", (Object)this.getSubTotalExcludingFixedAssets()).add("subTotalOfFixedAssets", (Object)this.getSubTotalOfFixedAssets()).add("companySubTotalExcludingFixedAssets", (Object)this.getCompanySubTotalExcludingFixedAssets()).add("companySubTotalOfFixedAssets", (Object)this.getCompanySubTotalOfFixedAssets()).omitNullValues().toString();
    }
}

