/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.IrrecoverableCustomerLine;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_IRRECOVERABLE", uniqueConstraints={@UniqueConstraint(columnNames={"name", "company"})}, indexes={@Index(columnList="name"), @Index(columnList="user_id"), @Index(columnList="company")})
public class Irrecoverable
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_IRRECOVERABLE_SEQ")
    @SequenceGenerator(name="ACCOUNT_IRRECOVERABLE_SEQ", sequenceName="ACCOUNT_IRRECOVERABLE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name", readonly=true)
    private String name;
    @Widget(title="Customer(s)")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="irrecoverable", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<IrrecoverableCustomerLine> irrecoverableCustomerLineList;
    @Widget(title="Invoice & Rejects")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Invoice> invoiceSet;
    @Widget(title="Payment schedule(s) rejected")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<PaymentScheduleLine> paymentScheduleLineSet;
    @Widget(title="Moves generated")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Move> moveSet;
    @Widget(title="Status", readonly=true, selection="iaccount.irrecoverable.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Date", readonly=true)
    private ZonedDateTime dateTime;
    @Widget(title="User", readonly=true)
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Export file type", selection="iadministration.export.type.select")
    private String exportTypeSelect;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Irrecoverable() {
    }

    public Irrecoverable(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<IrrecoverableCustomerLine> getIrrecoverableCustomerLineList() {
        return this.irrecoverableCustomerLineList;
    }

    public void setIrrecoverableCustomerLineList(List<IrrecoverableCustomerLine> irrecoverableCustomerLineList) {
        this.irrecoverableCustomerLineList = irrecoverableCustomerLineList;
    }

    public void addIrrecoverableCustomerLineListItem(IrrecoverableCustomerLine item) {
        if (this.getIrrecoverableCustomerLineList() == null) {
            this.setIrrecoverableCustomerLineList(new ArrayList<IrrecoverableCustomerLine>());
        }
        this.getIrrecoverableCustomerLineList().add(item);
        item.setIrrecoverable(this);
    }

    public void removeIrrecoverableCustomerLineListItem(IrrecoverableCustomerLine item) {
        if (this.getIrrecoverableCustomerLineList() == null) {
            return;
        }
        this.getIrrecoverableCustomerLineList().remove((Object)item);
    }

    public void clearIrrecoverableCustomerLineList() {
        if (this.getIrrecoverableCustomerLineList() != null) {
            this.getIrrecoverableCustomerLineList().clear();
        }
    }

    public Set<Invoice> getInvoiceSet() {
        return this.invoiceSet;
    }

    public void setInvoiceSet(Set<Invoice> invoiceSet) {
        this.invoiceSet = invoiceSet;
    }

    public void addInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            this.setInvoiceSet(new HashSet<Invoice>());
        }
        this.getInvoiceSet().add(item);
    }

    public void removeInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            return;
        }
        this.getInvoiceSet().remove((Object)item);
    }

    public void clearInvoiceSet() {
        if (this.getInvoiceSet() != null) {
            this.getInvoiceSet().clear();
        }
    }

    public Set<PaymentScheduleLine> getPaymentScheduleLineSet() {
        return this.paymentScheduleLineSet;
    }

    public void setPaymentScheduleLineSet(Set<PaymentScheduleLine> paymentScheduleLineSet) {
        this.paymentScheduleLineSet = paymentScheduleLineSet;
    }

    public void addPaymentScheduleLineSetItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineSet() == null) {
            this.setPaymentScheduleLineSet(new HashSet<PaymentScheduleLine>());
        }
        this.getPaymentScheduleLineSet().add(item);
    }

    public void removePaymentScheduleLineSetItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineSet() == null) {
            return;
        }
        this.getPaymentScheduleLineSet().remove((Object)item);
    }

    public void clearPaymentScheduleLineSet() {
        if (this.getPaymentScheduleLineSet() != null) {
            this.getPaymentScheduleLineSet().clear();
        }
    }

    public Set<Move> getMoveSet() {
        return this.moveSet;
    }

    public void setMoveSet(Set<Move> moveSet) {
        this.moveSet = moveSet;
    }

    public void addMoveSetItem(Move item) {
        if (this.getMoveSet() == null) {
            this.setMoveSet(new HashSet<Move>());
        }
        this.getMoveSet().add(item);
    }

    public void removeMoveSetItem(Move item) {
        if (this.getMoveSet() == null) {
            return;
        }
        this.getMoveSet().remove((Object)item);
    }

    public void clearMoveSet() {
        if (this.getMoveSet() != null) {
            this.getMoveSet().clear();
        }
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(ZonedDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getExportTypeSelect() {
        return this.exportTypeSelect;
    }

    public void setExportTypeSelect(String exportTypeSelect) {
        this.exportTypeSelect = exportTypeSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Irrecoverable)) {
            return false;
        }
        Irrecoverable other = (Irrecoverable)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("statusSelect", (Object)this.getStatusSelect()).add("dateTime", (Object)this.getDateTime()).add("exportTypeSelect", (Object)this.getExportTypeSelect()).omitNullValues().toString();
    }
}

