/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Irrecoverable;
import com.axelor.apps.account.db.IrrecoverableInvoiceLine;
import com.axelor.apps.account.db.IrrecoverablePaymentScheduleLineLine;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_IRRECOVERABLE_CUSTOMER_LINE", indexes={@Index(columnList="partner"), @Index(columnList="irrecoverable")})
public class IrrecoverableCustomerLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_IRRECOVERABLE_CUSTOMER_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_IRRECOVERABLE_CUSTOMER_LINE_SEQ", sequenceName="ACCOUNT_IRRECOVERABLE_CUSTOMER_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Payment(s) schedule(s) rejected")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<PaymentScheduleLine> paymentScheduleLineSet;
    @Widget(title="Invoices")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="irrecoverableCustomerLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<IrrecoverableInvoiceLine> irrecoverableInvoiceLineList;
    @Widget(title="Invoices")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="irrecoverableCustomerLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<IrrecoverablePaymentScheduleLineLine> irrecoverablePaymentScheduleLineLineList;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Irrecoverable irrecoverable;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Set<PaymentScheduleLine> getPaymentScheduleLineSet() {
        return this.paymentScheduleLineSet;
    }

    public void setPaymentScheduleLineSet(Set<PaymentScheduleLine> paymentScheduleLineSet) {
        this.paymentScheduleLineSet = paymentScheduleLineSet;
    }

    public void addPaymentScheduleLineSetItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineSet() == null) {
            this.setPaymentScheduleLineSet(new HashSet<PaymentScheduleLine>());
        }
        this.getPaymentScheduleLineSet().add(item);
    }

    public void removePaymentScheduleLineSetItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineSet() == null) {
            return;
        }
        this.getPaymentScheduleLineSet().remove((Object)item);
    }

    public void clearPaymentScheduleLineSet() {
        if (this.getPaymentScheduleLineSet() != null) {
            this.getPaymentScheduleLineSet().clear();
        }
    }

    public List<IrrecoverableInvoiceLine> getIrrecoverableInvoiceLineList() {
        return this.irrecoverableInvoiceLineList;
    }

    public void setIrrecoverableInvoiceLineList(List<IrrecoverableInvoiceLine> irrecoverableInvoiceLineList) {
        this.irrecoverableInvoiceLineList = irrecoverableInvoiceLineList;
    }

    public void addIrrecoverableInvoiceLineListItem(IrrecoverableInvoiceLine item) {
        if (this.getIrrecoverableInvoiceLineList() == null) {
            this.setIrrecoverableInvoiceLineList(new ArrayList<IrrecoverableInvoiceLine>());
        }
        this.getIrrecoverableInvoiceLineList().add(item);
        item.setIrrecoverableCustomerLine(this);
    }

    public void removeIrrecoverableInvoiceLineListItem(IrrecoverableInvoiceLine item) {
        if (this.getIrrecoverableInvoiceLineList() == null) {
            return;
        }
        this.getIrrecoverableInvoiceLineList().remove((Object)item);
    }

    public void clearIrrecoverableInvoiceLineList() {
        if (this.getIrrecoverableInvoiceLineList() != null) {
            this.getIrrecoverableInvoiceLineList().clear();
        }
    }

    public List<IrrecoverablePaymentScheduleLineLine> getIrrecoverablePaymentScheduleLineLineList() {
        return this.irrecoverablePaymentScheduleLineLineList;
    }

    public void setIrrecoverablePaymentScheduleLineLineList(List<IrrecoverablePaymentScheduleLineLine> irrecoverablePaymentScheduleLineLineList) {
        this.irrecoverablePaymentScheduleLineLineList = irrecoverablePaymentScheduleLineLineList;
    }

    public void addIrrecoverablePaymentScheduleLineLineListItem(IrrecoverablePaymentScheduleLineLine item) {
        if (this.getIrrecoverablePaymentScheduleLineLineList() == null) {
            this.setIrrecoverablePaymentScheduleLineLineList(new ArrayList<IrrecoverablePaymentScheduleLineLine>());
        }
        this.getIrrecoverablePaymentScheduleLineLineList().add(item);
        item.setIrrecoverableCustomerLine(this);
    }

    public void removeIrrecoverablePaymentScheduleLineLineListItem(IrrecoverablePaymentScheduleLineLine item) {
        if (this.getIrrecoverablePaymentScheduleLineLineList() == null) {
            return;
        }
        this.getIrrecoverablePaymentScheduleLineLineList().remove((Object)item);
    }

    public void clearIrrecoverablePaymentScheduleLineLineList() {
        if (this.getIrrecoverablePaymentScheduleLineLineList() != null) {
            this.getIrrecoverablePaymentScheduleLineLineList().clear();
        }
    }

    public Irrecoverable getIrrecoverable() {
        return this.irrecoverable;
    }

    public void setIrrecoverable(Irrecoverable irrecoverable) {
        this.irrecoverable = irrecoverable;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IrrecoverableCustomerLine)) {
            return false;
        }
        IrrecoverableCustomerLine other = (IrrecoverableCustomerLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).omitNullValues().toString();
    }
}

