/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.IrrecoverableCustomerLine;
import com.axelor.apps.account.db.IrrecoverableReportLine;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_IRRECOVERABLE_PAYMENT_SCHEDULE_LINE_LINE", indexes={@Index(name="idx_acc_irreco_paym_schedule_line_line_irreco_cust_line", columnList="irrecoverable_customer_line"), @Index(name="idx_acc_irreco_paym_schedule_line_line_paym_schedule_line", columnList="payment_schedule_line"), @Index(columnList="name")})
public class IrrecoverablePaymentScheduleLineLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_IRRECOVERABLE_PAYMENT_SCHEDULE_LINE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_IRRECOVERABLE_PAYMENT_SCHEDULE_LINE_LINE_SEQ", sequenceName="ACCOUNT_IRRECOVERABLE_PAYMENT_SCHEDULE_LINE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private IrrecoverableCustomerLine irrecoverableCustomerLine;
    @Widget(title="Rejected schedule line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentScheduleLine paymentScheduleLine;
    @Widget(title="Reportings")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="irrecoverablePaymentScheduleLineLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<IrrecoverableReportLine> irrecoverableReportLineList;
    @Widget(title="Name")
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public IrrecoverablePaymentScheduleLineLine() {
    }

    public IrrecoverablePaymentScheduleLineLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IrrecoverableCustomerLine getIrrecoverableCustomerLine() {
        return this.irrecoverableCustomerLine;
    }

    public void setIrrecoverableCustomerLine(IrrecoverableCustomerLine irrecoverableCustomerLine) {
        this.irrecoverableCustomerLine = irrecoverableCustomerLine;
    }

    public PaymentScheduleLine getPaymentScheduleLine() {
        return this.paymentScheduleLine;
    }

    public void setPaymentScheduleLine(PaymentScheduleLine paymentScheduleLine) {
        this.paymentScheduleLine = paymentScheduleLine;
    }

    public List<IrrecoverableReportLine> getIrrecoverableReportLineList() {
        return this.irrecoverableReportLineList;
    }

    public void setIrrecoverableReportLineList(List<IrrecoverableReportLine> irrecoverableReportLineList) {
        this.irrecoverableReportLineList = irrecoverableReportLineList;
    }

    public void addIrrecoverableReportLineListItem(IrrecoverableReportLine item) {
        if (this.getIrrecoverableReportLineList() == null) {
            this.setIrrecoverableReportLineList(new ArrayList<IrrecoverableReportLine>());
        }
        this.getIrrecoverableReportLineList().add(item);
        item.setIrrecoverablePaymentScheduleLineLine(this);
    }

    public void removeIrrecoverableReportLineListItem(IrrecoverableReportLine item) {
        if (this.getIrrecoverableReportLineList() == null) {
            return;
        }
        this.getIrrecoverableReportLineList().remove((Object)item);
    }

    public void clearIrrecoverableReportLineList() {
        if (this.getIrrecoverableReportLineList() != null) {
            this.getIrrecoverableReportLineList().clear();
        }
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.paymentScheduleLine != null && this.paymentScheduleLine.getName() != null) {
            return this.paymentScheduleLine.getName();
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IrrecoverablePaymentScheduleLineLine)) {
            return false;
        }
        IrrecoverablePaymentScheduleLineLine other = (IrrecoverablePaymentScheduleLineLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).omitNullValues().toString();
    }
}

