/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_JOURNAL_TYPE")
public class JournalType
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_JOURNAL_TYPE_SEQ")
    @SequenceGenerator(name="ACCOUNT_JOURNAL_TYPE_SEQ", sequenceName="ACCOUNT_JOURNAL_TYPE_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Name")
    @NotNull
    @Column(unique=true)
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Size(min=2)
    @Column(unique=true)
    private String code;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public JournalType() {
    }

    public JournalType(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JournalType)) {
            return false;
        }
        JournalType other = (JournalType)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(1645078257, this.getName(), this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).omitNullValues().toString();
    }
}

