/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.MoveTemplate;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_MOVE_TEMPLATE_LINE", indexes={@Index(columnList="move_template"), @Index(columnList="name"), @Index(columnList="product"), @Index(columnList="account"), @Index(columnList="analytic_distribution_template"), @Index(columnList="partner"), @Index(columnList="tax")})
public class MoveTemplateLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_MOVE_TEMPLATE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_MOVE_TEMPLATE_LINE_SEQ", sequenceName="ACCOUNT_MOVE_TEMPLATE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Move template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveTemplate moveTemplate;
    @Widget(title="Label")
    private String name;
    @Widget(title="Debit/Credit", selection="move.template.line.debit.credit.select")
    private String debitCreditSelect;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Accounting.Account")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account account;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Debit")
    private BigDecimal debit = BigDecimal.ZERO;
    @Widget(title="Credit")
    private BigDecimal credit = BigDecimal.ZERO;
    @Widget(title="Percentage")
    @DecimalMin(value="0")
    @DecimalMax(value="100")
    @Digits(integer=18, fraction=2)
    private BigDecimal percentage = BigDecimal.ZERO;
    @Widget(title="Partner to debit")
    private Boolean hasPartnerToDebit = Boolean.FALSE;
    @Widget(title="Partner to credit")
    private Boolean hasPartnerToCredit = Boolean.FALSE;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Tax tax;
    @Widget(title="Valid")
    private Boolean isValid = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public MoveTemplateLine() {
    }

    public MoveTemplateLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MoveTemplate getMoveTemplate() {
        return this.moveTemplate;
    }

    public void setMoveTemplate(MoveTemplate moveTemplate) {
        this.moveTemplate = moveTemplate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDebitCreditSelect() {
        return this.debitCreditSelect;
    }

    public void setDebitCreditSelect(String debitCreditSelect) {
        this.debitCreditSelect = debitCreditSelect;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public BigDecimal getDebit() {
        return this.debit == null ? BigDecimal.ZERO : this.debit;
    }

    public void setDebit(BigDecimal debit) {
        this.debit = debit;
    }

    public BigDecimal getCredit() {
        return this.credit == null ? BigDecimal.ZERO : this.credit;
    }

    public void setCredit(BigDecimal credit) {
        this.credit = credit;
    }

    public BigDecimal getPercentage() {
        return this.percentage == null ? BigDecimal.ZERO : this.percentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    public Boolean getHasPartnerToDebit() {
        return this.hasPartnerToDebit == null ? Boolean.FALSE : this.hasPartnerToDebit;
    }

    public void setHasPartnerToDebit(Boolean hasPartnerToDebit) {
        this.hasPartnerToDebit = hasPartnerToDebit;
    }

    public Boolean getHasPartnerToCredit() {
        return this.hasPartnerToCredit == null ? Boolean.FALSE : this.hasPartnerToCredit;
    }

    public void setHasPartnerToCredit(Boolean hasPartnerToCredit) {
        this.hasPartnerToCredit = hasPartnerToCredit;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Tax getTax() {
        return this.tax;
    }

    public void setTax(Tax tax) {
        this.tax = tax;
    }

    public Boolean getIsValid() {
        return this.isValid == null ? Boolean.FALSE : this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MoveTemplateLine)) {
            return false;
        }
        MoveTemplateLine other = (MoveTemplateLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("debitCreditSelect", (Object)this.getDebitCreditSelect()).add("debit", (Object)this.getDebit()).add("credit", (Object)this.getCredit()).add("percentage", (Object)this.getPercentage()).add("hasPartnerToDebit", (Object)this.getHasPartnerToDebit()).add("hasPartnerToCredit", (Object)this.getHasPartnerToCredit()).add("isValid", (Object)this.getIsValid()).omitNullValues().toString();
    }
}

