/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_PAY_VOUCHER_DUE_ELEMENT", indexes={@Index(columnList="payment_voucher"), @Index(columnList="move_line"), @Index(columnList="currency")})
public class PayVoucherDueElement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAY_VOUCHER_DUE_ELEMENT_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAY_VOUCHER_DUE_ELEMENT_SEQ", sequenceName="ACCOUNT_PAY_VOUCHER_DUE_ELEMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Payment", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentVoucher paymentVoucher;
    @Widget(title="Move Line", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine moveLine;
    @Widget(title="Due amount", readonly=true)
    private BigDecimal dueAmount = BigDecimal.ZERO;
    @Widget(title="Amount already paid", readonly=true)
    private BigDecimal paidAmount = BigDecimal.ZERO;
    @Widget(title="Amount remaining", readonly=true)
    private BigDecimal amountRemaining = BigDecimal.ZERO;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PaymentVoucher getPaymentVoucher() {
        return this.paymentVoucher;
    }

    public void setPaymentVoucher(PaymentVoucher paymentVoucher) {
        this.paymentVoucher = paymentVoucher;
    }

    public MoveLine getMoveLine() {
        return this.moveLine;
    }

    public void setMoveLine(MoveLine moveLine) {
        this.moveLine = moveLine;
    }

    public BigDecimal getDueAmount() {
        return this.dueAmount == null ? BigDecimal.ZERO : this.dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public BigDecimal getPaidAmount() {
        return this.paidAmount == null ? BigDecimal.ZERO : this.paidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    public BigDecimal getAmountRemaining() {
        return this.amountRemaining == null ? BigDecimal.ZERO : this.amountRemaining;
    }

    public void setAmountRemaining(BigDecimal amountRemaining) {
        this.amountRemaining = amountRemaining;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PayVoucherDueElement)) {
            return false;
        }
        PayVoucherDueElement other = (PayVoucherDueElement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("dueAmount", (Object)this.getDueAmount()).add("paidAmount", (Object)this.getPaidAmount()).add("amountRemaining", (Object)this.getAmountRemaining()).omitNullValues().toString();
    }
}

