/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.DebtRecoveryLevel;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_PAYER_QUALITY_CONFIG_LINE", indexes={@Index(columnList="debt_recovery_level"), @Index(columnList="name")})
public class PayerQualityConfigLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYER_QUALITY_CONFIG_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYER_QUALITY_CONFIG_LINE_SEQ", sequenceName="ACCOUNT_PAYER_QUALITY_CONFIG_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Incident type", selection="payer.quality.config.line.incident.type.select")
    private Integer incidentTypeSelect = 0;
    @Widget(title="Debt recovery level")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryLevel debtRecoveryLevel;
    @Widget(title="Burden (weight)")
    private BigDecimal burden = BigDecimal.ZERO;
    @Widget(title="Description")
    private String description;
    @Widget(title="Reject type")
    private String rejectType;
    @Widget(title="Label")
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public PayerQualityConfigLine() {
    }

    public PayerQualityConfigLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getIncidentTypeSelect() {
        return this.incidentTypeSelect == null ? 0 : this.incidentTypeSelect;
    }

    public void setIncidentTypeSelect(Integer incidentTypeSelect) {
        this.incidentTypeSelect = incidentTypeSelect;
    }

    public DebtRecoveryLevel getDebtRecoveryLevel() {
        return this.debtRecoveryLevel;
    }

    public void setDebtRecoveryLevel(DebtRecoveryLevel debtRecoveryLevel) {
        this.debtRecoveryLevel = debtRecoveryLevel;
    }

    public BigDecimal getBurden() {
        return this.burden == null ? BigDecimal.ZERO : this.burden;
    }

    public void setBurden(BigDecimal burden) {
        this.burden = burden;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRejectType() {
        return this.rejectType;
    }

    public void setRejectType(String rejectType) {
        this.rejectType = rejectType;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.incidentTypeSelect != 0 && this.rejectType != null) {
            return "Rejet (" + this.rejectType + ")";
        }
        if (this.debtRecoveryLevel != null && this.debtRecoveryLevel.getName() != null) {
            return "Relance " + this.debtRecoveryLevel.getName();
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PayerQualityConfigLine)) {
            return false;
        }
        PayerQualityConfigLine other = (PayerQualityConfigLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("incidentTypeSelect", (Object)this.getIncidentTypeSelect()).add("burden", (Object)this.getBurden()).add("description", (Object)this.getDescription()).add("rejectType", (Object)this.getRejectType()).omitNullValues().toString();
    }
}

