/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.ManagementObject;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_PAYMENT_SCHEDULE", uniqueConstraints={@UniqueConstraint(columnNames={"paymentScheduleSeq", "company"})}, indexes={@Index(columnList="paymentScheduleSeq"), @Index(columnList="bank_details"), @Index(columnList="company_bank_details"), @Index(columnList="payment_mode"), @Index(columnList="partner"), @Index(columnList="company"), @Index(columnList="currency"), @Index(columnList="management_object")})
public class PaymentSchedule
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_PAYMENT_SCHEDULE_SEQ")
    @SequenceGenerator(name="ACCOUNT_PAYMENT_SCHEDULE_SEQ", sequenceName="ACCOUNT_PAYMENT_SCHEDULE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Type", selection="iaccount.payment.schedule.type.select")
    private Integer typeSelect = 1;
    @Widget(title="Ref.", readonly=true)
    @NameColumn
    private String paymentScheduleSeq;
    @Widget(title="Creation Date")
    private LocalDate creationDate;
    @Widget(title="Schedule start Date")
    private LocalDate startDate;
    @Widget(title="Nbr. of terms")
    private Integer nbrTerm = 0;
    @Widget(title="Bank Details")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails companyBankDetails;
    @Widget(title="Payment Mode")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Schedule lines", readonly=false)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="paymentSchedule", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="scheduleLineSeq")
    private List<PaymentScheduleLine> paymentScheduleLineList;
    @Widget(title="Status", readonly=true, selection="iaccount.payment.schedule.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Partner")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Select invoices to include in the payment schedule")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Invoice> invoiceSet;
    @Widget(title="Reject counter", readonly=true)
    private Integer rejectCounter = 0;
    @Widget(title="Amount")
    private BigDecimal inTaxAmount = BigDecimal.ZERO;
    @Widget(title="Currency")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Irrecoverable status", readonly=true, selection="iaccount.account.schedule.irrecoverable.status.select")
    private Integer irrecoverableStatusSelect = 0;
    @Widget(title="Irrecoverable shift reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManagementObject managementObject;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getPaymentScheduleSeq() {
        return this.paymentScheduleSeq;
    }

    public void setPaymentScheduleSeq(String paymentScheduleSeq) {
        this.paymentScheduleSeq = paymentScheduleSeq;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Integer getNbrTerm() {
        return this.nbrTerm == null ? 0 : this.nbrTerm;
    }

    public void setNbrTerm(Integer nbrTerm) {
        this.nbrTerm = nbrTerm;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public BankDetails getCompanyBankDetails() {
        return this.companyBankDetails;
    }

    public void setCompanyBankDetails(BankDetails companyBankDetails) {
        this.companyBankDetails = companyBankDetails;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public List<PaymentScheduleLine> getPaymentScheduleLineList() {
        return this.paymentScheduleLineList;
    }

    public void setPaymentScheduleLineList(List<PaymentScheduleLine> paymentScheduleLineList) {
        this.paymentScheduleLineList = paymentScheduleLineList;
    }

    public void addPaymentScheduleLineListItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineList() == null) {
            this.setPaymentScheduleLineList(new ArrayList<PaymentScheduleLine>());
        }
        this.getPaymentScheduleLineList().add(item);
        item.setPaymentSchedule(this);
    }

    public void removePaymentScheduleLineListItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineList() == null) {
            return;
        }
        this.getPaymentScheduleLineList().remove((Object)item);
    }

    public void clearPaymentScheduleLineList() {
        if (this.getPaymentScheduleLineList() != null) {
            this.getPaymentScheduleLineList().clear();
        }
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<Invoice> getInvoiceSet() {
        return this.invoiceSet;
    }

    public void setInvoiceSet(Set<Invoice> invoiceSet) {
        this.invoiceSet = invoiceSet;
    }

    public void addInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            this.setInvoiceSet(new HashSet<Invoice>());
        }
        this.getInvoiceSet().add(item);
    }

    public void removeInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            return;
        }
        this.getInvoiceSet().remove((Object)item);
    }

    public void clearInvoiceSet() {
        if (this.getInvoiceSet() != null) {
            this.getInvoiceSet().clear();
        }
    }

    public Integer getRejectCounter() {
        return this.rejectCounter == null ? 0 : this.rejectCounter;
    }

    public void setRejectCounter(Integer rejectCounter) {
        this.rejectCounter = rejectCounter;
    }

    public BigDecimal getInTaxAmount() {
        return this.inTaxAmount == null ? BigDecimal.ZERO : this.inTaxAmount;
    }

    public void setInTaxAmount(BigDecimal inTaxAmount) {
        this.inTaxAmount = inTaxAmount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Integer getIrrecoverableStatusSelect() {
        return this.irrecoverableStatusSelect == null ? 0 : this.irrecoverableStatusSelect;
    }

    public void setIrrecoverableStatusSelect(Integer irrecoverableStatusSelect) {
        this.irrecoverableStatusSelect = irrecoverableStatusSelect;
    }

    public ManagementObject getManagementObject() {
        return this.managementObject;
    }

    public void setManagementObject(ManagementObject managementObject) {
        this.managementObject = managementObject;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaymentSchedule)) {
            return false;
        }
        PaymentSchedule other = (PaymentSchedule)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("typeSelect", (Object)this.getTypeSelect()).add("paymentScheduleSeq", (Object)this.getPaymentScheduleSeq()).add("creationDate", (Object)this.getCreationDate()).add("startDate", (Object)this.getStartDate()).add("nbrTerm", (Object)this.getNbrTerm()).add("statusSelect", (Object)this.getStatusSelect()).add("rejectCounter", (Object)this.getRejectCounter()).add("inTaxAmount", (Object)this.getInTaxAmount()).add("irrecoverableStatusSelect", (Object)this.getIrrecoverableStatusSelect()).omitNullValues().toString();
    }
}

