/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_RECONCILE_GROUP", indexes={@Index(columnList="code"), @Index(columnList="company")})
public class ReconcileGroup
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_RECONCILE_GROUP_SEQ")
    @SequenceGenerator(name="ACCOUNT_RECONCILE_GROUP_SEQ", sequenceName="ACCOUNT_RECONCILE_GROUP_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Reference", readonly=true)
    @NameColumn
    private String code;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Status", readonly=true, selection="account.reconcile.group.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Date of lettering")
    private LocalDate dateOfLettering;
    @Widget(title="Date of unlettering")
    private LocalDate unletteringDate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ReconcileGroup() {
    }

    public ReconcileGroup(Company company) {
        this.company = company;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDate getDateOfLettering() {
        return this.dateOfLettering;
    }

    public void setDateOfLettering(LocalDate dateOfLettering) {
        this.dateOfLettering = dateOfLettering;
    }

    public LocalDate getUnletteringDate() {
        return this.unletteringDate;
    }

    public void setUnletteringDate(LocalDate unletteringDate) {
        this.unletteringDate = unletteringDate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReconcileGroup)) {
            return false;
        }
        ReconcileGroup other = (ReconcileGroup)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("statusSelect", (Object)this.getStatusSelect()).add("dateOfLettering", (Object)this.getDateOfLettering()).add("unletteringDate", (Object)this.getUnletteringDate()).omitNullValues().toString();
    }
}

