/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.base.db.Year;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_REPORTED_BALANCE_LINE", indexes={@Index(columnList="accounting_situation"), @Index(columnList="year")})
public class ReportedBalanceLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_REPORTED_BALANCE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_REPORTED_BALANCE_LINE_SEQ", sequenceName="ACCOUNT_REPORTED_BALANCE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Accounting situation")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountingSituation accountingSituation;
    @Widget(title="Fiscal year")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Year year;
    @Widget(title="Amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AccountingSituation getAccountingSituation() {
        return this.accountingSituation;
    }

    public void setAccountingSituation(AccountingSituation accountingSituation) {
        this.accountingSituation = accountingSituation;
    }

    public Year getYear() {
        return this.year;
    }

    public void setYear(Year year) {
        this.year = year;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReportedBalanceLine)) {
            return false;
        }
        ReportedBalanceLine other = (ReportedBalanceLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("amount", (Object)this.getAmount()).omitNullValues().toString();
    }
}

