/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_TAX_PAYMENT_MOVE_LINE", indexes={@Index(columnList="move_line"), @Index(columnList="origin_tax_line"), @Index(columnList="reconcile")})
public class TaxPaymentMoveLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_TAX_PAYMENT_MOVE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_TAX_PAYMENT_MOVE_LINE_SEQ", sequenceName="ACCOUNT_TAX_PAYMENT_MOVE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Move line", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine moveLine;
    @Widget(title="Origin tax line", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine originTaxLine;
    @Widget(title="Reconcile", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Reconcile reconcile;
    @Widget(title="Rate")
    @Digits(integer=17, fraction=3)
    private BigDecimal taxRate = BigDecimal.ZERO;
    @Widget(title="Tax amount", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal taxAmount = BigDecimal.ZERO;
    @Widget(readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal detailPaymentAmount = BigDecimal.ZERO;
    @Widget(title="Date", readonly=true)
    @Column(name="date_val")
    private LocalDate date;
    @Widget(readonly=true, hidden=true)
    private Boolean isAlreadyReverse = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TaxPaymentMoveLine() {
    }

    public TaxPaymentMoveLine(MoveLine moveLine, TaxLine originTaxLine, Reconcile reconcile, BigDecimal taxRate, BigDecimal detailPaymentAmount, LocalDate date) {
        this.moveLine = moveLine;
        this.originTaxLine = originTaxLine;
        this.reconcile = reconcile;
        this.taxRate = taxRate;
        this.detailPaymentAmount = detailPaymentAmount;
        this.date = date;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MoveLine getMoveLine() {
        return this.moveLine;
    }

    public void setMoveLine(MoveLine moveLine) {
        this.moveLine = moveLine;
    }

    public TaxLine getOriginTaxLine() {
        return this.originTaxLine;
    }

    public void setOriginTaxLine(TaxLine originTaxLine) {
        this.originTaxLine = originTaxLine;
    }

    public Reconcile getReconcile() {
        return this.reconcile;
    }

    public void setReconcile(Reconcile reconcile) {
        this.reconcile = reconcile;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate == null ? BigDecimal.ZERO : this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount == null ? BigDecimal.ZERO : this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getDetailPaymentAmount() {
        return this.detailPaymentAmount == null ? BigDecimal.ZERO : this.detailPaymentAmount;
    }

    public void setDetailPaymentAmount(BigDecimal detailPaymentAmount) {
        this.detailPaymentAmount = detailPaymentAmount;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Boolean getIsAlreadyReverse() {
        return this.isAlreadyReverse == null ? Boolean.FALSE : this.isAlreadyReverse;
    }

    public void setIsAlreadyReverse(Boolean isAlreadyReverse) {
        this.isAlreadyReverse = isAlreadyReverse;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaxPaymentMoveLine)) {
            return false;
        }
        TaxPaymentMoveLine other = (TaxPaymentMoveLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("taxRate", (Object)this.getTaxRate()).add("taxAmount", (Object)this.getTaxAmount()).add("detailPaymentAmount", (Object)this.getDetailPaymentAmount()).add("date", (Object)this.getDate()).add("isAlreadyReverse", (Object)this.getIsAlreadyReverse()).omitNullValues().toString();
    }
}

