/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.City;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_UMR", indexes={@Index(columnList="umrNumber"), @Index(columnList="debtor_address"), @Index(columnList="mandate_signature_city"), @Index(columnList="partner"), @Index(columnList="active_bank_details")})
public class Umr
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_UMR_SEQ")
    @SequenceGenerator(name="ACCOUNT_UMR_SEQ", sequenceName="ACCOUNT_UMR_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="UMR N\u00b0")
    @NameColumn
    private String umrNumber;
    @Widget(title="Debtor Name")
    private String debtorName;
    @Widget(title="Debtor address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address debtorAddress;
    @Widget(title="Creation date")
    private LocalDate creationDate;
    @Widget(title="Mandate signature date")
    private LocalDate mandateSignatureDate;
    @Widget(title="Mandate signature city")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private City mandateSignatureCity;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(hidden=true)
    private String lastNumberIbanBic;
    @Widget(hidden=true)
    private Boolean isUpdating = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails activeBankDetails;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Umr() {
    }

    public Umr(String umrNumber, String debtorName, Address debtorAddress, LocalDate creationDate, LocalDate mandateSignatureDate, City mandateSignatureCity, Partner partner) {
        this.umrNumber = umrNumber;
        this.debtorName = debtorName;
        this.debtorAddress = debtorAddress;
        this.creationDate = creationDate;
        this.mandateSignatureDate = mandateSignatureDate;
        this.mandateSignatureCity = mandateSignatureCity;
        this.partner = partner;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUmrNumber() {
        return this.umrNumber;
    }

    public void setUmrNumber(String umrNumber) {
        this.umrNumber = umrNumber;
    }

    public String getDebtorName() {
        return this.debtorName;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public Address getDebtorAddress() {
        return this.debtorAddress;
    }

    public void setDebtorAddress(Address debtorAddress) {
        this.debtorAddress = debtorAddress;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDate getMandateSignatureDate() {
        return this.mandateSignatureDate;
    }

    public void setMandateSignatureDate(LocalDate mandateSignatureDate) {
        this.mandateSignatureDate = mandateSignatureDate;
    }

    public City getMandateSignatureCity() {
        return this.mandateSignatureCity;
    }

    public void setMandateSignatureCity(City mandateSignatureCity) {
        this.mandateSignatureCity = mandateSignatureCity;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public String getLastNumberIbanBic() {
        return this.lastNumberIbanBic;
    }

    public void setLastNumberIbanBic(String lastNumberIbanBic) {
        this.lastNumberIbanBic = lastNumberIbanBic;
    }

    public Boolean getIsUpdating() {
        return this.isUpdating == null ? Boolean.FALSE : this.isUpdating;
    }

    public void setIsUpdating(Boolean isUpdating) {
        this.isUpdating = isUpdating;
    }

    public BankDetails getActiveBankDetails() {
        return this.activeBankDetails;
    }

    public void setActiveBankDetails(BankDetails activeBankDetails) {
        this.activeBankDetails = activeBankDetails;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Umr)) {
            return false;
        }
        Umr other = (Umr)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("umrNumber", (Object)this.getUmrNumber()).add("debtorName", (Object)this.getDebtorName()).add("creationDate", (Object)this.getCreationDate()).add("mandateSignatureDate", (Object)this.getMandateSignatureDate()).add("lastNumberIbanBic", (Object)this.getLastNumberIbanBic()).add("isUpdating", (Object)this.getIsUpdating()).omitNullValues().toString();
    }
}

