/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db.repo;

import com.axelor.apps.account.db.AccountingReport;
import com.axelor.apps.account.db.repo.AccountingReportRepository;
import com.axelor.apps.account.service.AccountingReportService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.google.inject.Inject;
import java.math.BigDecimal;
import javax.persistence.PersistenceException;

public class AccountingReportManagementRepository
extends AccountingReportRepository {
    @Inject
    protected AccountingReportService accountingReportService;

    public AccountingReport save(AccountingReport accountingReport) {
        try {
            if (accountingReport.getRef() == null) {
                String seq = this.accountingReportService.getSequence(accountingReport);
                this.accountingReportService.setSequence(accountingReport, seq);
            }
            return (AccountingReport)((Object)super.save((Model)((Object)accountingReport)));
        }
        catch (Exception e) {
            JPA.em().getTransaction().rollback();
            JPA.runInTransaction(() -> TraceBackService.trace((Throwable)e));
            JPA.em().getTransaction().begin();
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public AccountingReport copy(AccountingReport entity, boolean deep) {
        AccountingReport copy = (AccountingReport)((Object)super.copy((Model)((Object)entity), deep));
        copy.setRef(null);
        copy.setStatusSelect(1);
        copy.setPublicationDateTime(null);
        copy.setTotalDebit(BigDecimal.ZERO);
        copy.setTotalCredit(BigDecimal.ZERO);
        copy.setBalance(BigDecimal.ZERO);
        return copy;
    }
}

