/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db.repo;

import com.axelor.apps.account.db.DepositSlip;
import com.axelor.apps.account.db.repo.DepositSlipRepository;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import javax.persistence.PersistenceException;

public class DepositSlipAccountRepository
extends DepositSlipRepository {
    public DepositSlip save(DepositSlip entity) {
        try {
            if (Strings.isNullOrEmpty((String)entity.getDepositNumber())) {
                this.setDepositNumber(entity);
            }
            return (DepositSlip)((Object)super.save((Model)((Object)entity)));
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    private void setDepositNumber(DepositSlip entity) throws AxelorException {
        SequenceService sequenceService = (SequenceService)Beans.get(SequenceService.class);
        String depositNumber = sequenceService.getSequenceNumber("depositSlip", entity.getCompany());
        if (Strings.isNullOrEmpty((String)depositNumber)) {
            throw new AxelorException(Sequence.class, 3, I18n.get((String)"Missing deposit slip sequence for company %s"), new Object[]{entity.getCompany().getName()});
        }
        entity.setDepositNumber(depositNumber);
    }

    public void remove(DepositSlip entity) {
        if (entity.getPublicationDate() != null) {
            throw new PersistenceException(I18n.get((String)"You cannot delete this deposit slip."));
        }
        entity.clearPaymentVoucherList();
        super.remove((Model)((Object)entity));
    }
}

