/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db.repo;

import com.axelor.apps.account.db.FixedAsset;
import com.axelor.apps.account.db.repo.FixedAssetRepository;
import com.axelor.apps.account.service.FixedAssetService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import javax.persistence.PersistenceException;

public class FixedAssetManagementRepository
extends FixedAssetRepository {
    public FixedAsset save(FixedAsset fixedAsset) {
        try {
            this.computeReference(fixedAsset);
            this.computeDepreciation(fixedAsset);
            return (FixedAsset)((Object)super.save((Model)((Object)fixedAsset)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenceException((Throwable)e);
        }
    }

    private void computeReference(FixedAsset fixedAsset) {
        try {
            if (fixedAsset.getId() != null && Strings.isNullOrEmpty((String)fixedAsset.getReference())) {
                fixedAsset.setReference(((SequenceService)Beans.get(SequenceService.class)).getDraftSequenceNumber((Model)((Object)fixedAsset)));
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    private void computeDepreciation(FixedAsset fixedAsset) {
        if ((fixedAsset.getFixedAssetLineList() == null || fixedAsset.getFixedAssetLineList().isEmpty()) && fixedAsset.getGrossValue().compareTo(BigDecimal.ZERO) > 0) {
            ((FixedAssetService)Beans.get(FixedAssetService.class)).generateAndcomputeLines(fixedAsset);
        }
    }

    public FixedAsset copy(FixedAsset entity, boolean deep) {
        FixedAsset copy = (FixedAsset)((Object)super.copy((Model)((Object)entity), deep));
        copy.setStatusSelect(1);
        copy.setReference(null);
        copy.setResidualValue(entity.getGrossValue());
        copy.setFixedAssetLineList(null);
        return copy;
    }
}

