/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db.repo;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerBaseRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.persistence.PersistenceException;
import org.apache.commons.collections.CollectionUtils;

@Singleton
public class PartnerAccountRepository
extends PartnerBaseRepository {
    private AppService appService;
    private AccountingSituationService accountingSituationService;

    @Inject
    public PartnerAccountRepository(AppService appService, AccountingSituationService accountingSituationService) {
        this.appService = appService;
        this.accountingSituationService = accountingSituationService;
    }

    public Partner save(Partner partner) {
        try {
            if (partner.getId() == null) {
                partner = super.save(partner);
            }
            if (this.appService.isApp("account")) {
                if (!partner.getIsContact().booleanValue() || partner.getIsEmployee().booleanValue()) {
                    ((AccountingSituationService)Beans.get(AccountingSituationService.class)).createAccountingSituation((Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId())));
                }
                if (CollectionUtils.isNotEmpty(partner.getAccountingSituationList())) {
                    for (AccountingSituation situation : partner.getAccountingSituationList()) {
                        this.accountingSituationService.createPartnerAccounts(situation);
                    }
                }
            }
            return super.save(partner);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public Partner copy(Partner partner, boolean deep) {
        Partner copy = super.copy(partner, deep);
        if (this.appService.isApp("account")) {
            copy.setAccountingSituationList(null);
        }
        return copy;
    }
}

