/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountClearance;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.repo.AccountClearanceRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.TaxAccountService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.tax.TaxService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountClearanceService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveService moveService;
    protected MoveLineService moveLineService;
    protected MoveLineRepository moveLineRepo;
    protected SequenceService sequenceService;
    protected ReconcileService reconcileService;
    protected TaxService taxService;
    protected TaxAccountService taxAccountService;
    protected AccountClearanceRepository accountClearanceRepo;
    protected AppBaseService appBaseService;
    protected User user;

    @Inject
    public AccountClearanceService(UserService userService, AppBaseService appBaseService, MoveService moveService, MoveLineService moveLineService, MoveLineRepository moveLineRepo, SequenceService sequenceService, ReconcileService reconcileService, TaxService taxService, TaxAccountService taxAccountService, AccountClearanceRepository accountClearanceRepo) {
        this.appBaseService = appBaseService;
        this.user = userService.getUser();
        this.moveService = moveService;
        this.moveLineService = moveLineService;
        this.moveLineRepo = moveLineRepo;
        this.sequenceService = sequenceService;
        this.reconcileService = reconcileService;
        this.taxService = taxService;
        this.taxAccountService = taxAccountService;
        this.accountClearanceRepo = accountClearanceRepo;
    }

    public List<? extends MoveLine> getExcessPayment(AccountClearance accountClearance) throws AxelorException {
        Company company = accountClearance.getCompany();
        this.testCompanyField(company);
        List moveLineList = this.moveLineRepo.all().filter("self.company = ?1 AND self.account.useForPartnerBalance = 'true' AND (self.move.statusSelect = ?2 OR self.move.statusSelect = ?3) AND self.amountRemaining > 0 AND self.amountRemaining <= ?4 AND self.credit > 0 AND self.account in ?5 AND self.date <= ?6", new Object[]{company, 3, 2, accountClearance.getAmountThreshold(), company.getAccountConfig().getClearanceAccountSet(), accountClearance.getDateThreshold()}).fetch();
        this.log.debug("Liste des trop per\u00e7us r\u00e9cup\u00e9r\u00e9s : {}", (Object)moveLineList);
        return moveLineList;
    }

    @Transactional(rollbackOn={Exception.class})
    public void setExcessPayment(AccountClearance accountClearance) throws AxelorException {
        accountClearance.setMoveLineSet(new HashSet<MoveLine>());
        List<? extends MoveLine> moveLineList = this.getExcessPayment(accountClearance);
        if (moveLineList != null && moveLineList.size() != 0) {
            accountClearance.getMoveLineSet().addAll(moveLineList);
        }
        this.accountClearanceRepo.save((Model)((Object)accountClearance));
    }

    @Transactional(rollbackOn={Exception.class})
    public void validateAccountClearance(AccountClearance accountClearance) throws AxelorException {
        Company company = accountClearance.getCompany();
        AccountConfig accountConfig = company.getAccountConfig();
        Tax tax = accountConfig.getStandardRateTax();
        BigDecimal taxRate = this.taxService.getTaxRate(tax, this.appBaseService.getTodayDateTime().toLocalDate());
        Account taxAccount = this.taxAccountService.getAccount(tax, company, false, false);
        Account profitAccount = accountConfig.getProfitAccount();
        Journal journal = accountConfig.getAccountClearanceJournal();
        Set<MoveLine> moveLineList = accountClearance.getMoveLineSet();
        for (MoveLine moveLine : moveLineList) {
            Move move = this.createAccountClearanceMove(moveLine, taxRate, taxAccount, profitAccount, company, journal, accountClearance);
            this.moveService.getMoveValidateService().validate(move);
        }
        accountClearance.setStatusSelect(2);
        accountClearance.setDateTime(this.appBaseService.getTodayDateTime());
        accountClearance.setName(this.sequenceService.getSequenceNumber("accountClearance", company));
        this.accountClearanceRepo.save((Model)((Object)accountClearance));
    }

    public Move createAccountClearanceMove(MoveLine moveLine, BigDecimal taxRate, Account taxAccount, Account profitAccount, Company company, Journal journal, AccountClearance accountClearance) throws AxelorException {
        Partner partner = moveLine.getPartner();
        Move move = this.moveService.getMoveCreateService().createMove(journal, company, null, partner, null, 2);
        BigDecimal amount = moveLine.getAmountRemaining();
        MoveLine debitMoveLine = this.moveLineService.createMoveLine(move, partner, moveLine.getAccount(), amount, true, this.appBaseService.getTodayDateTime().toLocalDate(), 1, null, null);
        move.getMoveLineList().add(debitMoveLine);
        BigDecimal divid = taxRate.add(BigDecimal.ONE);
        BigDecimal profitAmount = amount.divide(divid, 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        MoveLine creditMoveLine1 = this.moveLineService.createMoveLine(move, partner, profitAccount, profitAmount, false, this.appBaseService.getTodayDateTime().toLocalDate(), 2, null, null);
        move.getMoveLineList().add(creditMoveLine1);
        BigDecimal taxAmount = amount.subtract(profitAmount);
        MoveLine creditMoveLine2 = this.moveLineService.createMoveLine(move, partner, taxAccount, taxAmount, false, this.appBaseService.getTodayDateTime().toLocalDate(), 3, null, null);
        move.getMoveLineList().add(creditMoveLine2);
        Reconcile reconcile = this.reconcileService.createReconcile(debitMoveLine, moveLine, amount, false);
        if (reconcile != null) {
            this.reconcileService.confirmReconcile(reconcile, true);
        }
        debitMoveLine.setAccountClearance(accountClearance);
        creditMoveLine1.setAccountClearance(accountClearance);
        creditMoveLine2.setAccountClearance(accountClearance);
        return move;
    }

    public AccountClearance createAccountClearance(Company company, String name, BigDecimal amountThreshold, LocalDate dateThreshold, List<MoveLine> moveLineSet) {
        AccountClearance accountClearance = new AccountClearance();
        accountClearance.setAmountThreshold(amountThreshold);
        accountClearance.setCompany(company);
        accountClearance.setDateThreshold(dateThreshold);
        accountClearance.getMoveLineSet().addAll(moveLineSet);
        accountClearance.setName(name);
        accountClearance.setDateTime(this.appBaseService.getTodayDateTime());
        accountClearance.setUser(this.user);
        accountClearance.setStatusSelect(2);
        return accountClearance;
    }

    public void testCompanyField(Company company) throws AxelorException {
        AccountConfig accountConfig = company.getAccountConfig();
        if (accountConfig == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure account informations for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        if (accountConfig.getProfitAccount() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a financial account for then company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        if (accountConfig.getStandardRateTax() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a tax standard rate for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        if (accountConfig.getClearanceAccountSet() == null || accountConfig.getClearanceAccountSet().size() == 0) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure account clearance for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        if (!this.sequenceService.hasSequence("accountClearance", company)) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a clearance sequence of the overpayments for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        if (accountConfig.getAccountClearanceJournal() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure an overpayment account clearance journal for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
    }
}

