/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.AccountingSituationRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountCustomerService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AccountingSituationService accountingSituationService;
    protected AccountingSituationRepository accSituationRepo;
    protected AppBaseService appBaseService;

    @Inject
    public AccountCustomerService(AccountingSituationService accountingSituationService, AccountingSituationRepository accSituationRepo, AppBaseService appBaseService) {
        this.accountingSituationService = accountingSituationService;
        this.accSituationRepo = accSituationRepo;
        this.appBaseService = appBaseService;
    }

    public AccountingSituationService getAccountingSituationService() {
        return this.accountingSituationService;
    }

    public BigDecimal getBalance(Partner partner, Company company) {
        this.log.debug("Compute balance (Partner : {}, Company : {})", (Object)partner.getName(), (Object)company.getName());
        Query query = JPA.em().createNativeQuery("SELECT SUM(COALESCE(m1.sum_remaining,0) - COALESCE(m2.sum_remaining,0) ) FROM public.account_move_line AS ml  LEFT OUTER JOIN ( SELECT moveline.amount_remaining AS sum_remaining, moveline.id AS moveline_id FROM public.account_move_line AS moveline WHERE moveline.debit > 0  GROUP BY moveline.id, moveline.amount_remaining) AS m1 ON (m1.moveline_id = ml.id) LEFT OUTER JOIN ( SELECT moveline.amount_remaining AS sum_remaining, moveline.id AS moveline_id FROM public.account_move_line AS moveline WHERE moveline.credit > 0  GROUP BY moveline.id, moveline.amount_remaining) AS m2 ON (m2.moveline_id = ml.id) LEFT OUTER JOIN public.account_account AS account ON (ml.account = account.id) LEFT OUTER JOIN public.account_move AS move ON (ml.move = move.id) WHERE ml.partner = ?1 AND move.company = ?2 AND move.ignore_in_accounting_ok IN ('false', null)AND account.use_for_partner_balance = 'true'AND (move.status_select = ?3 or move.status_select = ?4) AND ml.amount_remaining > 0 ").setParameter(1, (Object)partner).setParameter(2, (Object)company).setParameter(3, (Object)3).setParameter(4, (Object)2);
        BigDecimal balance = (BigDecimal)query.getSingleResult();
        if (balance == null) {
            balance = BigDecimal.ZERO;
        }
        this.log.debug("Balance : {}", (Object)balance);
        return balance;
    }

    public BigDecimal getBalanceDue(Partner partner, Company company) {
        this.log.debug("Compute balance due (Partner : {}, Company : {})", (Object)partner.getName(), (Object)company.getName());
        Query query = JPA.em().createNativeQuery("SELECT SUM( COALESCE(m1.sum_remaining,0) - COALESCE(m2.sum_remaining,0) ) FROM public.account_move_line AS ml  LEFT OUTER JOIN ( SELECT moveline.amount_remaining AS sum_remaining, moveline.id AS moveline_id FROM public.account_move_line AS moveline WHERE moveline.debit > 0 AND ((moveline.due_date IS NULL AND moveline.date_val <= ?1) OR (moveline.due_date IS NOT NULL AND moveline.due_date <= ?1)) GROUP BY moveline.id, moveline.amount_remaining) AS m1 on (m1.moveline_id = ml.id) LEFT OUTER JOIN ( SELECT moveline.amount_remaining AS sum_remaining, moveline.id AS moveline_id FROM public.account_move_line AS moveline WHERE moveline.credit > 0 GROUP BY moveline.id, moveline.amount_remaining) AS m2 ON (m2.moveline_id = ml.id) LEFT OUTER JOIN public.account_account AS account ON (ml.account = account.id) LEFT OUTER JOIN public.account_move AS move ON (ml.move = move.id) WHERE ml.partner = ?2 AND move.company = ?3 AND move.ignore_in_debt_recovery_ok IN ('false', null) AND move.ignore_in_accounting_ok IN ('false', null) AND account.use_for_partner_balance = 'true'AND (move.status_select = ?4 OR move.status_select = ?5) AND ml.amount_remaining > 0 ").setParameter(1, Date.from(this.appBaseService.getTodayDate().atStartOfDay().atZone(ZoneOffset.UTC).toInstant()), TemporalType.DATE).setParameter(2, (Object)partner).setParameter(3, (Object)company).setParameter(4, (Object)3).setParameter(5, (Object)2);
        BigDecimal balance = (BigDecimal)query.getSingleResult();
        if (balance == null) {
            balance = BigDecimal.ZERO;
        }
        this.log.debug("Balance due : {}", (Object)balance);
        return balance;
    }

    public BigDecimal getBalanceDueDebtRecovery(Partner partner, Company company) {
        Query query;
        BigDecimal balance;
        this.log.debug("Compute balance due debt recovery (Partner : {}, Company : {})", (Object)partner.getName(), (Object)company.getName());
        int mailTransitTime = 0;
        AccountConfig accountConfig = company.getAccountConfig();
        if (accountConfig != null) {
            mailTransitTime = accountConfig.getMailTransitTime();
        }
        if ((balance = (BigDecimal)(query = JPA.em().createNativeQuery("SELECT SUM( COALESCE(m1.sum_remaining,0) - COALESCE(m2.sum_remaining,0) ) FROM public.account_move_line as ml  LEFT OUTER JOIN ( SELECT moveline.amount_remaining AS sum_remaining, moveline.id AS moveline_id FROM public.account_move_line AS moveline WHERE moveline.debit > 0 AND (( moveline.date_val = moveline.due_date AND (moveline.due_date + ?1 ) < ?2 ) OR (moveline.due_date IS NOT NULL AND moveline.date_val != moveline.due_date AND moveline.due_date < ?2)OR (moveline.due_date IS NULL AND moveline.date_val < ?2)) GROUP BY moveline.id, moveline.amount_remaining) AS m1 ON (m1.moveline_id = ml.id) LEFT OUTER JOIN ( SELECT moveline.amount_remaining AS sum_remaining, moveline.id AS moveline_id FROM public.account_move_line AS moveline WHERE moveline.credit > 0 GROUP BY moveline.id, moveline.amount_remaining) AS m2 ON (m2.moveline_id = ml.id) LEFT OUTER JOIN public.account_account AS account ON (ml.account = account.id) LEFT OUTER JOIN public.account_move AS move ON (ml.move = move.id) LEFT JOIN public.account_invoice AS invoice ON (move.invoice = invoice.id) WHERE ml.partner = ?3 AND move.company = ?4 AND move.ignore_in_debt_recovery_ok in ('false', null) AND move.ignore_in_accounting_ok IN ('false', null) AND account.use_for_partner_balance = 'true'AND (move.status_select = ?5 OR move.status_select = ?6) AND ml.amount_remaining > 0 AND invoice.debt_recovery_blocking_ok = FALSE ").setParameter(1, (Object)mailTransitTime).setParameter(2, Date.from(this.appBaseService.getTodayDate().atStartOfDay().atZone(ZoneOffset.UTC).toInstant()), TemporalType.DATE).setParameter(3, (Object)partner).setParameter(4, (Object)company).setParameter(5, (Object)3).setParameter(6, (Object)2)).getSingleResult()) == null) {
            balance = BigDecimal.ZERO;
        }
        this.log.debug("Balance due debt recovery : {}", (Object)balance);
        return balance;
    }

    public List<? extends MoveLine> getMoveLine(Partner partner, Company company) {
        return ((MoveLineRepository)((Object)Beans.get(MoveLineRepository.class))).all().filter("self.partner = ?1 AND self.move.company = ?2", new Object[]{partner, company}).fetch();
    }

    public void updatePartnerAccountingSituation(List<Partner> partnerList, Company company, boolean updateCustAccount, boolean updateDueCustAccount, boolean updateDueDebtRecoveryCustAccount) throws AxelorException {
        for (Partner partner : partnerList) {
            AccountingSituation accountingSituation = this.accountingSituationService.getAccountingSituation(partner, company);
            if (accountingSituation == null) {
                accountingSituation = this.accountingSituationService.createAccountingSituation(partner, company);
            }
            if (accountingSituation == null) continue;
            this.updateAccountingSituationCustomerAccount(accountingSituation, updateCustAccount, updateDueCustAccount, updateDueDebtRecoveryCustAccount);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void flagPartners(List<Partner> partnerList, Company company) throws AxelorException {
        for (Partner partner : partnerList) {
            AccountingSituation accountingSituation = this.accountingSituationService.getAccountingSituation(partner, company);
            if (accountingSituation == null) {
                accountingSituation = this.accountingSituationService.createAccountingSituation(partner, company);
            }
            if (accountingSituation == null) continue;
            accountingSituation.setCustAccountMustBeUpdateOk(true);
            this.accSituationRepo.save((Model)((Object)accountingSituation));
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public AccountingSituation updateAccountingSituationCustomerAccount(AccountingSituation accountingSituation, boolean updateCustAccount, boolean updateDueCustAccount, boolean updateDueDebtRecoveryCustAccount) throws AxelorException {
        Partner partner = accountingSituation.getPartner();
        Company company = accountingSituation.getCompany();
        this.log.debug("Update customer account (Partner : {}, Company : {}, Update balance : {}, balance due : {}, balance due debt recovery : {})", new Object[]{partner.getName(), company.getName(), updateCustAccount, updateDueCustAccount, updateDueDebtRecoveryCustAccount});
        if (updateCustAccount) {
            accountingSituation.setBalanceCustAccount(this.getBalance(partner, company));
        }
        if (updateDueCustAccount) {
            accountingSituation.setBalanceDueCustAccount(this.getBalanceDue(partner, company));
        }
        if (updateDueDebtRecoveryCustAccount) {
            accountingSituation.setBalanceDueDebtRecoveryCustAccount(this.getBalanceDueDebtRecovery(partner, company));
        }
        accountingSituation.setCustAccountMustBeUpdateOk(false);
        this.accSituationRepo.save((Model)((Object)accountingSituation));
        return accountingSituation;
    }

    public Account getPartnerAccount(Partner partner, Company company, boolean isSupplierInvoice) throws AxelorException {
        return isSupplierInvoice ? this.getSupplierAccount(partner, company) : this.getCustomerAccount(partner, company);
    }

    protected Account getCustomerAccount(Partner partner, Company company) throws AxelorException {
        Account customerAccount = this.accountingSituationService.getCustomerAccount(partner, company);
        if (customerAccount == null) {
            throw new AxelorException((Model)((Object)partner), 1, I18n.get((String)"%s : A customer account is missing for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return customerAccount;
    }

    protected Account getSupplierAccount(Partner partner, Company company) throws AxelorException {
        Account supplierAccount = this.accountingSituationService.getSupplierAccount(partner, company);
        if (supplierAccount == null) {
            throw new AxelorException((Model)((Object)partner), 1, I18n.get((String)"%s : A supplier account is missing for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return supplierAccount;
    }
}

