/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.AccountService;
import com.axelor.apps.account.service.AccountingCloseAnnualService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveCreateService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Year;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCloseAnnualServiceImpl
implements AccountingCloseAnnualService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveCreateService moveCreateService;
    protected MoveLineService moveLineService;
    protected AccountConfigService accountConfigService;
    protected MoveRepository moveRepository;
    protected MoveValidateService moveValidateService;
    protected ReconcileService reconcileService;
    protected AccountService accountService;
    protected AccountRepository accountRepository;
    protected int counter = 0;

    @Inject
    public AccountingCloseAnnualServiceImpl(MoveCreateService moveCreateService, MoveLineService moveLineService, AccountConfigService accountConfigService, MoveRepository moveRepository, MoveValidateService moveValidateService, ReconcileService reconcileService, AccountService accountService, AccountRepository accountRepository) {
        this.moveCreateService = moveCreateService;
        this.moveLineService = moveLineService;
        this.accountConfigService = accountConfigService;
        this.moveRepository = moveRepository;
        this.moveValidateService = moveValidateService;
        this.reconcileService = reconcileService;
        this.accountService = accountService;
        this.accountRepository = accountRepository;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, RuntimeException.class})
    public List<Move> generateCloseAnnualAccount(Year year, Account account, Partner partner, LocalDate endOfYearDate, LocalDate reportedBalanceDate, String origin, String moveDescription, boolean closeYear, boolean openYear, boolean allocatePerPartner) throws AxelorException {
        ArrayList<Move> moveList = new ArrayList<Move>();
        Move closeYearMove = null;
        Move openYearMove = null;
        if (closeYear) {
            closeYearMove = this.generateCloseAnnualAccountMove(year, account, endOfYearDate, endOfYearDate, origin, moveDescription, partner, false, allocatePerPartner);
            if (closeYearMove == null) {
                return null;
            }
            moveList.add(closeYearMove);
        }
        if (openYear) {
            openYearMove = this.generateCloseAnnualAccountMove(year, account, reportedBalanceDate, endOfYearDate, origin, moveDescription, partner, true, allocatePerPartner);
            if (openYearMove == null) {
                return null;
            }
            moveList.add(openYearMove);
        }
        if (closeYearMove != null && openYearMove != null) {
            this.reconcile(closeYearMove, openYearMove);
        }
        return moveList;
    }

    protected Move generateCloseAnnualAccountMove(Year year, Account account, LocalDate moveDate, LocalDate originDate, String origin, String moveDescription, Partner partner, boolean isReverse, boolean allocatePerPartner) throws AxelorException {
        Company company = account.getCompany();
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        BigDecimal balance = this.computeBalance(year, account, partner, allocatePerPartner);
        if (balance.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        Integer functionalOriginSelect = null;
        if (isReverse) {
            balance = balance.negate();
            functionalOriginSelect = 1;
        } else {
            functionalOriginSelect = 2;
        }
        Move move = this.moveCreateService.createMove(this.accountConfigService.getReportedBalanceJournal(accountConfig), company, company.getCurrency(), partner, moveDate, null, 2, false, false, !isReverse);
        move.setFunctionalOriginSelect(functionalOriginSelect);
        this.counter = 0;
        this.generateCloseAnnualMoveLine(move, origin, account, moveDescription, originDate, balance.negate());
        this.generateCloseAnnualMoveLine(move, origin, this.getYearClosureOrOpeningAccount(accountConfig, isReverse), moveDescription, originDate, balance);
        if (move.getMoveLineList() == null || move.getMoveLineList().isEmpty()) {
            this.moveRepository.remove((Model)((Object)move));
            return null;
        }
        this.moveValidateService.validate(move);
        return move;
    }

    protected Account getYearClosureOrOpeningAccount(AccountConfig accountConfig, boolean isReverse) throws AxelorException {
        if (isReverse) {
            return this.accountConfigService.getYearOpeningAccount(accountConfig);
        }
        return this.accountConfigService.getYearClosureAccount(accountConfig);
    }

    protected MoveLine generateCloseAnnualMoveLine(Move move, String origin, Account account, String moveDescription, LocalDate originDate, BigDecimal balance) throws AxelorException {
        LocalDate moveDate = move.getDate();
        MoveLine moveLine = this.moveLineService.createMoveLine(move, move.getPartner(), account, balance.abs(), balance.abs(), null, balance.compareTo(BigDecimal.ZERO) == 1, moveDate, moveDate, originDate, ++this.counter, origin, moveDescription);
        move.addMoveLineListItem(moveLine);
        return moveLine;
    }

    protected BigDecimal computeBalance(Year year, Account account, Partner partner, boolean allocatePerPartner) {
        String prepareQuery = "select SUM(self.debit - self.credit) FROM MoveLine as self WHERE self.move.ignoreInAccountingOk = false AND self.move.period.year = ?1 AND self.account = ?2 AND self.move.statusSelect = ?3 AND self.move.autoYearClosureMove is not true";
        if (allocatePerPartner && account.getUseForPartnerBalance().booleanValue()) {
            prepareQuery = partner != null ? prepareQuery + " AND self.partner = ?4" : prepareQuery + " AND self.partner is null";
        }
        TypedQuery q = JPA.em().createQuery(prepareQuery, BigDecimal.class);
        q.setParameter(1, (Object)year);
        q.setParameter(2, (Object)account);
        q.setParameter(3, (Object)3);
        if (partner != null) {
            q.setParameter(4, (Object)partner);
        }
        BigDecimal result = (BigDecimal)q.getSingleResult();
        LOG.debug("Balance : {} for the account : {} and the year : {}", new Object[]{result, account.getCode(), year.getCode()});
        if (result != null) {
            return result;
        }
        return BigDecimal.ZERO;
    }

    protected void reconcile(Move move, Move reverseMove) throws AxelorException {
        List<MoveLine> moveLineSortedList = move.getMoveLineList();
        Collections.sort(moveLineSortedList, Comparator.comparing(MoveLine::getCounter));
        List<MoveLine> reverseMoveLineSortedList = reverseMove.getMoveLineList();
        Collections.sort(reverseMoveLineSortedList, Comparator.comparing(MoveLine::getCounter));
        Iterator<MoveLine> reverseMoveLinesIt = reverseMoveLineSortedList.iterator();
        for (MoveLine moveLine : moveLineSortedList) {
            MoveLine reverseMoveLine = reverseMoveLinesIt.next();
            this.reconcileService.reconcile(moveLine, reverseMoveLine, false, false);
        }
    }

    @Override
    public List<Long> getAllAccountOfYear(Set<Account> accountSet, Year year) {
        List<Long> accountIdList = this.accountService.getAllAccountsSubAccountIncluded(accountSet.stream().map(Account::getId).collect(Collectors.toList()));
        TypedQuery q = JPA.em().createQuery("select distinct(self.account.id) FROM MoveLine as self WHERE self.move.ignoreInAccountingOk = false AND self.move.period.year  = ?1 AND self.account.id in (?2) AND self.move.statusSelect = ?3 AND self.move.autoYearClosureMove is not true", Long.class);
        q.setParameter(1, (Object)year);
        q.setParameter(2, accountIdList);
        q.setParameter(3, (Object)3);
        List result = q.getResultList();
        return result;
    }

    @Override
    public List<Pair<Long, Long>> assignPartner(List<Long> accountIdList, Year year, boolean allocatePerPartner) {
        ArrayList<Pair<Long, Long>> accountAndPartnerPair = new ArrayList<Pair<Long, Long>>();
        for (Long accountId : accountIdList) {
            if (allocatePerPartner && ((Account)((Object)this.accountRepository.find(accountId))).getUseForPartnerBalance().booleanValue()) {
                for (Long partnerId : this.getPartner(accountId, year)) {
                    accountAndPartnerPair.add((Pair<Long, Long>)Pair.of((Object)accountId, (Object)partnerId));
                }
                continue;
            }
            accountAndPartnerPair.add((Pair<Long, Long>)Pair.of((Object)accountId, null));
        }
        return accountAndPartnerPair;
    }

    protected List<Long> getPartner(Long accountId, Year year) {
        TypedQuery q = JPA.em().createQuery("select distinct(self.partner.id) FROM MoveLine as self WHERE self.move.ignoreInAccountingOk = false AND self.move.period.year = ?1 AND self.account.id = ?2 AND self.move.statusSelect = ?3 AND self.move.autoYearClosureMove is not true", Long.class);
        q.setParameter(1, (Object)year);
        q.setParameter(2, (Object)accountId);
        q.setParameter(3, (Object)3);
        List result = q.getResultList();
        return result;
    }
}

