/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AccountingReport;
import com.axelor.apps.account.db.JournalType;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.db.repo.AccountingReportRepository;
import com.axelor.apps.account.db.repo.AnalyticMoveLineRepository;
import com.axelor.apps.account.db.repo.FixedAssetRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.TaxPaymentMoveLineRepository;
import com.axelor.apps.account.service.AccountingReportService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingReportServiceImpl
implements AccountingReportService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AccountingReportRepository accountingReportRepo;
    protected AppBaseService appBaseService;
    protected String query = "";
    protected AccountRepository accountRepo;
    protected List<Object> params = new ArrayList<Object>();
    protected int paramNumber = 1;

    @Inject
    public AccountingReportServiceImpl(AppAccountService appBaseService, AccountingReportRepository accountingReportRepo, AccountRepository accountRepo) {
        this.accountingReportRepo = accountingReportRepo;
        this.accountRepo = accountRepo;
        this.appBaseService = appBaseService;
    }

    @Override
    public String getMoveLineList(AccountingReport accountingReport) throws AxelorException {
        this.buildQuery(accountingReport);
        return this.buildDomainFromQuery();
    }

    protected String buildDomainFromQuery() {
        int i = 1;
        String domainQuery = this.query;
        for (Object param : this.params.toArray()) {
            String paramStr = "";
            if (param instanceof Model) {
                paramStr = ((Model)param).getId().toString();
            } else if (param instanceof Set) {
                Set paramSet = (Set)param;
                for (Object object : paramSet) {
                    if (!paramStr.isEmpty()) {
                        paramStr = paramStr + ",";
                    }
                    paramStr = paramStr + ((Model)object).getId().toString();
                }
            } else {
                paramStr = param instanceof LocalDate ? "'" + param.toString() + "'" : param.toString();
            }
            domainQuery = domainQuery.replace("?" + i, paramStr);
            ++i;
        }
        this.log.debug("domainQuery : {}", (Object)domainQuery);
        return domainQuery;
    }

    @Override
    public String buildQuery(AccountingReport accountingReport) throws AxelorException {
        JournalType journalType;
        this.initQuery();
        if (accountingReport.getCompany() != null) {
            this.addParams("self.move.company = ?%d", (Object)accountingReport.getCompany());
        }
        if (accountingReport.getCurrency() != null) {
            this.addParams("self.move.companyCurrency = ?%d", accountingReport.getCurrency());
        }
        if (accountingReport.getDateFrom() != null) {
            this.addParams("self.date >= ?%d", accountingReport.getDateFrom());
        }
        if (accountingReport.getDateTo() != null) {
            this.addParams("self.date <= ?%d", accountingReport.getDateTo());
        }
        if (accountingReport.getDate() != null) {
            this.addParams("self.date <= ?%d", accountingReport.getDate());
        }
        if (accountingReport.getJournal() != null) {
            this.addParams("self.move.journal = ?%d", (Object)accountingReport.getJournal());
        }
        if (accountingReport.getPeriod() != null) {
            this.addParams("self.move.period = ?%d", accountingReport.getPeriod());
        }
        if (accountingReport.getAccountSet() != null && !accountingReport.getAccountSet().isEmpty()) {
            this.addParams("(self.account in (?%d) or self.account.parentAccount in (?%d) or self.account.parentAccount.parentAccount in (?%d) or self.account.parentAccount.parentAccount.parentAccount in (?%d) or self.account.parentAccount.parentAccount.parentAccount.parentAccount in (?%d) or self.account.parentAccount.parentAccount.parentAccount.parentAccount.parentAccount in (?%d) or self.account.parentAccount.parentAccount.parentAccount.parentAccount.parentAccount.parentAccount in (?%d))", accountingReport.getAccountSet());
        }
        if (accountingReport.getPartnerSet() != null && !accountingReport.getPartnerSet().isEmpty()) {
            this.addParams("self.partner in (?%d)", accountingReport.getPartnerSet());
        }
        if (accountingReport.getYear() != null) {
            this.addParams("self.move.period.year = ?%d", (Object)accountingReport.getYear());
        }
        if (accountingReport.getPaymentMode() != null) {
            this.addParams("self.move.paymentMode = ?%d", (Object)accountingReport.getPaymentMode());
        }
        if (accountingReport.getTypeSelect() == 5) {
            this.addParams("self.amountPaid > 0 AND self.credit > 0");
        }
        if (accountingReport.getTypeSelect() == 4) {
            this.addParams("self.account is null or self.account.reconcileOk = 'true'");
            this.addParams("self.amountRemaining > 0 AND self.debit > 0");
        }
        if (accountingReport.getTypeSelect() == 7) {
            this.addParams("self.account.useForPartnerBalance = 'true'");
        }
        if (accountingReport.getTypeSelect() == 3) {
            this.addParams("self.account is null or self.account.reconcileOk = 'true'");
        }
        if (accountingReport.getTypeSelect() == 10) {
            this.addParams("self.move.paymentMode.typeSelect = ?%d", 5);
            this.addParams("self.credit > 0");
            this.addParams("self.account is null or self.account.reconcileOk = 'true'");
        }
        if (accountingReport.getTypeSelect() == 13) {
            this.addParams("self.account = ?%d", (Object)((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(accountingReport.getCompany()).getCashPositionVariationAccount());
        }
        if (accountingReport.getTypeSelect() == 12) {
            this.addParams("self.taxLine is not null");
            this.addParams("self.taxLine.tax.typeSelect = ?%d", 2);
        }
        this.addParams("self.move.ignoreInAccountingOk = 'false'");
        this.addParams("(self.move.statusSelect = 2 OR self.move.statusSelect = 3)");
        if (accountingReport.getTypeSelect() > 1001) {
            this.addParams("(self.move.accountingOk = false OR (self.move.accountingOk = true and self.move.accountingReport = ?%d))", (Object)accountingReport);
        }
        if (accountingReport.getTypeSelect() >= 1001) {
            this.addParams("self.move.journal.notExportOk = false ");
        }
        if (accountingReport.getTypeSelect() > 1001 && (journalType = this.getJournalType(accountingReport)) != null) {
            this.addParams("self.move.journal.journalType = ?%d", (Object)journalType);
        }
        if (accountingReport.getTypeSelect() >= 7 && accountingReport.getDisplayOnlyNotCompletelyLetteredMoveLines().booleanValue()) {
            this.addParams("self.amountRemaining > 0");
        }
        this.log.debug("Query : {}", (Object)this.query);
        return this.query;
    }

    protected void initQuery() {
        this.query = "";
        this.paramNumber = 1;
        this.params = new ArrayList<Object>();
        this.query = "";
        this.params.clear();
        this.paramNumber = 1;
    }

    @Override
    public String addParams(String paramQuery, Object param) {
        this.log.debug("requete et param : {} : {}", (Object)paramQuery, (Object)this.paramNumber);
        this.addParams(paramQuery.replaceAll("%d", String.valueOf(this.paramNumber++)));
        this.params.add(param);
        return this.query;
    }

    @Override
    public String addParams(String paramQuery) {
        if (!this.query.equals("")) {
            this.query = this.query + " AND ";
        }
        this.query = this.query + paramQuery;
        return this.query;
    }

    @Override
    public void setSequence(AccountingReport accountingReport, String sequence) {
        accountingReport.setRef(sequence);
    }

    @Override
    public String getSequence(AccountingReport accountingReport) throws AxelorException {
        SequenceService sequenceService = (SequenceService)Beans.get(SequenceService.class);
        int accountingReportTypeSelect = accountingReport.getTypeSelect();
        if (accountingReportTypeSelect >= 0 && accountingReportTypeSelect < 1000) {
            String seq = sequenceService.getSequenceNumber("accountingReport", accountingReport.getCompany());
            if (seq == null) {
                throw new AxelorException(4, I18n.get((String)"%s : Error : You must configure an account reporting sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountingReport.getCompany().getName()});
            }
            return seq;
        }
        if (accountingReportTypeSelect >= 1000 && accountingReportTypeSelect < 2000) {
            String seq = sequenceService.getSequenceNumber("moveLineExport", accountingReport.getCompany());
            if (seq == null) {
                throw new AxelorException(4, I18n.get((String)"%s : Error : You must configure an account export sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountingReport.getCompany().getName()});
            }
            return seq;
        }
        if (accountingReportTypeSelect >= 2000 && accountingReportTypeSelect < 3000) {
            String seq = sequenceService.getSequenceNumber("analyticReport", accountingReport.getCompany());
            if (seq == null) {
                throw new AxelorException(4, I18n.get((String)"%s : Error : You must configure an analytic report sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), accountingReport.getCompany().getName()});
            }
            return seq;
        }
        throw new AxelorException((Model)((Object)accountingReport), 4, I18n.get((String)"Unknown accounting report type: %d"), new Object[]{accountingReport.getTypeSelect()});
    }

    @Override
    public JournalType getJournalType(AccountingReport accountingReport) throws AxelorException {
        Company company = accountingReport.getCompany();
        AccountConfigService accountConfigService = (AccountConfigService)Beans.get(AccountConfigService.class);
        AccountConfig accountConfig = accountConfigService.getAccountConfig(company);
        switch (accountingReport.getTypeSelect()) {
            case 1006: {
                return accountConfigService.getSaleJournalType(accountConfig);
            }
            case 1007: {
                return accountConfigService.getCreditNoteJournalType(accountConfig);
            }
            case 1008: {
                return accountConfigService.getCashJournalType(accountConfig);
            }
            case 1009: {
                return accountConfigService.getPurchaseJournalType(accountConfig);
            }
        }
        return null;
    }

    @Override
    public Account getAccount(AccountingReport accountingReport) {
        if (accountingReport.getTypeSelect() == 13 && accountingReport.getCompany() != null) {
            return (Account)((Object)this.accountRepo.all().filter("self.company = ?1 AND self.code LIKE '58%'", new Object[]{accountingReport.getCompany()}).fetchOne());
        }
        return null;
    }

    @Override
    @Transactional
    public void setStatus(AccountingReport accountingReport) {
        accountingReport.setStatusSelect(2);
        this.accountingReportRepo.save((Model)((Object)accountingReport));
    }

    @Override
    @Transactional
    public void setPublicationDateTime(AccountingReport accountingReport) {
        accountingReport.setPublicationDateTime(this.appBaseService.getTodayDateTime());
        this.accountingReportRepo.save((Model)((Object)accountingReport));
    }

    @Override
    public BigDecimal getDebitBalance() {
        TypedQuery q = JPA.em().createQuery("select SUM(self.debit) FROM MoveLine as self WHERE " + this.query, BigDecimal.class);
        int i = 1;
        for (Object param : this.params.toArray()) {
            q.setParameter(i++, param);
        }
        BigDecimal result = (BigDecimal)q.getSingleResult();
        this.log.debug("Total debit : {}", (Object)result);
        if (result != null) {
            return result;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getCreditBalance() {
        TypedQuery q = JPA.em().createQuery("select SUM(self.credit) FROM MoveLine as self WHERE " + this.query, BigDecimal.class);
        int i = 1;
        for (Object param : this.params.toArray()) {
            q.setParameter(i++, param);
        }
        BigDecimal result = (BigDecimal)q.getSingleResult();
        this.log.debug("Total debit : {}", (Object)result);
        if (result != null) {
            return result;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getDebitBalanceType4() {
        TypedQuery q = JPA.em().createQuery("select SUM(self.amountRemaining) FROM MoveLine as self WHERE " + this.query, BigDecimal.class);
        int i = 1;
        for (Object param : this.params.toArray()) {
            q.setParameter(i++, param);
        }
        BigDecimal result = (BigDecimal)q.getSingleResult();
        this.log.debug("Total debit : {}", (Object)result);
        if (result != null) {
            return result;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getCreditBalance(AccountingReport accountingReport, String queryFilter) {
        if (accountingReport.getTypeSelect() == 4) {
            return this.getCreditBalanceType4();
        }
        return this.getCreditBalance();
    }

    @Override
    public BigDecimal getCreditBalanceType4() {
        return this.getDebitBalance().subtract(this.getDebitBalanceType4());
    }

    @Override
    public void testReportedDateField(LocalDate reportedDate) throws AxelorException {
        if (reportedDate == null) {
            throw new AxelorException(4, I18n.get((String)"Please set a reported balance date on fiscal year"));
        }
    }

    @Override
    public String getReportFileLink(AccountingReport accountingReport, String name) throws AxelorException {
        return ReportFactory.createReport((String)String.format("AccountingReportType%s.rptdesign", accountingReport.getTypeSelect()), (String)(name + "-${date}")).addParam("AccountingReportId", (Object)accountingReport.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addFormat(accountingReport.getExportTypeSelect()).toAttach((Model)((Object)accountingReport)).generate().getFileLink();
    }

    @Override
    public boolean isThereTooManyLines(AccountingReport accountingReport) throws AxelorException {
        AccountConfig accountConfig = ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(accountingReport.getCompany());
        Integer lineMinBeforeLongReportGenerationMessageNumber = accountConfig.getLineMinBeforeLongReportGenerationMessageNumber();
        if (lineMinBeforeLongReportGenerationMessageNumber != null && lineMinBeforeLongReportGenerationMessageNumber > 0) {
            Integer typeSelect = accountingReport.getTypeSelect();
            long count = 0L;
            if (typeSelect > 0 && typeSelect <= 14) {
                count = ((MoveLineRepository)((Object)Beans.get(MoveLineRepository.class))).all().filter(this.getMoveLineList(accountingReport)).count();
            } else if (typeSelect == 15) {
                count = ((TaxPaymentMoveLineRepository)((Object)Beans.get(TaxPaymentMoveLineRepository.class))).all().filter(this.getTaxPaymentMoveLineList(accountingReport)).count();
            } else if (typeSelect == 16) {
                count = ((FixedAssetRepository)((Object)Beans.get(FixedAssetRepository.class))).all().filter(this.getFixedAssetList(accountingReport)).count();
                count += (long)JPA.em().createQuery("Select invoiceLine FROM InvoiceLine invoiceLine LEFT JOIN FixedAsset fixedAsset on fixedAsset.invoiceLine = invoiceLine.id WHERE invoiceLine.fixedAssets = true and fixedAsset.invoiceLine is null ").getResultList().size();
            } else if (typeSelect == 17) {
                count = ((FixedAssetRepository)((Object)Beans.get(FixedAssetRepository.class))).all().filter(this.getFixedAssetList(accountingReport)).count();
            } else if (typeSelect == 2000) {
                count = ((AnalyticMoveLineRepository)((Object)Beans.get(AnalyticMoveLineRepository.class))).all().filter(this.getAnalyticMoveLineList(accountingReport)).count();
            } else {
                return false;
            }
            return count > (long)lineMinBeforeLongReportGenerationMessageNumber.intValue();
        }
        return false;
    }

    protected String getAnalyticMoveLineList(AccountingReport accountingReport) {
        this.buildAnalyticMoveLineQuery(accountingReport);
        return this.buildDomainFromQuery();
    }

    protected void buildAnalyticMoveLineQuery(AccountingReport accountingReport) {
        this.initQuery();
        this.addParams("self.moveLine.move.companyCurrency = ?%d", accountingReport.getCurrency());
        if (accountingReport.getJournal() != null) {
            this.addParams("self.moveLine.move.journal = ?%d", (Object)accountingReport.getJournal());
        }
        if (accountingReport.getDateFrom() != null) {
            this.addParams("self.date >= ?%d", accountingReport.getDateFrom());
        }
        if (accountingReport.getDateTo() != null) {
            this.addParams("self.date <= ?%d", accountingReport.getDateTo());
        }
        this.addParams("self.date <= ?%d", accountingReport.getDate());
        if (accountingReport.getAnalyticJournal() != null) {
            this.addParams("self.analyticJournal = ?%d", (Object)accountingReport.getAnalyticJournal());
        }
        this.addParams("self.typeSelect = ?%d", 3);
        this.addParams("self.moveLine.move.ignoreInAccountingOk = 'false'");
        this.addParams("(self.moveLine.move.statusSelect = 2 OR self.moveLine.move.statusSelect = 3)");
        this.log.debug("Query : {}", (Object)this.query);
    }

    protected String getFixedAssetList(AccountingReport accountingReport) {
        this.buildFixedAssetQuery(accountingReport);
        return this.buildDomainFromQuery();
    }

    protected void buildFixedAssetQuery(AccountingReport accountingReport) {
        this.initQuery();
        this.addParams("(self.statusSelect = 2 OR self.statusSelect = 3)");
        if (accountingReport.getTypeSelect() == 16) {
            if (accountingReport.getDateFrom() != null) {
                this.addParams("self.acquisitionDate >= ?%d", accountingReport.getDateFrom());
            }
            if (accountingReport.getDateTo() != null) {
                this.addParams("self.acquisitionDate <= ?%d", accountingReport.getDateTo());
            }
        }
        if (accountingReport.getTypeSelect() == 17) {
            this.query = this.query + " OR ( self.statusSelect = 4 ";
            if (accountingReport.getDateFrom() != null) {
                this.addParams("self.disposalDate >= ?%d", accountingReport.getDateFrom());
            }
            if (accountingReport.getDateTo() != null) {
                this.addParams("self.disposalDate <= ?%d", accountingReport.getDateTo());
            }
            this.query = this.query + " ) ";
        }
        this.log.debug("Query : {}", (Object)this.query);
    }

    protected String getTaxPaymentMoveLineList(AccountingReport accountingReport) {
        this.buildTaxPaymentQuery(accountingReport);
        return this.buildDomainFromQuery();
    }

    protected String buildTaxPaymentQuery(AccountingReport accountingReport) {
        this.initQuery();
        if (accountingReport.getCompany() != null) {
            this.addParams("self.moveLine.move.company = ?%d", (Object)accountingReport.getCompany());
        }
        if (accountingReport.getCurrency() != null) {
            this.addParams("self.moveLine.move.companyCurrency = ?%d", accountingReport.getCurrency());
        }
        if (accountingReport.getDateFrom() != null) {
            this.addParams("self.moveLine.date >= ?%d", accountingReport.getDateFrom());
        }
        if (accountingReport.getDateTo() != null) {
            this.addParams("self.moveLine.date <= ?%d", accountingReport.getDateTo());
        }
        this.addParams("self.moveLine.move.ignoreInAccountingOk = 'false'");
        this.addParams("(self.moveLine.move.statusSelect = 2 OR self.moveLine.move.statusSelect = 3)");
        this.addParams("self.originTaxLine.tax.typeSelect = ?%d", 1);
        this.log.debug("Query : {}", (Object)this.query);
        return this.query;
    }
}

