/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.AnalyticAxis;
import com.axelor.apps.account.db.AnalyticDistributionLine;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticJournal;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.service.AccountManagementServiceAccountImpl;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.AppAccount;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AnalyticMoveLineServiceImpl
implements AnalyticMoveLineService {
    protected AppAccountService appAccountService;
    protected AccountManagementServiceAccountImpl accountManagementServiceAccountImpl;

    @Inject
    public AnalyticMoveLineServiceImpl(AppAccountService appAccountService, AccountManagementServiceAccountImpl accountManagementServiceAccountImpl) {
        this.appAccountService = appAccountService;
        this.accountManagementServiceAccountImpl = accountManagementServiceAccountImpl;
    }

    @Override
    public BigDecimal computeAmount(AnalyticMoveLine analyticMoveLine) {
        return analyticMoveLine.getPercentage().multiply(analyticMoveLine.getOriginalPieceAmount()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
    }

    @Override
    public List<AnalyticMoveLine> generateLines(AnalyticDistributionTemplate analyticDistributionTemplate, BigDecimal total, int typeSelect, LocalDate date) {
        ArrayList<AnalyticMoveLine> analyticMoveLineList = new ArrayList<AnalyticMoveLine>();
        if (analyticDistributionTemplate != null) {
            for (AnalyticDistributionLine analyticDistributionLine : analyticDistributionTemplate.getAnalyticDistributionLineList()) {
                analyticMoveLineList.add(this.createAnalyticMoveLine(analyticDistributionLine, total, typeSelect, date));
            }
        }
        return analyticMoveLineList;
    }

    @Override
    public AnalyticDistributionTemplate getAnalyticDistributionTemplate(Partner partner, Product product, Company company) {
        AppAccount appAccount = this.appAccountService.getAppAccount();
        if (appAccount.getAnalyticDistributionTypeSelect() == 2 && partner != null) {
            return partner.getAnalyticDistributionTemplate();
        }
        if (appAccount.getAnalyticDistributionTypeSelect() == 3) {
            return this.accountManagementServiceAccountImpl.getAnalyticDistributionTemplate(product, company);
        }
        return null;
    }

    public AnalyticMoveLine createAnalyticMoveLine(AnalyticDistributionLine analyticDistributionLine, BigDecimal total, int typeSelect, LocalDate date) {
        Company company;
        AnalyticMoveLine analyticMoveLine = new AnalyticMoveLine();
        analyticMoveLine.setOriginalPieceAmount(total);
        analyticMoveLine.setAnalyticAccount(analyticDistributionLine.getAnalyticAccount());
        analyticMoveLine.setAnalyticAxis(analyticDistributionLine.getAnalyticAxis());
        analyticMoveLine.setAnalyticJournal(analyticDistributionLine.getAnalyticJournal());
        AnalyticJournal analyticJournal = analyticDistributionLine.getAnalyticJournal();
        Company company2 = company = analyticJournal == null ? null : analyticJournal.getCompany();
        if (company != null) {
            analyticMoveLine.setCurrency(company.getCurrency());
        }
        analyticMoveLine.setDate(date);
        analyticMoveLine.setPercentage(analyticDistributionLine.getPercentage());
        analyticMoveLine.setAmount(this.computeAmount(analyticMoveLine));
        analyticMoveLine.setTypeSelect(typeSelect);
        return analyticMoveLine;
    }

    @Override
    public void updateAnalyticMoveLine(AnalyticMoveLine analyticMoveLine, BigDecimal total, LocalDate date) {
        analyticMoveLine.setOriginalPieceAmount(total);
        analyticMoveLine.setAmount(this.computeAmount(analyticMoveLine));
        analyticMoveLine.setDate(date);
    }

    @Override
    public boolean validateLines(List<AnalyticDistributionLine> analyticDistributionLineList) {
        if (analyticDistributionLineList != null) {
            HashMap<AnalyticAxis, BigDecimal> map = new HashMap<AnalyticAxis, BigDecimal>();
            for (AnalyticDistributionLine analyticDistributionLine : analyticDistributionLineList) {
                if (map.containsKey((Object)analyticDistributionLine.getAnalyticAxis())) {
                    map.put(analyticDistributionLine.getAnalyticAxis(), ((BigDecimal)map.get((Object)analyticDistributionLine.getAnalyticAxis())).add(analyticDistributionLine.getPercentage()));
                    continue;
                }
                map.put(analyticDistributionLine.getAnalyticAxis(), analyticDistributionLine.getPercentage());
            }
            for (AnalyticAxis analyticAxis : map.keySet()) {
                if (((BigDecimal)map.get((Object)analyticAxis)).compareTo(new BigDecimal(100)) <= 0) continue;
                return false;
            }
        }
        return true;
    }
}

