/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.ChequeRejection;
import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.repo.ChequeRejectionRepository;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;

public class ChequeRejectionService {
    protected MoveService moveService;
    protected MoveLineService moveLineService;
    protected SequenceService sequenceService;
    protected AccountConfigService accountConfigService;
    protected ChequeRejectionRepository chequeRejectionRepository;

    @Inject
    public ChequeRejectionService(MoveService moveService, MoveLineService moveLineService, SequenceService sequenceService, AccountConfigService accountConfigService, ChequeRejectionRepository chequeRejectionRepository) {
        this.moveService = moveService;
        this.moveLineService = moveLineService;
        this.sequenceService = sequenceService;
        this.accountConfigService = accountConfigService;
        this.chequeRejectionRepository = chequeRejectionRepository;
    }

    @Transactional(rollbackOn={Exception.class})
    public void validateChequeRejection(ChequeRejection chequeRejection) throws AxelorException {
        Company company = chequeRejection.getCompany();
        this.testCompanyField(company);
        this.setSequence(chequeRejection);
        Move move = this.createChequeRejectionMove(chequeRejection, company);
        chequeRejection.setMove(move);
        chequeRejection.setStatusSelect(2);
        this.chequeRejectionRepository.save((Model)((Object)chequeRejection));
    }

    public Move createChequeRejectionMove(ChequeRejection chequeRejection, Company company) throws AxelorException {
        this.testCompanyField(company);
        Journal journal = company.getAccountConfig().getRejectJournal();
        PaymentVoucher paymentVoucher = chequeRejection.getPaymentVoucher();
        Move paymentMove = paymentVoucher.getGeneratedMove();
        Partner partner = paymentVoucher.getPartner();
        InterbankCodeLine interbankCodeLine = chequeRejection.getInterbankCodeLine();
        String description = chequeRejection.getDescription();
        LocalDate rejectionDate = chequeRejection.getRejectionDate();
        Move move = this.moveService.getMoveCreateService().createMove(journal, company, null, partner, rejectionDate, null, 2);
        int ref = 1;
        for (MoveLine moveLine : paymentMove.getMoveLineList()) {
            if (moveLine.getCredit().compareTo(BigDecimal.ZERO) > 0) {
                MoveLine debitMoveLine = this.moveLineService.createMoveLine(move, partner, moveLine.getAccount(), moveLine.getCredit(), true, rejectionDate, ref, chequeRejection.getName(), chequeRejection.getDescription());
                move.getMoveLineList().add(debitMoveLine);
                debitMoveLine.setInterbankCodeLine(interbankCodeLine);
                debitMoveLine.setDescription(description);
            } else {
                MoveLine creditMoveLine = this.moveLineService.createMoveLine(move, partner, moveLine.getAccount(), moveLine.getDebit(), false, rejectionDate, ref, chequeRejection.getName(), chequeRejection.getDescription());
                move.getMoveLineList().add(creditMoveLine);
                creditMoveLine.setInterbankCodeLine(interbankCodeLine);
                creditMoveLine.setDescription(description);
            }
            ++ref;
        }
        move.setRejectOk(true);
        this.moveService.getMoveValidateService().validate(move);
        return move;
    }

    public void testCompanyField(Company company) throws AxelorException {
        this.accountConfigService.getRejectJournal(this.accountConfigService.getAccountConfig(company));
    }

    public void setSequence(ChequeRejection chequeRejection) throws AxelorException {
        String seq = this.sequenceService.getSequenceNumber("chequeReject", chequeRejection.getCompany());
        if (seq == null) {
            throw new AxelorException((Model)((Object)chequeRejection), 4, I18n.get((String)"%s : You must configure a cheque rejection sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), chequeRejection.getCompany().getName()});
        }
        chequeRejection.setName(seq);
    }
}

