/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.FixedAsset;
import com.axelor.apps.account.db.FixedAssetLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.FixedAssetRepository;
import com.axelor.apps.account.service.FixedAssetLineService;
import com.axelor.apps.account.service.FixedAssetService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class FixedAssetServiceImpl
implements FixedAssetService {
    @Inject
    FixedAssetRepository fixedAssetRepo;
    @Inject
    FixedAssetLineService fixedAssetLineService;
    protected MoveLineService moveLineService;

    @Inject
    public FixedAssetServiceImpl(MoveLineService moveLineService) {
        this.moveLineService = moveLineService;
    }

    @Override
    public FixedAsset generateAndcomputeLines(FixedAsset fixedAsset) {
        BigDecimal depreciationValue;
        boolean isLinear = fixedAsset.getComputationMethodSelect().equals("linear");
        BigDecimal cumulativeValue = depreciationValue = this.computeDepreciationValue(fixedAsset, isLinear);
        LocalDate depreciationDate = fixedAsset.getFirstDepreciationDate();
        LocalDate firstDepreciationDate = fixedAsset.getFirstDepreciationDate();
        LocalDate acquisitionDate = fixedAsset.getAcquisitionDate();
        int numberOfDepreciation = fixedAsset.getNumberOfDepreciation();
        boolean isFirstPeriodDay = DateTool.minusMonths((LocalDate)firstDepreciationDate, (int)fixedAsset.getPeriodicityInMonth()).plusDays(1L).equals(acquisitionDate);
        boolean isProrataTemporis = fixedAsset.getFixedAssetCategory().getIsProrataTemporis() != false && !fixedAsset.getAcquisitionDate().equals(fixedAsset.getFirstDepreciationDate()) && !isFirstPeriodDay;
        LocalDate endDate = DateTool.plusMonths((LocalDate)depreciationDate, (int)fixedAsset.getDurationInMonth());
        int counter = 1;
        int scale = ((AppBaseService)Beans.get(AppBaseService.class)).getNbDecimalDigitForUnitPrice();
        --numberOfDepreciation;
        while (depreciationDate.isBefore(endDate.plusDays(1L)) && depreciationValue.compareTo(BigDecimal.ZERO) > 0 && (isProrataTemporis && counter <= numberOfDepreciation + 2 || !isProrataTemporis && counter <= numberOfDepreciation + 1)) {
            FixedAssetLine fixedAssetLine = new FixedAssetLine();
            fixedAssetLine.setStatusSelect(1);
            fixedAssetLine.setDepreciationDate(depreciationDate);
            if (cumulativeValue.compareTo(fixedAsset.getGrossValue()) > 0) {
                fixedAssetLine.setDepreciation(depreciationValue.subtract(cumulativeValue.subtract(fixedAsset.getGrossValue())));
                fixedAssetLine.setCumulativeDepreciation(fixedAsset.getGrossValue());
                fixedAssetLine.setResidualValue(BigDecimal.ZERO);
            } else {
                fixedAssetLine.setDepreciation(depreciationValue);
                fixedAssetLine.setCumulativeDepreciation(cumulativeValue);
                fixedAssetLine.setResidualValue(fixedAsset.getGrossValue().subtract(fixedAssetLine.getCumulativeDepreciation()));
            }
            fixedAsset.addFixedAssetLineListItem(fixedAssetLine);
            if (!isLinear && counter == numberOfDepreciation || isLinear && isProrataTemporis && counter == numberOfDepreciation + 1 || !isProrataTemporis && counter == numberOfDepreciation) {
                depreciationValue = fixedAssetLine.getResidualValue();
                cumulativeValue = cumulativeValue.add(depreciationValue);
                depreciationDate = this.addPeriodicity(fixedAsset, firstDepreciationDate, counter);
                if (isProrataTemporis) {
                    depreciationDate = endDate = DateTool.plusMonths((LocalDate)acquisitionDate, (int)fixedAsset.getDurationInMonth()).minusDays(1L);
                }
                ++counter;
                continue;
            }
            if (fixedAsset.getComputationMethodSelect().equals("degressive")) {
                if (counter > 2 && fixedAsset.getNumberOfDepreciation() > 3) {
                    if (counter == 3) {
                        int remainingYear = fixedAsset.getNumberOfDepreciation() - 3;
                        depreciationValue = fixedAssetLine.getResidualValue().divide(new BigDecimal(remainingYear), RoundingMode.HALF_EVEN);
                    }
                } else {
                    depreciationValue = this.computeDepreciation(fixedAsset, fixedAssetLine.getResidualValue(), false, isLinear);
                }
                depreciationDate = this.addPeriodicity(fixedAsset, firstDepreciationDate, counter);
            } else {
                depreciationValue = this.computeDepreciation(fixedAsset, fixedAsset.getResidualValue(), false, isLinear);
                depreciationDate = this.addPeriodicity(fixedAsset, firstDepreciationDate, counter);
            }
            depreciationValue = depreciationValue.setScale(scale, RoundingMode.HALF_EVEN);
            cumulativeValue = cumulativeValue.add(depreciationValue).setScale(scale, RoundingMode.HALF_EVEN);
            ++counter;
        }
        return fixedAsset;
    }

    private LocalDate addPeriodicity(FixedAsset fixedAsset, LocalDate fisrtDepreciationDate, int counter) {
        LocalDate depreciationDate = DateTool.plusMonths((LocalDate)fisrtDepreciationDate, (int)(fixedAsset.getPeriodicityInMonth() * counter));
        if (depreciationDate.getMonthValue() == 2) {
            depreciationDate = fisrtDepreciationDate.plusMonths(fixedAsset.getPeriodicityInMonth() * counter);
        }
        return depreciationDate;
    }

    private BigDecimal computeDepreciationValue(FixedAsset fixedAsset, boolean isLinear) {
        BigDecimal depreciationValue = BigDecimal.ZERO;
        depreciationValue = this.computeDepreciation(fixedAsset, fixedAsset.getGrossValue(), true, isLinear);
        return depreciationValue;
    }

    private BigDecimal computeProrataTemporis(FixedAsset fixedAsset, boolean isFirstYear) {
        float prorataTemporis = 1.0f;
        if (isFirstYear && fixedAsset.getFixedAssetCategory().getIsProrataTemporis().booleanValue() && !fixedAsset.getAcquisitionDate().equals(fixedAsset.getFirstDepreciationDate())) {
            LocalDate acquisitionDate = fixedAsset.getAcquisitionDate();
            LocalDate depreciationDate = fixedAsset.getFirstDepreciationDate();
            long nbDaysOfPeriod = DateTool.daysBetween((LocalDate)DateTool.minusMonths((LocalDate)depreciationDate, (int)fixedAsset.getPeriodicityInMonth()), (LocalDate)depreciationDate, (boolean)false);
            long nbDaysBetweenAcqAndFirstDepDate = DateTool.daysBetween((LocalDate)acquisitionDate, (LocalDate)depreciationDate, (boolean)false) + 1L;
            prorataTemporis = (float)nbDaysBetweenAcqAndFirstDepDate / (float)nbDaysOfPeriod;
        }
        return BigDecimal.valueOf(prorataTemporis);
    }

    private BigDecimal computeDepreciation(FixedAsset fixedAsset, BigDecimal residualValue, boolean isFirstYear, boolean isLinear) {
        int scale = ((AppBaseService)Beans.get(AppBaseService.class)).getNbDecimalDigitForUnitPrice();
        int numberOfDepreciation = !isLinear && fixedAsset.getFixedAssetCategory().getIsProrataTemporis() != false ? fixedAsset.getNumberOfDepreciation() - 1 : fixedAsset.getNumberOfDepreciation();
        float depreciationRate = numberOfDepreciation == 0 ? 0.0f : 1.0f / (float)numberOfDepreciation * 100.0f;
        BigDecimal ddRate = BigDecimal.ONE;
        BigDecimal prorataTemporis = this.computeProrataTemporis(fixedAsset, isFirstYear);
        if (fixedAsset.getComputationMethodSelect().equals("degressive")) {
            ddRate = fixedAsset.getDegressiveCoef();
        }
        return residualValue.multiply(BigDecimal.valueOf(depreciationRate)).multiply(ddRate).multiply(prorataTemporis).divide(new BigDecimal(100), scale);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public List<FixedAsset> createFixedAssets(Invoice invoice) throws AxelorException {
        if (invoice == null || CollectionUtils.isEmpty(invoice.getInvoiceLineList())) {
            return null;
        }
        AccountConfig accountConfig = ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(invoice.getCompany());
        ArrayList<FixedAsset> fixedAssetList = new ArrayList<FixedAsset>();
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            if (accountConfig.getFixedAssetCatReqOnInvoice().booleanValue() && invoiceLine.getFixedAssets().booleanValue() && invoiceLine.getFixedAssetCategory() == null) {
                throw new AxelorException((Model)((Object)invoiceLine), 1, I18n.get((String)"Fixed asset category is missing on invoice line for product %s"), new Object[]{invoiceLine.getProductName()});
            }
            if (!invoiceLine.getFixedAssets().booleanValue() || invoiceLine.getFixedAssetCategory() == null) continue;
            FixedAsset fixedAsset = new FixedAsset();
            fixedAsset.setFixedAssetCategory(invoiceLine.getFixedAssetCategory());
            if (fixedAsset.getFixedAssetCategory().getIsValidateFixedAsset().booleanValue()) {
                fixedAsset.setStatusSelect(2);
            } else {
                fixedAsset.setStatusSelect(1);
            }
            fixedAsset.setAcquisitionDate(invoice.getInvoiceDate());
            fixedAsset.setFirstDepreciationDate(invoice.getInvoiceDate());
            fixedAsset.setReference(invoice.getInvoiceId());
            fixedAsset.setName(invoiceLine.getProductName() + " (" + invoiceLine.getQty() + ")");
            fixedAsset.setCompany(fixedAsset.getFixedAssetCategory().getCompany());
            fixedAsset.setJournal(fixedAsset.getFixedAssetCategory().getJournal());
            fixedAsset.setComputationMethodSelect(fixedAsset.getFixedAssetCategory().getComputationMethodSelect());
            fixedAsset.setDegressiveCoef(fixedAsset.getFixedAssetCategory().getDegressiveCoef());
            fixedAsset.setNumberOfDepreciation(fixedAsset.getFixedAssetCategory().getNumberOfDepreciation());
            fixedAsset.setPeriodicityInMonth(fixedAsset.getFixedAssetCategory().getPeriodicityInMonth());
            fixedAsset.setDurationInMonth(fixedAsset.getFixedAssetCategory().getDurationInMonth());
            fixedAsset.setGrossValue(invoiceLine.getCompanyExTaxTotal());
            fixedAsset.setPartner(invoice.getPartner());
            fixedAsset.setPurchaseAccount(invoiceLine.getAccount());
            fixedAsset.setInvoiceLine(invoiceLine);
            this.generateAndcomputeLines(fixedAsset);
            fixedAssetList.add((FixedAsset)((Object)this.fixedAssetRepo.save((Model)((Object)fixedAsset))));
        }
        return fixedAssetList;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void disposal(LocalDate disposalDate, BigDecimal disposalAmount, FixedAsset fixedAsset) throws AxelorException {
        FixedAssetLine previousRealizedLine;
        Map<Integer, List<FixedAssetLine>> FixedAssetLineMap = fixedAsset.getFixedAssetLineList().stream().collect(Collectors.groupingBy(fa -> fa.getStatusSelect()));
        List<FixedAssetLine> previousPlannedLineList = FixedAssetLineMap.get(1);
        List<FixedAssetLine> previousRealizedLineList = FixedAssetLineMap.get(2);
        FixedAssetLine previousPlannedLine = previousPlannedLineList != null && !previousPlannedLineList.isEmpty() ? previousPlannedLineList.get(0) : null;
        FixedAssetLine fixedAssetLine2 = previousRealizedLine = previousRealizedLineList != null && !previousRealizedLineList.isEmpty() ? previousRealizedLineList.get(previousRealizedLineList.size() - 1) : null;
        if (previousPlannedLine != null && disposalDate.isAfter(previousPlannedLine.getDepreciationDate())) {
            throw new AxelorException(5, I18n.get((String)"Disposal date shouldn't be after the next planned depreciation date. Please realize all depreciations that happened before the disposal."));
        }
        if (previousRealizedLine != null && disposalDate.isBefore(previousRealizedLine.getDepreciationDate())) {
            throw new AxelorException(5, I18n.get((String)"Disposal date must be after the date of the last depreciation."));
        }
        if (disposalAmount.compareTo(BigDecimal.ZERO) != 0) {
            FixedAssetLine depreciationFixedAssetLine = this.generateProrataDepreciationLine(fixedAsset, disposalDate, previousRealizedLine);
            this.fixedAssetLineService.realize(depreciationFixedAssetLine);
            this.fixedAssetLineService.generateDisposalMove(depreciationFixedAssetLine);
        } else if (disposalAmount.compareTo(fixedAsset.getResidualValue()) != 0) {
            return;
        }
        List fixedAssetLineList = fixedAsset.getFixedAssetLineList().stream().filter(fixedAssetLine -> fixedAssetLine.getStatusSelect() == 1).collect(Collectors.toList());
        for (FixedAssetLine fixedAssetLine3 : fixedAssetLineList) {
            fixedAsset.removeFixedAssetLineListItem(fixedAssetLine3);
        }
        fixedAsset.setStatusSelect(4);
        fixedAsset.setDisposalDate(disposalDate);
        fixedAsset.setDisposalValue(disposalAmount);
        this.fixedAssetRepo.save((Model)((Object)fixedAsset));
    }

    private FixedAssetLine generateProrataDepreciationLine(FixedAsset fixedAsset, LocalDate disposalDate, FixedAssetLine previousRealizedLine) {
        LocalDate previousRealizedDate = previousRealizedLine != null ? previousRealizedLine.getDepreciationDate() : fixedAsset.getFirstDepreciationDate();
        long monthsBetweenDates = ChronoUnit.MONTHS.between(previousRealizedDate.withDayOfMonth(1), disposalDate.withDayOfMonth(1));
        FixedAssetLine fixedAssetLine = new FixedAssetLine();
        fixedAssetLine.setDepreciationDate(disposalDate);
        BigDecimal prorataTemporis = new BigDecimal((float)monthsBetweenDates / fixedAsset.getPeriodicityInMonth().floatValue());
        int scale = ((AppBaseService)Beans.get(AppBaseService.class)).getNbDecimalDigitForUnitPrice();
        int numberOfDepreciation = fixedAsset.getFixedAssetCategory().getIsProrataTemporis() != false ? fixedAsset.getNumberOfDepreciation() - 1 : fixedAsset.getNumberOfDepreciation();
        float depreciationRate = 1.0f / (float)numberOfDepreciation * 100.0f;
        BigDecimal ddRate = BigDecimal.ONE;
        if (fixedAsset.getComputationMethodSelect().equals("degressive")) {
            ddRate = fixedAsset.getDegressiveCoef();
        }
        BigDecimal deprecationValue = fixedAsset.getGrossValue().multiply(new BigDecimal(depreciationRate)).multiply(ddRate).multiply(prorataTemporis).divide(new BigDecimal(100), scale);
        fixedAssetLine.setDepreciation(deprecationValue);
        BigDecimal cumulativeValue = previousRealizedLine != null ? previousRealizedLine.getCumulativeDepreciation().add(deprecationValue) : deprecationValue;
        fixedAssetLine.setCumulativeDepreciation(cumulativeValue);
        fixedAssetLine.setResidualValue(fixedAsset.getGrossValue().subtract(fixedAssetLine.getCumulativeDepreciation()));
        fixedAsset.addFixedAssetLineListItem(fixedAssetLine);
        return fixedAssetLine;
    }

    @Override
    @Transactional
    public void createAnalyticOnMoveLine(AnalyticDistributionTemplate analyticDistributionTemplate, MoveLine moveLine) throws AxelorException {
        if (analyticDistributionTemplate != null && moveLine.getAccount().getAnalyticDistributionAuthorized().booleanValue()) {
            moveLine.setAnalyticDistributionTemplate(analyticDistributionTemplate);
            moveLine = this.moveLineService.createAnalyticDistributionWithTemplate(moveLine);
        }
    }

    @Override
    public void updateAnalytic(FixedAsset fixedAsset) throws AxelorException {
        if (fixedAsset.getAnalyticDistributionTemplate() != null) {
            if (fixedAsset.getDisposalMove() != null) {
                for (MoveLine moveLine : fixedAsset.getDisposalMove().getMoveLineList()) {
                    this.createAnalyticOnMoveLine(fixedAsset.getAnalyticDistributionTemplate(), moveLine);
                }
            }
            if (fixedAsset.getFixedAssetLineList() != null) {
                for (FixedAssetLine fixedAssetLine : fixedAsset.getFixedAssetLineList()) {
                    if (fixedAssetLine.getDepreciationAccountMove() == null) continue;
                    for (MoveLine moveLine : fixedAssetLine.getDepreciationAccountMove().getMoveLineList()) {
                        this.createAnalyticOnMoveLine(fixedAsset.getAnalyticDistributionTemplate(), moveLine);
                    }
                }
            }
        }
    }
}

