/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoiceLineTax;
import com.axelor.apps.account.db.Irrecoverable;
import com.axelor.apps.account.db.IrrecoverableCustomerLine;
import com.axelor.apps.account.db.IrrecoverableInvoiceLine;
import com.axelor.apps.account.db.IrrecoverablePaymentScheduleLineLine;
import com.axelor.apps.account.db.IrrecoverableReportLine;
import com.axelor.apps.account.db.ManagementObject;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.IrrecoverableCustomerLineRepository;
import com.axelor.apps.account.db.repo.IrrecoverableRepository;
import com.axelor.apps.account.db.repo.ManagementObjectRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleRepository;
import com.axelor.apps.account.service.PaymentScheduleService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.TaxAccountService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.tax.TaxService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrrecoverableService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SequenceService sequenceService;
    protected MoveService moveService;
    protected MoveLineService moveLineService;
    protected MoveLineRepository moveLineRepo;
    protected ReconcileService reconcileService;
    protected TaxService taxService;
    protected TaxAccountService taxAccountService;
    protected PaymentScheduleService paymentScheduleService;
    protected PaymentScheduleRepository paymentScheduleRepo;
    protected PaymentScheduleLineRepository paymentScheduleLineRepo;
    protected AccountConfigService accountConfigService;
    protected IrrecoverableCustomerLineRepository irrecoverableCustomerLineRepo;
    protected InvoiceRepository invoiceRepo;
    protected ManagementObjectRepository managementObjectRepo;
    protected IrrecoverableRepository irrecoverableRepo;
    protected AppAccountService appAccountService;

    @Inject
    public IrrecoverableService(AppAccountService appAccountService, SequenceService sequenceService, MoveService moveService, MoveLineService moveLineService, MoveLineRepository moveLineRepo, ReconcileService reconcileService, TaxService taxService, TaxAccountService taxAccountService, PaymentScheduleService paymentScheduleService, PaymentScheduleRepository paymentScheduleRepo, PaymentScheduleLineRepository paymentScheduleLineRepo, AccountConfigService accountConfigService, IrrecoverableCustomerLineRepository irrecoverableCustomerLineRepo, InvoiceRepository invoiceRepo, ManagementObjectRepository managementObjectRepo, IrrecoverableRepository irrecoverableRepo) {
        this.sequenceService = sequenceService;
        this.moveService = moveService;
        this.moveLineService = moveLineService;
        this.moveLineRepo = moveLineRepo;
        this.reconcileService = reconcileService;
        this.taxService = taxService;
        this.taxAccountService = taxAccountService;
        this.paymentScheduleService = paymentScheduleService;
        this.paymentScheduleRepo = paymentScheduleRepo;
        this.paymentScheduleLineRepo = paymentScheduleLineRepo;
        this.accountConfigService = accountConfigService;
        this.irrecoverableCustomerLineRepo = irrecoverableCustomerLineRepo;
        this.invoiceRepo = invoiceRepo;
        this.managementObjectRepo = managementObjectRepo;
        this.irrecoverableRepo = irrecoverableRepo;
        this.appAccountService = appAccountService;
    }

    @Transactional(rollbackOn={Exception.class})
    public void getIrrecoverable(Irrecoverable irrecoverable) throws AxelorException {
        Company company = irrecoverable.getCompany();
        this.testCompanyField(company);
        if (irrecoverable.getName() == null) {
            irrecoverable.setName(this.getSequence(company));
        }
        irrecoverable.setInvoiceSet(new HashSet<Invoice>());
        irrecoverable.getInvoiceSet().addAll(this.getInvoiceList(company));
        irrecoverable.getInvoiceSet().addAll(this.getRejectInvoiceList(company));
        irrecoverable.setPaymentScheduleLineSet(new HashSet<PaymentScheduleLine>());
        irrecoverable.getPaymentScheduleLineSet().addAll(this.getPaymentScheduleLineList(company));
        this.irrecoverableRepo.save((Model)((Object)irrecoverable));
    }

    public List<Partner> getPayerPartnerList(Set<Invoice> invoiceList) {
        ArrayList<Partner> partnerList = new ArrayList<Partner>();
        for (Invoice invoice : invoiceList) {
            if (partnerList.contains((Object)invoice.getPartner())) continue;
            partnerList.add(invoice.getPartner());
        }
        return partnerList;
    }

    public List<Invoice> getInvoiceList(Company company) {
        return this.invoiceRepo.all().filter("self.irrecoverableStatusSelect = ?1 AND self.company = ?2 AND self.statusSelect = ?3 AND self.companyInTaxTotalRemaining > 0 AND self.rejectMoveLine IS NULL", new Object[]{1, company, 3}).order("dueDate").fetch();
    }

    public List<Invoice> getRejectInvoiceList(Company company) {
        return this.invoiceRepo.all().filter("self.irrecoverableStatusSelect = ?1 AND self.company = ?2 AND self.statusSelect = ?3 AND self.companyInTaxTotalRemaining = 0 AND self.rejectMoveLine IS NOT NULL", new Object[]{1, company, 3}).order("dueDate").fetch();
    }

    public List<PaymentScheduleLine> getPaymentScheduleLineList(Company company) {
        return this.paymentScheduleLineRepo.all().filter("self.paymentSchedule.irrecoverableStatusSelect = ?1 AND self.paymentSchedule.company = ?2 AND self.paymentSchedule.statusSelect = ?3 AND self.rejectMoveLine.amountRemaining > 0", new Object[]{1, company, 2}).order("scheduleDate").fetch();
    }

    public List<Invoice> getInvoiceList(Partner partner, Set<Invoice> allInvoiceList) {
        ArrayList<Invoice> invoiceList = new ArrayList<Invoice>();
        for (Invoice invoice : allInvoiceList) {
            if (!invoice.getPartner().equals((Object)partner)) continue;
            invoiceList.add(invoice);
        }
        this.log.debug("Nombre de facture \u00e0 passer en irr\u00e9couvrable pour le tiers : {}", (Object)invoiceList.size());
        return invoiceList;
    }

    public List<PaymentScheduleLine> getPaymentScheduleLineList(Partner payerPartner, Set<PaymentScheduleLine> allPaymentScheduleLineList) {
        ArrayList<PaymentScheduleLine> paymentScheduleLineList = new ArrayList<PaymentScheduleLine>();
        for (PaymentScheduleLine paymentScheduleLine : allPaymentScheduleLineList) {
            if (!paymentScheduleLine.getPaymentSchedule().getPartner().equals((Object)payerPartner)) continue;
            paymentScheduleLineList.add(paymentScheduleLine);
        }
        this.log.debug("Nombre d'\u00e9ch\u00e9ances \u00e0 passer en irr\u00e9couvrable pour le tiers : {}", (Object)paymentScheduleLineList.size());
        return paymentScheduleLineList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void createIrrecoverableReport(Irrecoverable irrecoverable) {
        Set<Invoice> invoiceSet = irrecoverable.getInvoiceSet();
        Set<PaymentScheduleLine> paymentScheduleLineSet = irrecoverable.getPaymentScheduleLineSet();
        irrecoverable.setMoveSet(new HashSet<Move>());
        List<Partner> payerPartnerList = this.getPayerPartnerList(invoiceSet);
        EntityTransaction transaction = JPA.em().getTransaction();
        int i = 0;
        if (payerPartnerList != null && payerPartnerList.size() != 0) {
            for (Partner payerPartner : payerPartnerList) {
                if (!transaction.isActive()) {
                    transaction.begin();
                }
                ++i;
                try {
                    this.log.debug("Tiers : {}", (Object)payerPartner.getName());
                    this.createIrrecoverableCustomerLine(irrecoverable, payerPartner, this.getInvoiceList(payerPartner, invoiceSet), this.getPaymentScheduleLineList(payerPartner, paymentScheduleLineSet));
                    this.irrecoverableRepo.save((Model)((Object)irrecoverable));
                    transaction.commit();
                    if (i % 50 != 0) continue;
                    JPA.flush();
                    JPA.clear();
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)e);
                    this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le tiers : {}", (Object)payerPartner.getName());
                }
                finally {
                    if (!transaction.isActive()) {
                        transaction.begin();
                    }
                }
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public IrrecoverableCustomerLine createIrrecoverableCustomerLine(Irrecoverable irrecoverable, Partner payerPartner, List<Invoice> invoiceList, List<PaymentScheduleLine> paymentScheduleLineList) throws AxelorException {
        IrrecoverableCustomerLine icl = new IrrecoverableCustomerLine();
        icl.setIrrecoverable(irrecoverable);
        this.irrecoverableCustomerLineRepo.save((Model)((Object)icl));
        irrecoverable.getIrrecoverableCustomerLineList().add(icl);
        icl.setPartner(payerPartner);
        icl.setIrrecoverablePaymentScheduleLineLineList(this.createIrrecoverablePaymentScheduleLineLineList(icl, paymentScheduleLineList));
        icl.setIrrecoverableInvoiceLineList(this.createIrrecoverableInvoiceLineList(icl, invoiceList));
        this.log.debug("Ligne client : {}", (Object)icl);
        return icl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int passInIrrecoverable(Irrecoverable irrecoverable) throws AxelorException {
        irrecoverable.setMoveSet(new HashSet<Move>());
        EntityTransaction transaction = JPA.em().getTransaction();
        int anomaly = 0;
        this.testCompanyField(irrecoverable.getCompany());
        int i = 0;
        if (irrecoverable.getInvoiceSet() != null && irrecoverable.getInvoiceSet().size() != 0) {
            for (Invoice invoice : irrecoverable.getInvoiceSet()) {
                ++i;
                if (!transaction.isActive()) {
                    transaction.begin();
                }
                try {
                    this.log.debug("Facture : {}", (Object)invoice.getInvoiceId());
                    this.createIrrecoverableInvoiceLineMove(irrecoverable, invoice);
                    this.irrecoverableRepo.save((Model)((Object)irrecoverable));
                    if (i % 50 != 0) continue;
                    JPA.flush();
                    JPA.clear();
                }
                catch (AxelorException e) {
                    ++anomaly;
                    TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Invoice") + " %s", new Object[]{invoice.getInvoiceId()}), (String)"irrecoverable", (long)irrecoverable.getId());
                    this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour la facture : {}", (Object)invoice.getInvoiceId());
                }
                catch (Exception e) {
                    ++anomaly;
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Invoice") + " %s", invoice.getInvoiceId()), e), (String)"irrecoverable", (long)irrecoverable.getId());
                    this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour la facture : {}", (Object)invoice.getInvoiceId());
                }
                finally {
                    if (!transaction.isActive()) {
                        transaction.begin();
                    }
                }
            }
        }
        if (irrecoverable.getPaymentScheduleLineSet() != null && irrecoverable.getPaymentScheduleLineSet().size() != 0) {
            for (PaymentScheduleLine paymentScheduleLine : irrecoverable.getPaymentScheduleLineSet()) {
                ++i;
                if (!transaction.isActive()) {
                    transaction.begin();
                }
                try {
                    this.log.debug("Ligne d'\u00e9ch\u00e9ancier : {}", (Object)paymentScheduleLine.getName());
                    this.createMoveForPaymentScheduleLineReject(irrecoverable, paymentScheduleLine);
                    this.irrecoverableRepo.save((Model)((Object)irrecoverable));
                    if (i % 50 != 0) continue;
                    JPA.flush();
                    JPA.clear();
                }
                catch (AxelorException e) {
                    ++anomaly;
                    TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Timetable line %s"), new Object[]{paymentScheduleLine.getName()}), (String)"irrecoverable", (long)irrecoverable.getId());
                    this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour la ligne d'\u00e9ch\u00e9ancier : {}", (Object)paymentScheduleLine.getName());
                }
                catch (Exception e) {
                    ++anomaly;
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Timetable line %s"), paymentScheduleLine.getName()), e), (String)"irrecoverable", (long)irrecoverable.getId());
                    this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour la ligne d'\u00e9ch\u00e9ancier : {}", (Object)paymentScheduleLine.getName());
                }
                finally {
                    if (!transaction.isActive()) {
                        transaction.begin();
                    }
                }
            }
        }
        if (!transaction.isActive()) {
            transaction.begin();
        }
        irrecoverable.setStatusSelect(2);
        this.irrecoverableRepo.save((Model)((Object)irrecoverable));
        transaction.commit();
        return anomaly;
    }

    @Transactional(rollbackOn={Exception.class})
    public void createMoveForPaymentScheduleLineReject(Irrecoverable irrecoverable, PaymentScheduleLine paymentScheduleLine) throws AxelorException {
        Move move = this.createIrrecoverableMove(paymentScheduleLine.getRejectMoveLine(), irrecoverable.getName());
        if (move == null) {
            throw new AxelorException((Model)((Object)irrecoverable), 5, I18n.get((String)"%s : Error generated on invoice creation shift to irrecoverable %s"), new Object[]{I18n.get((String)"Warning !")});
        }
        this.moveService.getMoveValidateService().validate(move);
        irrecoverable.getMoveSet().add(move);
    }

    @Transactional(rollbackOn={Exception.class})
    public void createIrrecoverableInvoiceLineMove(Irrecoverable irrecoverable, Invoice invoice) throws AxelorException {
        BigDecimal prorataRate = this.getProrataRate(invoice, invoice.getRejectMoveLine() != null);
        Move move = this.createIrrecoverableMove(invoice, prorataRate, invoice.getRejectMoveLine() != null, irrecoverable.getName());
        if (move == null) {
            throw new AxelorException((Model)((Object)irrecoverable), 5, I18n.get((String)"%s : Error generated on invoice creation shift to irrecoverable %s"), new Object[]{I18n.get((String)"Warning !")});
        }
        this.moveService.getMoveValidateService().validate(move);
        irrecoverable.getMoveSet().add(move);
        invoice.setIrrecoverableStatusSelect(2);
        if (invoice.getCanceledPaymentSchedule() != null && this.isAllInvoicePassedInIrrecoverable(invoice.getCanceledPaymentSchedule())) {
            invoice.getCanceledPaymentSchedule().setIrrecoverableStatusSelect(2);
        }
    }

    public List<IrrecoverableInvoiceLine> createIrrecoverableInvoiceLineList(IrrecoverableCustomerLine icl, List<Invoice> invoiceList) throws AxelorException {
        int seq = 1;
        ArrayList<IrrecoverableInvoiceLine> iilList = new ArrayList<IrrecoverableInvoiceLine>();
        for (Invoice invoice : invoiceList) {
            iilList.add(this.createIrrecoverableInvoiceLine(icl, invoice, seq));
            ++seq;
        }
        return iilList;
    }

    public List<IrrecoverablePaymentScheduleLineLine> createIrrecoverablePaymentScheduleLineLineList(IrrecoverableCustomerLine icl, List<PaymentScheduleLine> paymentScheduleLineList) throws AxelorException {
        int seq = 1;
        ArrayList<IrrecoverablePaymentScheduleLineLine> ipsllList = new ArrayList<IrrecoverablePaymentScheduleLineLine>();
        for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLineList) {
            ipsllList.add(this.createIrrecoverablePaymentScheduleLineLine(icl, paymentScheduleLine, seq));
            ++seq;
        }
        return ipsllList;
    }

    public IrrecoverableInvoiceLine createIrrecoverableInvoiceLine(IrrecoverableCustomerLine icl, Invoice invoice, int seq) throws AxelorException {
        IrrecoverableInvoiceLine iil = new IrrecoverableInvoiceLine();
        iil.setInvoice(invoice);
        iil.setInvoiceLineSeq(seq);
        iil.setIrrecoverableCustomerLine(icl);
        BigDecimal prorataRate = this.getProrataRate(invoice, invoice.getRejectMoveLine() != null);
        iil.setIrrecoverableReportLineList(this.createIrrecoverableReportLineList(iil, invoice, prorataRate));
        this.log.debug("Ligne facture : {}", (Object)iil);
        return iil;
    }

    public IrrecoverablePaymentScheduleLineLine createIrrecoverablePaymentScheduleLineLine(IrrecoverableCustomerLine icl, PaymentScheduleLine paymentScheduleLine, int seq) throws AxelorException {
        IrrecoverablePaymentScheduleLineLine ipsll = new IrrecoverablePaymentScheduleLineLine();
        ipsll.setPaymentScheduleLine(paymentScheduleLine);
        ipsll.setIrrecoverableCustomerLine(icl);
        Company company = paymentScheduleLine.getPaymentSchedule().getCompany();
        Tax tax = this.accountConfigService.getIrrecoverableStandardRateTax(this.accountConfigService.getAccountConfig(company));
        ipsll.setIrrecoverableReportLineList(this.createIrrecoverableReportLineList(ipsll, paymentScheduleLine, tax));
        this.log.debug("Ligne \u00e9ch\u00e9ance rejet\u00e9e : {}", (Object)ipsll);
        return ipsll;
    }

    public boolean isAllInvoicePassedInIrrecoverable(PaymentSchedule paymentSchedule) {
        for (Invoice invoiceScheduled : paymentSchedule.getInvoiceSet()) {
            if (!invoiceScheduled.getIrrecoverableStatusSelect().equals(1)) continue;
            return false;
        }
        return true;
    }

    public List<IrrecoverableReportLine> createIrrecoverableReportLineList(IrrecoverableInvoiceLine iil, Invoice invoice, BigDecimal prorataRate) {
        int seq = 1;
        ArrayList<IrrecoverableReportLine> irlList = new ArrayList<IrrecoverableReportLine>();
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            irlList.add(this.createIrrecoverableReportLine(iil, invoiceLine.getName(), invoiceLine.getExTaxTotal().multiply(prorataRate).setScale(2, RoundingMode.HALF_EVEN), seq));
            ++seq;
        }
        for (InvoiceLineTax invoiceLineTax : invoice.getInvoiceLineTaxList()) {
            irlList.add(this.createIrrecoverableReportLine(iil, invoiceLineTax.getTaxLine().getTax().getName(), invoiceLineTax.getTaxTotal().multiply(prorataRate).setScale(2, RoundingMode.HALF_EVEN), seq));
            ++seq;
        }
        this.invoiceRepo.refresh((Model)((Object)invoice));
        return irlList;
    }

    public List<IrrecoverableReportLine> createIrrecoverableReportLineList(IrrecoverablePaymentScheduleLineLine ipsll, PaymentScheduleLine paymentScheduleLine, Tax tax) throws AxelorException {
        ArrayList<IrrecoverableReportLine> irlList = new ArrayList<IrrecoverableReportLine>();
        BigDecimal taxRate = this.taxService.getTaxRate(tax, this.appAccountService.getTodayDate());
        BigDecimal amount = paymentScheduleLine.getInTaxAmount();
        BigDecimal divid = taxRate.add(BigDecimal.ONE);
        BigDecimal irrecoverableAmount = amount.divide(divid, 6, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal taxAmount = amount.subtract(irrecoverableAmount);
        irlList.add(this.createIrrecoverableReportLine(ipsll, "HT", irrecoverableAmount, 1));
        irlList.add(this.createIrrecoverableReportLine(ipsll, tax.getName(), taxAmount, 2));
        return irlList;
    }

    public IrrecoverableReportLine createIrrecoverableReportLine(IrrecoverableInvoiceLine iil, String label, BigDecimal value, int seq) {
        IrrecoverableReportLine irl = new IrrecoverableReportLine();
        irl.setReportLineSeq(seq);
        irl.setLabel(label);
        irl.setValue(value);
        irl.setIrrecoverableInvoiceLine(iil);
        this.log.debug("Ligne reporting : {}", (Object)irl);
        return irl;
    }

    public IrrecoverableReportLine createIrrecoverableReportLine(IrrecoverablePaymentScheduleLineLine ipsll, String label, BigDecimal value, int seq) {
        IrrecoverableReportLine irl = new IrrecoverableReportLine();
        irl.setReportLineSeq(seq);
        irl.setLabel(label);
        irl.setValue(value);
        irl.setIrrecoverablePaymentScheduleLineLine(ipsll);
        this.log.debug("Ligne reporting : {}", (Object)irl);
        return irl;
    }

    public BigDecimal getProrataRate(Invoice invoice, boolean isInvoiceReject) {
        BigDecimal prorataRate = null;
        prorataRate = isInvoiceReject ? invoice.getRejectMoveLine().getAmountRemaining().divide(invoice.getInTaxTotal(), 6, RoundingMode.HALF_EVEN) : invoice.getCompanyInTaxTotalRemaining().divide(invoice.getInTaxTotal(), 6, RoundingMode.HALF_EVEN);
        this.log.debug("Taux d'impay\u00e9 pour la facture {} : {}", (Object)invoice.getInvoiceId(), (Object)prorataRate);
        return prorataRate;
    }

    public Move createIrrecoverableMove(Invoice invoice, BigDecimal prorataRate, boolean isInvoiceReject, String irrecoverableName) throws AxelorException {
        Company company = invoice.getCompany();
        Partner payerPartner = invoice.getPartner();
        AccountConfig accountConfig = company.getAccountConfig();
        Move move = this.moveService.getMoveCreateService().createMove(accountConfig.getIrrecoverableJournal(), company, null, payerPartner, null, 2);
        int seq = 1;
        BigDecimal amount = BigDecimal.ZERO;
        MoveLine debitMoveLine = null;
        BigDecimal creditAmount = null;
        BigDecimal debitAmount = null;
        debitAmount = isInvoiceReject ? (creditAmount = invoice.getRejectMoveLine().getAmountRemaining()) : (creditAmount = invoice.getCompanyInTaxTotalRemaining());
        for (InvoiceLineTax invoiceLineTax : invoice.getInvoiceLineTaxList()) {
            amount = invoiceLineTax.getTaxTotal().multiply(prorataRate).setScale(2, RoundingMode.HALF_EVEN);
            debitMoveLine = this.moveLineService.createMoveLine(move, payerPartner, this.taxAccountService.getAccount(invoiceLineTax.getTaxLine().getTax(), company, false, false), amount, true, this.appAccountService.getTodayDate(), seq, irrecoverableName, invoice.getInvoiceId());
            move.getMoveLineList().add(debitMoveLine);
            ++seq;
            debitAmount = debitAmount.subtract(amount);
        }
        debitMoveLine = this.moveLineService.createMoveLine(move, payerPartner, accountConfig.getIrrecoverableAccount(), debitAmount, true, this.appAccountService.getTodayDate(), seq, irrecoverableName, invoice.getInvoiceId());
        move.getMoveLineList().add(debitMoveLine);
        ++seq;
        MoveLine customerMoveLine = this.moveService.getMoveToolService().getCustomerMoveLineByQuery(invoice);
        if (customerMoveLine == null) {
            throw new AxelorException(5, I18n.get((String)"%s : The invoice %s has no accounting document whose the remainder to be paid is positive"), new Object[]{I18n.get((String)"Warning !"), invoice.getInvoiceId()});
        }
        customerMoveLine.setIrrecoverableStatusSelect(2);
        MoveLine creditMoveLine = this.moveLineService.createMoveLine(move, payerPartner, customerMoveLine.getAccount(), creditAmount, false, this.appAccountService.getTodayDate(), seq, irrecoverableName, invoice.getInvoiceId());
        move.getMoveLineList().add(creditMoveLine);
        Reconcile reconcile = this.reconcileService.createReconcile(customerMoveLine, creditMoveLine, creditAmount, false);
        if (reconcile != null) {
            this.reconcileService.confirmReconcile(reconcile, true);
        }
        return move;
    }

    public Move createIrrecoverableMove(MoveLine moveLine, String irrecoverableName) throws AxelorException {
        Company company = moveLine.getMove().getCompany();
        Partner payerPartner = moveLine.getPartner();
        BigDecimal amount = moveLine.getAmountRemaining();
        AccountConfig accountConfig = company.getAccountConfig();
        Move move = this.moveService.getMoveCreateService().createMove(accountConfig.getIrrecoverableJournal(), company, null, payerPartner, null, 2);
        int seq = 1;
        MoveLine creditMoveLine = this.moveLineService.createMoveLine(move, payerPartner, moveLine.getAccount(), amount, false, this.appAccountService.getTodayDate(), seq, irrecoverableName, moveLine.getDescription());
        move.getMoveLineList().add(creditMoveLine);
        Reconcile reconcile = this.reconcileService.createReconcile(moveLine, creditMoveLine, amount, false);
        if (reconcile != null) {
            this.reconcileService.confirmReconcile(reconcile, true);
        }
        Tax tax = accountConfig.getIrrecoverableStandardRateTax();
        BigDecimal taxRate = this.taxService.getTaxRate(tax, this.appAccountService.getTodayDate());
        BigDecimal divid = taxRate.add(BigDecimal.ONE);
        BigDecimal irrecoverableAmount = amount.divide(divid, 6, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN);
        MoveLine creditMoveLine1 = this.moveLineService.createMoveLine(move, payerPartner, accountConfig.getIrrecoverableAccount(), irrecoverableAmount, true, this.appAccountService.getTodayDate(), 2, irrecoverableName, moveLine.getDescription());
        move.getMoveLineList().add(creditMoveLine1);
        Account taxAccount = this.taxAccountService.getAccount(tax, company, false, false);
        BigDecimal taxAmount = amount.subtract(irrecoverableAmount);
        MoveLine creditMoveLine2 = this.moveLineService.createMoveLine(move, payerPartner, taxAccount, taxAmount, true, this.appAccountService.getTodayDate(), 3, irrecoverableName, moveLine.getDescription());
        move.getMoveLineList().add(creditMoveLine2);
        return move;
    }

    public ManagementObject createManagementObject(String code, String message) {
        ManagementObject managementObject = (ManagementObject)this.managementObjectRepo.all().filter("self.code = ?1 AND self.name = ?2", new Object[]{code, message}).fetchOne();
        if (managementObject != null) {
            return managementObject;
        }
        managementObject = new ManagementObject();
        managementObject.setCode(code);
        managementObject.setName(message);
        return managementObject;
    }

    public void testCompanyField(Company company) throws AxelorException {
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        this.accountConfigService.getIrrecoverableAccount(accountConfig);
        this.accountConfigService.getIrrecoverableJournal(accountConfig);
        this.accountConfigService.getIrrecoverableStandardRateTax(accountConfig);
    }

    public String getSequence(Company company) throws AxelorException {
        String seq = this.sequenceService.getSequenceNumber("irrecoverable", company);
        if (seq == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure shit to irrecoverable sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return seq;
    }

    @Transactional(rollbackOn={Exception.class})
    public void passInIrrecoverable(Invoice invoice, boolean generateEvent) throws AxelorException {
        invoice.setIrrecoverableStatusSelect(1);
        if (generateEvent) {
            Company company = invoice.getCompany();
            ManagementObject managementObject = this.createManagementObject("IRR", this.accountConfigService.getIrrecoverableReasonPassage(this.accountConfigService.getAccountConfig(company)));
            invoice.setManagementObject(managementObject);
            MoveLine moveLine = this.moveService.getMoveToolService().getCustomerMoveLineByQuery(invoice);
            if (moveLine == null) {
                throw new AxelorException(5, I18n.get((String)"%s : The invoice %s has no accounting document whose the remainder to be paid is positive"), new Object[]{I18n.get((String)"Warning !"), invoice.getInvoiceId()});
            }
            this.passInIrrecoverable(moveLine, managementObject, false);
        }
        this.invoiceRepo.save((Model)((Object)invoice));
    }

    public void passInIrrecoverable(Invoice invoice, ManagementObject managementObject) throws AxelorException {
        this.passInIrrecoverable(invoice, false);
        invoice.setManagementObject(managementObject);
        MoveLine moveLine = this.moveService.getMoveToolService().getCustomerMoveLineByQuery(invoice);
        if (moveLine == null) {
            throw new AxelorException(5, I18n.get((String)"%s : The invoice %s has no accounting document whose the remainder to be paid is positive"), new Object[]{I18n.get((String)"Warning !"), invoice.getInvoiceId()});
        }
        this.passInIrrecoverable(moveLine, managementObject, false);
        this.invoiceRepo.save((Model)((Object)invoice));
    }

    @Transactional(rollbackOn={Exception.class})
    public void notPassInIrrecoverable(Invoice invoice) throws AxelorException {
        invoice.setIrrecoverableStatusSelect(0);
        MoveLine moveLine = this.moveService.getMoveToolService().getCustomerMoveLineByQuery(invoice);
        if (moveLine != null) {
            this.notPassInIrrecoverable(moveLine, false);
        }
        this.invoiceRepo.save((Model)((Object)invoice));
    }

    @Transactional(rollbackOn={Exception.class})
    public void passInIrrecoverable(MoveLine moveLine, boolean generateEvent, boolean passInvoice) throws AxelorException {
        moveLine.setIrrecoverableStatusSelect(1);
        ManagementObject managementObject = null;
        if (generateEvent) {
            Company company = moveLine.getMove().getCompany();
            managementObject = this.createManagementObject("IRR", this.accountConfigService.getIrrecoverableReasonPassage(this.accountConfigService.getAccountConfig(company)));
            moveLine.setManagementObject(managementObject);
        }
        if (moveLine.getMove().getInvoice() != null && passInvoice) {
            this.passInIrrecoverable(moveLine.getMove().getInvoice(), managementObject);
        }
        this.moveLineRepo.save((Model)((Object)moveLine));
    }

    public void passInIrrecoverable(MoveLine moveLine, ManagementObject managementObject, boolean passInvoice) throws AxelorException {
        this.passInIrrecoverable(moveLine, false, passInvoice);
        moveLine.setManagementObject(managementObject);
        this.moveLineRepo.save((Model)((Object)moveLine));
    }

    @Transactional(rollbackOn={Exception.class})
    public void notPassInIrrecoverable(MoveLine moveLine, boolean passInvoice) throws AxelorException {
        moveLine.setIrrecoverableStatusSelect(0);
        if (moveLine.getMove().getInvoice() != null && passInvoice) {
            this.notPassInIrrecoverable(moveLine.getMove().getInvoice());
        }
        this.moveLineRepo.save((Model)((Object)moveLine));
    }

    @Transactional(rollbackOn={Exception.class})
    public void passInIrrecoverable(PaymentSchedule paymentSchedule) throws AxelorException {
        Company company = paymentSchedule.getCompany();
        paymentSchedule.setIrrecoverableStatusSelect(1);
        ManagementObject managementObject = this.createManagementObject("IRR", this.accountConfigService.getIrrecoverableReasonPassage(this.accountConfigService.getAccountConfig(company)));
        paymentSchedule.setManagementObject(managementObject);
        ArrayList<MoveLine> paymentScheduleLineRejectMoveLineList = new ArrayList<MoveLine>();
        for (PaymentScheduleLine paymentScheduleLine : paymentSchedule.getPaymentScheduleLineList()) {
            if (paymentScheduleLine.getRejectMoveLine() == null || paymentScheduleLine.getRejectMoveLine().getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
            paymentScheduleLineRejectMoveLineList.add(paymentScheduleLine.getRejectMoveLine());
        }
        for (MoveLine moveLine : paymentScheduleLineRejectMoveLineList) {
            this.passInIrrecoverable(moveLine, managementObject, true);
        }
        for (Invoice invoice : paymentSchedule.getInvoiceSet()) {
            if (invoice.getCompanyInTaxTotalRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
            this.passInIrrecoverable(invoice, managementObject);
        }
        this.paymentScheduleService.cancelPaymentSchedule(paymentSchedule);
        this.paymentScheduleRepo.save((Model)((Object)paymentSchedule));
    }

    @Transactional(rollbackOn={Exception.class})
    public void notPassInIrrecoverable(PaymentSchedule paymentSchedule) throws AxelorException {
        paymentSchedule.setIrrecoverableStatusSelect(0);
        ArrayList<MoveLine> paymentScheduleLineRejectMoveLineList = new ArrayList<MoveLine>();
        for (PaymentScheduleLine paymentScheduleLine : paymentSchedule.getPaymentScheduleLineList()) {
            if (paymentScheduleLine.getRejectMoveLine() == null || paymentScheduleLine.getRejectMoveLine().getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
            paymentScheduleLineRejectMoveLineList.add(paymentScheduleLine.getRejectMoveLine());
        }
        for (MoveLine moveLine : paymentScheduleLineRejectMoveLineList) {
            this.notPassInIrrecoverable(moveLine, false);
        }
        for (Invoice invoice : paymentSchedule.getInvoiceSet()) {
            this.notPassInIrrecoverable(invoice);
        }
        this.paymentScheduleRepo.save((Model)((Object)paymentSchedule));
    }
}

