/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Journal;
import com.axelor.db.JPA;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Integer BALANCE_TYPE_DEBIT_BALANCE = 1;
    public static final Integer BALANCE_TYPE_CREDIT_BALANCE = 1;

    public BigDecimal computeBalance(Journal journal, int accountType, int balanceType) {
        Query balanceQuery = JPA.em().createQuery("select sum(self.debit - self.credit) from MoveLine self where self.move.journal = :journal and self.move.ignoreInAccountingOk IN ('false', null) and self.move.statusSelect IN (2, 3) and self.account.accountType.technicalTypeSelect = :accountType");
        balanceQuery.setParameter("journal", (Object)journal);
        balanceQuery.setParameter("accountType", (Object)accountType);
        BigDecimal balance = (BigDecimal)balanceQuery.getSingleResult();
        if (balance != null) {
            if (balanceType == BALANCE_TYPE_CREDIT_BALANCE) {
                balance = balance.negate();
            }
            this.log.debug("Account balance : {}", (Object)balance);
            return balance;
        }
        return BigDecimal.ZERO;
    }
}

