/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Notification;
import com.axelor.apps.account.db.NotificationItem;
import com.axelor.apps.account.db.SubrogationRelease;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.NotificationService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.SubrogationReleaseService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Company;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;

public class NotificationServiceImpl
implements NotificationService {
    protected MoveService moveService;
    protected ReconcileService reconcileService;
    protected AccountConfigService accountConfigService;
    protected SubrogationReleaseService subrogationReleaseService;
    protected MoveRepository moveRepository;

    @Inject
    public NotificationServiceImpl(MoveService moveService, ReconcileService reconcileService, AccountConfigService accountConfigService, SubrogationReleaseService subrogationReleaseService, MoveRepository moveRepository) {
        this.moveService = moveService;
        this.reconcileService = reconcileService;
        this.accountConfigService = accountConfigService;
        this.subrogationReleaseService = subrogationReleaseService;
        this.moveRepository = moveRepository;
    }

    @Override
    public void populateNotificationItemList(Notification notification) {
        notification.clearNotificationItemList();
        Comparator byInvoiceDate = (i1, i2) -> i1.getInvoiceDate().compareTo(i2.getInvoiceDate());
        Comparator byDueDate = (i1, i2) -> i1.getDueDate().compareTo(i2.getDueDate());
        Comparator byInvoiceId = (i1, i2) -> i1.getInvoiceId().compareTo(i2.getInvoiceId());
        List<Object> invoiceList = new ArrayList();
        if (notification.getSubrogationRelease() != null) {
            invoiceList = notification.getSubrogationRelease().getInvoiceSet().stream().sorted(byInvoiceDate.thenComparing(byDueDate).thenComparing(byInvoiceId)).collect(Collectors.toList());
        }
        for (Invoice invoice : invoiceList) {
            if (invoice.getAmountRemaining().signum() <= 0) continue;
            notification.addNotificationItemListItem(this.createNotificationItem(invoice));
        }
    }

    protected NotificationItem createNotificationItem(Invoice invoice) {
        return new NotificationItem(invoice, invoice.getAmountRemaining());
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(Notification notification) throws AxelorException {
        for (NotificationItem notificationItem : notification.getNotificationItemList()) {
            this.createPaymentMove(notificationItem);
        }
        notification.setStatusSelect(2);
    }

    protected Journal getJournal(AccountConfig accountConfig) throws AxelorException {
        return this.accountConfigService.getAutoMiscOpeJournal(accountConfig);
    }

    protected Account getAccount(AccountConfig accountConfig, NotificationItem notificationItem) {
        Account account = accountConfig.getFactorCreditAccount();
        if (notificationItem.getTypeSelect() == 2) {
            account = accountConfig.getFactorDebitAccount();
        }
        return account;
    }

    @Transactional(rollbackOn={Exception.class})
    protected Move createPaymentMove(NotificationItem notificationItem) throws AxelorException {
        Notification notification = notificationItem.getNotification();
        Invoice invoice = notificationItem.getInvoice();
        Company company = invoice.getCompany();
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        Journal journal = this.getJournal(accountConfig);
        SubrogationRelease subrogationRelease = this.getSubrogationRelease(notificationItem);
        String origin = this.computeOrigin(subrogationRelease, invoice);
        BigDecimal amountPaid = notificationItem.getAmountPaid();
        if (amountPaid.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        Move paymentMove = this.moveService.getMoveCreateService().createMove(journal, company, company.getCurrency(), invoice.getPartner(), notification.getPaymentDate(), null, 2);
        Account account = this.getAccount(accountConfig, notificationItem);
        MoveLine debitMoveLine = this.moveService.getMoveLineService().createMoveLine(paymentMove, invoice.getPartner(), account, amountPaid, true, notification.getPaymentDate(), null, 1, origin, invoice.getInvoiceId());
        MoveLine creditMoveLine = this.moveService.getMoveLineService().createMoveLine(paymentMove, invoice.getPartner(), invoice.getPartnerAccount(), amountPaid, false, notification.getPaymentDate(), null, 2, origin, invoice.getInvoiceId());
        paymentMove.addMoveLineListItem(debitMoveLine);
        paymentMove.addMoveLineListItem(creditMoveLine);
        paymentMove = (Move)((Object)this.moveRepository.save((Model)((Object)paymentMove)));
        this.moveService.getMoveValidateService().validate(paymentMove);
        MoveLine invoiceMoveLine = this.findInvoiceAccountMoveLine(invoice);
        MoveLine subrogationReleaseMoveLine = this.findSubrogationReleaseAccountMoveLine(invoice);
        if (invoiceMoveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) == 1) {
            this.reconcileService.reconcile(invoiceMoveLine, creditMoveLine, true, true);
            if (subrogationReleaseMoveLine != null && notificationItem.getTypeSelect() == 1) {
                this.reconcileService.reconcile(debitMoveLine, subrogationReleaseMoveLine, true, false);
            }
        }
        notificationItem.setMove(paymentMove);
        if (subrogationRelease != null) {
            this.subrogationReleaseService.clear(subrogationRelease);
        }
        return paymentMove;
    }

    protected String computeOrigin(SubrogationRelease subrogationRelease, Invoice invoice) {
        return subrogationRelease != null ? subrogationRelease.getSequenceNumber() : I18n.get((String)"Payment notification") + " " + invoice.getInvoiceId();
    }

    protected SubrogationRelease getSubrogationRelease(NotificationItem notificationItem) {
        Invoice invoice = notificationItem.getInvoice();
        TypedQuery query = JPA.em().createQuery("SELECT self FROM SubrogationRelease self JOIN self.invoiceSet invoices WHERE self.statusSelect = :statusSelect AND invoices.id IN (:invoiceId)", SubrogationRelease.class);
        query.setParameter("statusSelect", (Object)3);
        query.setParameter("invoiceId", (Object)invoice.getId());
        List subrogationReleaseResultList = query.getResultList();
        if (subrogationReleaseResultList != null && !subrogationReleaseResultList.isEmpty()) {
            return (SubrogationRelease)((Object)subrogationReleaseResultList.get(0));
        }
        return null;
    }

    protected MoveLine findInvoiceAccountMoveLine(Invoice invoice) {
        for (MoveLine moveLine : invoice.getMove().getMoveLineList()) {
            if (!moveLine.getAccount().equals((Object)invoice.getPartnerAccount())) continue;
            return moveLine;
        }
        throw new NoSuchElementException();
    }

    protected MoveLine findSubrogationReleaseAccountMoveLine(Invoice invoice) throws AxelorException {
        if (invoice.getSubrogationReleaseMove() != null) {
            for (MoveLine moveLine : invoice.getSubrogationReleaseMove().getMoveLineList()) {
                if (moveLine.getCredit().compareTo(BigDecimal.ZERO) != 1) continue;
                return moveLine;
            }
        }
        return null;
    }
}

