/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleRepository;
import com.axelor.apps.account.service.PaymentScheduleLineService;
import com.axelor.apps.account.service.PaymentScheduleService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentScheduleServiceImpl
implements PaymentScheduleService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PaymentScheduleLineService paymentScheduleLineService;
    protected PaymentScheduleLineRepository paymentScheduleLineRepo;
    protected SequenceService sequenceService;
    protected PaymentScheduleRepository paymentScheduleRepo;
    protected PartnerService partnerService;
    protected AppAccountService appAccountService;

    @Inject
    public PaymentScheduleServiceImpl(AppAccountService appAccountService, PaymentScheduleLineService paymentScheduleLineService, PaymentScheduleLineRepository paymentScheduleLineRepo, SequenceService sequenceService, PaymentScheduleRepository paymentScheduleRepo, PartnerService partnerService) {
        this.paymentScheduleLineService = paymentScheduleLineService;
        this.paymentScheduleLineRepo = paymentScheduleLineRepo;
        this.sequenceService = sequenceService;
        this.paymentScheduleRepo = paymentScheduleRepo;
        this.partnerService = partnerService;
        this.appAccountService = appAccountService;
    }

    @Override
    public PaymentSchedule createPaymentSchedule(Partner partner, Company company, Set<Invoice> invoices, LocalDate startDate, int nbrTerm) throws AxelorException {
        Invoice invoice = null;
        PaymentSchedule paymentSchedule = this.createPaymentSchedule(partner, invoice, company, this.appAccountService.getTodayDate(), startDate, nbrTerm, this.partnerService.getDefaultBankDetails(partner), partner.getInPaymentMode());
        paymentSchedule.getInvoiceSet().addAll(invoices);
        return paymentSchedule;
    }

    @Override
    public PaymentSchedule createPaymentSchedule(Partner partner, Invoice invoice, Company company, LocalDate date, LocalDate startDate, int nbrTerm, BankDetails bankDetails, PaymentMode paymentMode) throws AxelorException {
        PaymentSchedule paymentSchedule = new PaymentSchedule();
        paymentSchedule.setCompany(company);
        paymentSchedule.setPaymentScheduleSeq(this.getPaymentScheduleSequence(company));
        paymentSchedule.setCreationDate(date);
        paymentSchedule.setStartDate(startDate);
        paymentSchedule.setNbrTerm(nbrTerm);
        paymentSchedule.setBankDetails(bankDetails);
        paymentSchedule.setPaymentMode(paymentMode);
        paymentSchedule.setPartner(partner);
        if (paymentSchedule.getInvoiceSet() == null) {
            paymentSchedule.setInvoiceSet(new HashSet<Invoice>());
        } else {
            paymentSchedule.getInvoiceSet().clear();
        }
        if (invoice != null) {
            paymentSchedule.addInvoiceSetItem(invoice);
            invoice.setPaymentSchedule(paymentSchedule);
        }
        return paymentSchedule;
    }

    @Override
    public String getPaymentScheduleSequence(Company company) throws AxelorException {
        String seq = this.sequenceService.getSequenceNumber("paymentSchedule", company);
        if (seq == null) {
            throw new AxelorException(4, "%s :\n" + I18n.get((String)"You must configure a timetable sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
        return seq;
    }

    @Override
    public BigDecimal getInvoiceTermTotal(PaymentSchedule paymentSchedule) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (paymentSchedule != null && paymentSchedule.getPaymentScheduleLineList() != null && !paymentSchedule.getPaymentScheduleLineList().isEmpty()) {
            for (PaymentScheduleLine paymentScheduleLine : paymentSchedule.getPaymentScheduleLineList()) {
                if (paymentScheduleLine.getInTaxAmount() == null) continue;
                this.log.debug("Somme TTC des lignes de l'\u00e9ch\u00e9ancier {} : total = {}, ajout = {}", new Object[]{paymentSchedule.getPaymentScheduleSeq(), totalAmount, paymentScheduleLine.getInTaxAmount()});
                totalAmount = totalAmount.add(paymentScheduleLine.getInTaxAmount());
            }
        }
        this.log.debug("Obtention de la somme TTC des lignes de l'\u00e9ch\u00e9ancier {} : {}", new Object[]{paymentSchedule.getPaymentScheduleSeq(), totalAmount});
        return totalAmount;
    }

    @Override
    @Transactional
    public void updatePaymentSchedule(PaymentSchedule paymentSchedule, BigDecimal inTaxTotal) {
        this.log.debug("Mise \u00e0 jour de l'\u00e9ch\u00e9ancier {} : {}", new Object[]{paymentSchedule.getPaymentScheduleSeq(), inTaxTotal});
        for (PaymentScheduleLine paymentScheduleLine : paymentSchedule.getPaymentScheduleLineList()) {
            if (paymentScheduleLine.getStatusSelect() != 2 || paymentScheduleLine.getRejectedOk().booleanValue()) continue;
            this.log.debug("Mise \u00e0 jour de la ligne {} ", (Object)paymentScheduleLine.getName());
            paymentScheduleLine.setInTaxAmount(inTaxTotal);
        }
        this.paymentScheduleRepo.save((Model)((Object)paymentSchedule));
    }

    @Override
    public PaymentSchedule createPaymentSchedule(Partner partner, Company company, LocalDate date, LocalDate firstTermDate, BigDecimal initialInTaxAmount, int nbrTerm, BankDetails bankDetails, PaymentMode paymentMode) throws AxelorException {
        Invoice invoice = null;
        PaymentSchedule paymentSchedule = this.createPaymentSchedule(partner, invoice, company, date, firstTermDate, nbrTerm, bankDetails, paymentMode);
        paymentSchedule.setPaymentScheduleLineList(new ArrayList<PaymentScheduleLine>());
        for (int term = 1; term < nbrTerm + 1; ++term) {
            paymentSchedule.getPaymentScheduleLineList().add(this.paymentScheduleLineService.createPaymentScheduleLine(paymentSchedule, initialInTaxAmount, term, firstTermDate.plusMonths(term - 1)));
        }
        return paymentSchedule;
    }

    @Override
    public List<MoveLine> getPaymentSchedulerMoveLineToPay(PaymentSchedule paymentSchedule) {
        this.log.debug("In getPaymentSchedulerMoveLineToPay ....");
        ArrayList<MoveLine> moveLines = new ArrayList<MoveLine>();
        for (Invoice invoice : paymentSchedule.getInvoiceSet()) {
            if (invoice.getCompanyInTaxTotalRemaining().compareTo(BigDecimal.ZERO) <= 0 || invoice.getMove() == null || invoice.getMove().getMoveLineList() == null) continue;
            for (MoveLine moveLine : invoice.getMove().getMoveLineList()) {
                if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0) continue;
                moveLines.add(moveLine);
            }
        }
        this.log.debug("End getPaymentSchedulerMoveLineToPay.");
        return moveLines;
    }

    @Override
    public void checkTotalLineAmount(PaymentSchedule paymentSchedule) throws AxelorException {
        BigDecimal total = this.getInvoiceTermTotal(paymentSchedule);
        if (total.compareTo(paymentSchedule.getInTaxAmount()) != 0) {
            throw new AxelorException((Model)((Object)paymentSchedule), 5, I18n.get((String)"The sum of line amounts (%s) must match the amount of the payment schedule (%s)."), new Object[]{total, paymentSchedule.getInTaxAmount()});
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validatePaymentSchedule(PaymentSchedule paymentSchedule) throws AxelorException {
        this.log.debug("Validation de l'\u00e9ch\u00e9ancier {}", (Object)paymentSchedule.getPaymentScheduleSeq());
        if (paymentSchedule.getPaymentScheduleLineList() == null || paymentSchedule.getPaymentScheduleLineList().isEmpty()) {
            throw new AxelorException((Model)((Object)paymentSchedule), 5, I18n.get((String)"%s : Error : You must, at first, create timetable lines for the timetable %s"), new Object[]{I18n.get((String)"Warning !"), paymentSchedule.getPaymentScheduleSeq()});
        }
        this.checkTotalLineAmount(paymentSchedule);
        for (PaymentScheduleLine paymentScheduleLine : paymentSchedule.getPaymentScheduleLineList()) {
            paymentScheduleLine.setStatusSelect(2);
        }
        this.updateInvoices(paymentSchedule);
        paymentSchedule.setStatusSelect(2);
    }

    @Override
    public void updateInvoices(PaymentSchedule paymentSchedule) {
        if (paymentSchedule.getInvoiceSet() != null) {
            List<MoveLine> moveLineInvoiceToPay = this.getPaymentSchedulerMoveLineToPay(paymentSchedule);
            for (MoveLine moveLineInvoice : moveLineInvoiceToPay) {
                moveLineInvoice.getMove().setIgnoreInDebtRecoveryOk(true);
                this.updateInvoice(moveLineInvoice.getMove().getInvoice(), paymentSchedule);
            }
        }
    }

    @Override
    public void updateInvoice(Invoice invoice, PaymentSchedule paymentSchedule) {
        invoice.setSchedulePaymentOk(true);
        invoice.setPaymentSchedule(paymentSchedule);
    }

    @Override
    public void cancelPaymentSchedule(PaymentSchedule paymentSchedule) {
        paymentSchedule.setStatusSelect(4);
        for (PaymentScheduleLine paymentScheduleLine : paymentSchedule.getPaymentScheduleLineList()) {
            if (paymentScheduleLine.getInTaxAmountPaid().compareTo(paymentScheduleLine.getInTaxAmount()) == 0) continue;
            paymentScheduleLine.setStatusSelect(4);
        }
        for (Invoice invoice : paymentSchedule.getInvoiceSet()) {
            invoice.setPaymentSchedule(null);
            invoice.setCanceledPaymentSchedule(paymentSchedule);
            invoice.setSchedulePaymentOk(false);
        }
    }

    @Override
    public boolean isLastSchedule(PaymentScheduleLine paymentScheduleLine) {
        if (paymentScheduleLine != null) {
            if (this.paymentScheduleLineRepo.all().filter("self.paymentSchedule = ?1 and self.scheduleDate > ?2 and self.statusSelect = ?3", new Object[]{paymentScheduleLine.getPaymentSchedule(), paymentScheduleLine.getScheduleDate(), 2}).fetchOne() == null) {
                this.log.debug("Derni\u00e8re \u00e9ch\u00e9ance");
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void closePaymentSchedule(PaymentSchedule paymentSchedule) throws AxelorException {
        this.log.debug("Cloture de l'\u00e9ch\u00e9ancier");
        for (PaymentScheduleLine paymentScheduleLine : paymentSchedule.getPaymentScheduleLineList()) {
            paymentScheduleLine.setStatusSelect(4);
        }
        paymentSchedule.setStatusSelect(3);
    }

    @Override
    public void closePaymentScheduleIfAllPaid(PaymentSchedule paymentSchedule) throws AxelorException {
        if (paymentSchedule.getPaymentScheduleLineList() == null) {
            return;
        }
        for (PaymentScheduleLine paymentScheduleLine : paymentSchedule.getPaymentScheduleLineList()) {
            if (paymentScheduleLine.getStatusSelect() >= 3) continue;
            return;
        }
        paymentSchedule.setStatusSelect(3);
    }

    @Override
    public LocalDate getMostOldDatePaymentScheduleLine(List<PaymentScheduleLine> paymentScheduleLineList) {
        LocalDate minPaymentScheduleLineDate = LocalDate.now();
        if (paymentScheduleLineList != null && !paymentScheduleLineList.isEmpty()) {
            for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLineList) {
                if (!minPaymentScheduleLineDate.isAfter(paymentScheduleLine.getScheduleDate())) continue;
                minPaymentScheduleLineDate = paymentScheduleLine.getScheduleDate();
            }
        } else {
            minPaymentScheduleLineDate = null;
        }
        return minPaymentScheduleLineDate;
    }

    @Override
    public LocalDate getMostRecentDatePaymentScheduleLine(List<PaymentScheduleLine> paymentScheduleLineList) {
        LocalDate minPaymentScheduleLineDate = LocalDate.now();
        if (paymentScheduleLineList != null && !paymentScheduleLineList.isEmpty()) {
            for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLineList) {
                if (!minPaymentScheduleLineDate.isBefore(paymentScheduleLine.getScheduleDate())) continue;
                minPaymentScheduleLineDate = paymentScheduleLine.getScheduleDate();
            }
        } else {
            minPaymentScheduleLineDate = null;
        }
        return minPaymentScheduleLineDate;
    }

    @Override
    @Transactional
    public void createPaymentScheduleLines(PaymentSchedule paymentSchedule) {
        this.initCollection(paymentSchedule);
        paymentSchedule.getPaymentScheduleLineList().addAll(this.paymentScheduleLineService.createPaymentScheduleLines(paymentSchedule));
        this.paymentScheduleRepo.save((Model)((Object)paymentSchedule));
    }

    @Override
    public void initCollection(PaymentSchedule paymentSchedule) {
        if (paymentSchedule.getPaymentScheduleLineList() == null) {
            paymentSchedule.setPaymentScheduleLineList(new ArrayList<PaymentScheduleLine>());
        } else {
            paymentSchedule.getPaymentScheduleLineList().clear();
        }
    }

    @Override
    @Transactional
    public void toCancelPaymentSchedule(PaymentSchedule paymentSchedule) {
        this.cancelPaymentSchedule(paymentSchedule);
        this.paymentScheduleRepo.save((Model)((Object)paymentSchedule));
    }

    @Override
    public BankDetails getBankDetails(PaymentSchedule paymentSchedule) throws AxelorException {
        BankDetails bankDetails = paymentSchedule.getBankDetails();
        if (bankDetails != null) {
            return bankDetails;
        }
        Partner partner = paymentSchedule.getPartner();
        Preconditions.checkNotNull((Object)((Object)partner));
        bankDetails = this.partnerService.getDefaultBankDetails(partner);
        if (bankDetails != null) {
            return bankDetails;
        }
        throw new AxelorException((Model)((Object)partner), 1, I18n.get((String)"Bank details are missing for partner %s."), new Object[]{partner.getName()});
    }

    @Override
    public int getNextScheduleLineSeq(PaymentSchedule paymentSchedule) {
        List paymentScheduleLines = (List)MoreObjects.firstNonNull(paymentSchedule.getPaymentScheduleLineList(), Collections.emptyList());
        int currentMaxSequenceNumber = paymentScheduleLines.stream().mapToInt(PaymentScheduleLine::getScheduleLineSeq).max().orElse(0);
        return currentMaxSequenceNumber + 1;
    }
}

