/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.ReconcileGroup;
import com.axelor.apps.account.service.ReconcileGroupSequenceService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;

public class ReconcileGroupSequenceServiceImpl
implements ReconcileGroupSequenceService {
    @Override
    public void fillCodeFromSequence(ReconcileGroup reconcileGroup) throws AxelorException {
        String exceptionMessage;
        String sequenceCode;
        if (reconcileGroup.getStatusSelect() == 2) {
            sequenceCode = "reconcileGroupFinal";
            exceptionMessage = "There is no configured sequence for final reconcile group";
        } else {
            sequenceCode = "reconcileGroupDraft";
            exceptionMessage = "There is no configured sequence for temporary reconcile group";
        }
        String code = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber(sequenceCode, reconcileGroup.getCompany());
        if (code == null) {
            throw new AxelorException(4, I18n.get((String)exceptionMessage), new Object[]{reconcileGroup});
        }
        reconcileGroup.setCode(code);
    }
}

