/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.ReconcileGroup;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.ReconcileGroupRepository;
import com.axelor.apps.account.db.repo.ReconcileRepository;
import com.axelor.apps.account.service.ReconcileGroupSequenceService;
import com.axelor.apps.account.service.ReconcileGroupService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ReconcileGroupServiceImpl
implements ReconcileGroupService {
    protected ReconcileGroupRepository reconcileGroupRepository;
    protected ReconcileRepository reconcileRepository;
    protected MoveLineRepository moveLineRepository;
    protected ReconcileService reconcileService;
    protected AppBaseService appBaseService;
    protected ReconcileGroupSequenceService reconcileGroupSequenceService;

    @Inject
    public ReconcileGroupServiceImpl(ReconcileGroupRepository reconcileGroupRepository, ReconcileRepository reconcileRepository, MoveLineRepository moveLineRepository, ReconcileService reconcileService, AppBaseService appBaseService, ReconcileGroupSequenceService reconcileGroupSequenceService) {
        this.reconcileGroupRepository = reconcileGroupRepository;
        this.reconcileRepository = reconcileRepository;
        this.moveLineRepository = moveLineRepository;
        this.reconcileService = reconcileService;
        this.appBaseService = appBaseService;
        this.reconcileGroupSequenceService = reconcileGroupSequenceService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(ReconcileGroup reconcileGroup, List<Reconcile> reconcileList) throws AxelorException {
        if (CollectionUtils.isEmpty(reconcileList)) {
            throw new AxelorException(5, I18n.get((String)"The reconcile group cannot be validated since there is no lines."), new Object[]{reconcileGroup});
        }
        reconcileGroup.setStatusSelect(2);
        reconcileGroup.setDateOfLettering(this.appBaseService.getTodayDate());
        this.reconcileGroupSequenceService.fillCodeFromSequence(reconcileGroup);
    }

    @Override
    public boolean isBalanced(List<Reconcile> reconcileList) {
        List debitMoveLineList = reconcileList.stream().map(Reconcile::getDebitMoveLine).distinct().collect(Collectors.toList());
        List creditMoveLineList = reconcileList.stream().map(Reconcile::getCreditMoveLine).distinct().collect(Collectors.toList());
        List accountList = debitMoveLineList.stream().map(MoveLine::getAccount).distinct().collect(Collectors.toList());
        accountList.addAll(creditMoveLineList.stream().map(MoveLine::getAccount).distinct().collect(Collectors.toList()));
        for (Account account : accountList) {
            BigDecimal totalCredit;
            BigDecimal totalDebit = debitMoveLineList.stream().filter(moveLine -> moveLine.getAccount().equals((Object)account)).map(MoveLine::getDebit).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (totalDebit.compareTo(totalCredit = creditMoveLineList.stream().filter(moveLine -> moveLine.getAccount().equals((Object)account)).map(MoveLine::getCredit).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReconcileGroup findOrCreateGroup(Reconcile reconcile) {
        return this.findOrMergeGroup(reconcile).orElseGet(() -> this.createReconcileGroup(reconcile.getCompany()));
    }

    @Override
    public Optional<ReconcileGroup> findOrMergeGroup(Reconcile reconcile) {
        MoveLine debitMoveLine = reconcile.getDebitMoveLine();
        MoveLine creditMoveLine = reconcile.getCreditMoveLine();
        List<Object> otherReconcileGroupList = new ArrayList<ReconcileGroup>();
        if (debitMoveLine.getReconcileGroup() != null) {
            otherReconcileGroupList.add((Object)debitMoveLine.getReconcileGroup());
        }
        if (creditMoveLine.getReconcileGroup() != null) {
            otherReconcileGroupList.add((Object)creditMoveLine.getReconcileGroup());
        }
        if ((otherReconcileGroupList = otherReconcileGroupList.stream().distinct().collect(Collectors.toList())).isEmpty()) {
            return Optional.empty();
        }
        if (otherReconcileGroupList.size() == 1) {
            return Optional.of(otherReconcileGroupList.get(0));
        }
        return Optional.of(this.mergeReconcileGroups(otherReconcileGroupList));
    }

    @Override
    @Transactional
    public ReconcileGroup mergeReconcileGroups(List<ReconcileGroup> reconcileGroupList) {
        Company company = reconcileGroupList.get(0).getCompany();
        ReconcileGroup reconcileGroup = this.createReconcileGroup(company);
        List reconcileList = this.reconcileRepository.all().filter("self.reconcileGroup.id IN (:reconcileGroupIds)").bind("reconcileGroupIds", reconcileGroupList.stream().map(ReconcileGroup::getId).collect(Collectors.toList())).fetch();
        reconcileList.forEach(reconcile -> this.addToReconcileGroup(reconcileGroup, (Reconcile)((Object)reconcile)));
        for (ReconcileGroup toDeleteReconcileGroup : reconcileGroupList) {
            this.reconcileGroupRepository.remove((Model)((Object)toDeleteReconcileGroup));
        }
        return (ReconcileGroup)((Object)this.reconcileGroupRepository.save((Model)((Object)reconcileGroup)));
    }

    @Override
    @Transactional
    public ReconcileGroup createReconcileGroup(Company company) {
        ReconcileGroup reconcileGroup = new ReconcileGroup();
        reconcileGroup.setCompany(company);
        return (ReconcileGroup)((Object)this.reconcileGroupRepository.save((Model)((Object)reconcileGroup)));
    }

    @Override
    public void addAndValidate(ReconcileGroup reconcileGroup, Reconcile reconcile) throws AxelorException {
        List<Reconcile> reconcileList = this.getReconcileList(reconcileGroup);
        reconcileList.add(reconcile);
        this.addToReconcileGroup(reconcileGroup, reconcile);
        if (this.isBalanced(reconcileList)) {
            this.validate(reconcileGroup, reconcileList);
        }
    }

    @Override
    public void addToReconcileGroup(ReconcileGroup reconcileGroup, Reconcile reconcile) {
        reconcile.setReconcileGroup(reconcileGroup);
        reconcile.getDebitMoveLine().setReconcileGroup(reconcileGroup);
        reconcile.getCreditMoveLine().setReconcileGroup(reconcileGroup);
    }

    @Override
    public void remove(Reconcile reconcile) throws AxelorException {
        ReconcileGroup reconcileGroup = reconcile.getReconcileGroup();
        List moveLineToRemoveList = this.moveLineRepository.findByReconcileGroup(reconcileGroup).fetch();
        moveLineToRemoveList.forEach(moveLine -> moveLine.setReconcileGroup(null));
        List<Reconcile> reconcileList = this.getReconcileList(reconcileGroup);
        reconcileList.stream().map(Reconcile::getDebitMoveLine).forEach(moveLine -> moveLine.setReconcileGroup(reconcileGroup));
        reconcileList.stream().map(Reconcile::getCreditMoveLine).forEach(moveLine -> moveLine.setReconcileGroup(reconcileGroup));
        this.updateStatus(reconcileGroup);
    }

    @Override
    public void updateStatus(ReconcileGroup reconcileGroup) throws AxelorException {
        List<Reconcile> reconcileList = this.getReconcileList(reconcileGroup);
        int status = reconcileGroup.getStatusSelect();
        if (CollectionUtils.isNotEmpty(reconcileList) && this.isBalanced(reconcileList) && status == 1) {
            this.validate(reconcileGroup, reconcileList);
        } else if (status == 2) {
            if (CollectionUtils.isEmpty(reconcileList)) {
                reconcileGroup.setStatusSelect(3);
                reconcileGroup.setUnletteringDate(this.appBaseService.getTodayDate());
                this.reconcileGroupRepository.save((Model)((Object)reconcileGroup));
            } else {
                reconcileGroup.setStatusSelect(1);
                this.reconcileGroupSequenceService.fillCodeFromSequence(reconcileGroup);
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void unletter(ReconcileGroup reconcileGroup) throws AxelorException {
        List<Reconcile> reconcileList = this.getReconcileList(reconcileGroup);
        for (Reconcile reconcile : reconcileList) {
            this.reconcileService.unreconcile(reconcile);
        }
        reconcileGroup.setUnletteringDate(this.appBaseService.getTodayDate());
        reconcileGroup.setStatusSelect(3);
        this.reconcileGroupRepository.save((Model)((Object)reconcileGroup));
    }

    protected List<Reconcile> getReconcileList(ReconcileGroup reconcileGroup) {
        return this.reconcileRepository.all().filter("self.reconcileGroup.id = :reconcileGroupId AND self.statusSelect = :confirmed").bind("reconcileGroupId", (Object)reconcileGroup.getId()).bind("confirmed", (Object)2).fetch();
    }
}

