/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;

public class ReconcileSequenceService {
    protected SequenceService sequenceService;

    @Inject
    public ReconcileSequenceService(SequenceService sequenceService) {
        this.sequenceService = sequenceService;
    }

    public void setSequence(Reconcile reconcile) throws AxelorException {
        reconcile.setReconcileSeq(this.getSequence(reconcile));
    }

    protected String getSequence(Reconcile reconcile) throws AxelorException {
        SequenceService sequenceService = (SequenceService)Beans.get(SequenceService.class);
        String seq = sequenceService.getSequenceNumber("reconcile", reconcile.getDebitMoveLine().getMove().getCompany());
        if (seq == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Error : You must configure a reconciliation sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), reconcile.getCompany().getName()});
        }
        return seq;
    }

    public void setDraftSequence(Reconcile reconcile) throws AxelorException {
        if (reconcile.getId() != null && Strings.isNullOrEmpty((String)reconcile.getReconcileSeq()) && reconcile.getStatusSelect() == 1) {
            reconcile.setReconcileSeq(this.sequenceService.getDraftSequenceNumber((Model)((Object)reconcile)));
        }
    }
}

