/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.ReconcileGroup;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.ReconcileRepository;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.AccountingService;
import com.axelor.apps.account.service.ReconcileGroupService;
import com.axelor.apps.account.service.ReconcileSequenceService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveAdjustementService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCancelService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconcileServiceImpl
implements ReconcileService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveToolService moveToolService;
    protected AccountCustomerService accountCustomerService;
    protected AccountConfigService accountConfigService;
    protected ReconcileRepository reconcileRepository;
    protected MoveAdjustementService moveAdjustementService;
    protected ReconcileSequenceService reconcileSequenceService;
    protected InvoicePaymentCreateService invoicePaymentCreateService;
    protected InvoicePaymentCancelService invoicePaymentCancelService;
    protected MoveLineService moveLineService;

    @Inject
    public ReconcileServiceImpl(MoveToolService moveToolService, AccountCustomerService accountCustomerService, AccountConfigService accountConfigService, ReconcileRepository reconcileRepository, MoveAdjustementService moveAdjustementService, ReconcileSequenceService reconcileSequenceService, InvoicePaymentCancelService invoicePaymentCancelService, InvoicePaymentCreateService invoicePaymentCreateService, MoveLineService moveLineService) {
        this.moveToolService = moveToolService;
        this.accountCustomerService = accountCustomerService;
        this.accountConfigService = accountConfigService;
        this.reconcileRepository = reconcileRepository;
        this.moveAdjustementService = moveAdjustementService;
        this.reconcileSequenceService = reconcileSequenceService;
        this.invoicePaymentCancelService = invoicePaymentCancelService;
        this.invoicePaymentCreateService = invoicePaymentCreateService;
        this.moveLineService = moveLineService;
    }

    @Override
    @Transactional
    public Reconcile createReconcile(MoveLine debitMoveLine, MoveLine creditMoveLine, BigDecimal amount, boolean canBeZeroBalanceOk) {
        if (ReconcileService.isReconcilable(debitMoveLine, creditMoveLine) && amount.compareTo(BigDecimal.ZERO) > 0) {
            this.log.debug("Create Reconcile (Company : {}, Debit MoveLine : {}, Credit MoveLine : {}, Amount : {}, Can be zero balance ? {} )", new Object[]{debitMoveLine.getMove().getCompany(), debitMoveLine.getName(), creditMoveLine.getName(), amount, canBeZeroBalanceOk});
            Reconcile reconcile = new Reconcile(debitMoveLine.getMove().getCompany(), amount.setScale(2, RoundingMode.HALF_EVEN), debitMoveLine, creditMoveLine, 1, canBeZeroBalanceOk);
            if (!this.moveToolService.isDebitMoveLine(debitMoveLine)) {
                reconcile.setDebitMoveLine(creditMoveLine);
                reconcile.setCreditMoveLine(debitMoveLine);
            }
            return (Reconcile)((Object)this.reconcileRepository.save((Model)((Object)reconcile)));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Reconcile confirmReconcile(Reconcile reconcile, boolean updateInvoicePayments) throws AxelorException {
        this.reconcilePreconditions(reconcile);
        MoveLine debitMoveLine = reconcile.getDebitMoveLine();
        MoveLine creditMoveLine = reconcile.getCreditMoveLine();
        creditMoveLine.setAmountPaid(creditMoveLine.getAmountPaid().add(reconcile.getAmount()));
        debitMoveLine.setAmountPaid(debitMoveLine.getAmountPaid().add(reconcile.getAmount()));
        reconcile = (Reconcile)((Object)this.reconcileRepository.save((Model)((Object)reconcile)));
        reconcile.setStatusSelect(2);
        if (reconcile.getCanBeZeroBalanceOk().booleanValue()) {
            this.canBeZeroBalance(reconcile);
        }
        reconcile.setReconciliationDate(LocalDate.now());
        this.reconcileSequenceService.setSequence(reconcile);
        this.updatePartnerAccountingSituation(reconcile);
        this.updateInvoiceCompanyInTaxTotalRemaining(reconcile);
        this.udpatePaymentTax(reconcile);
        if (updateInvoicePayments) {
            this.updateInvoicePayments(reconcile);
        }
        this.addToReconcileGroup(reconcile);
        return (Reconcile)((Object)this.reconcileRepository.save((Model)((Object)reconcile)));
    }

    @Override
    public void addToReconcileGroup(Reconcile reconcile) throws AxelorException {
        ReconcileGroupService reconcileGroupService = (ReconcileGroupService)Beans.get(ReconcileGroupService.class);
        ReconcileGroup reconcileGroup = reconcileGroupService.findOrCreateGroup(reconcile);
        reconcileGroupService.addAndValidate(reconcileGroup, reconcile);
    }

    @Override
    public void reconcilePreconditions(Reconcile reconcile) throws AxelorException {
        MoveLine debitMoveLine = reconcile.getDebitMoveLine();
        MoveLine creditMoveLine = reconcile.getCreditMoveLine();
        if (debitMoveLine == null || creditMoveLine == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Reconciliation : You must fill concerned moves lines."), new Object[]{I18n.get((String)"Warning !")});
        }
        Company reconcileCompany = reconcile.getCompany();
        Company debitMoveLineCompany = debitMoveLine.getMove().getCompany();
        Company creditMoveLineCompany = creditMoveLine.getMove().getCompany();
        if (!debitMoveLineCompany.equals((Object)reconcileCompany) && !creditMoveLineCompany.equals((Object)reconcileCompany)) {
            throw new AxelorException(String.format(I18n.get((String)"Reconciliation : Selected moves lines must concern the same company. Reconcile : %s company \n Debit move line : %s company \n Credit move line : %s company"), new Object[]{I18n.get((String)"Warning !"), debitMoveLineCompany, creditMoveLineCompany, reconcileCompany}), 4, new Object[0]);
        }
        if (!creditMoveLine.getAccount().equals((Object)debitMoveLine.getAccount())) {
            this.log.debug("Compte ligne de credit : {} , Compte ligne de debit : {}", (Object)creditMoveLine.getAccount(), (Object)debitMoveLine.getAccount());
            if (!debitMoveLine.getAccount().getCompatibleAccountSet().contains((Object)creditMoveLine.getAccount())) {
                throw new AxelorException(4, I18n.get((String)"%s : Reconciliation : Move line accounts are not compatible."), new Object[]{I18n.get((String)"Warning !")});
            }
        }
        if (reconcile.getAmount() == null || reconcile.getAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new AxelorException(5, I18n.get((String)"%s : Reconciliation %s: Reconciliated amount must be different than zero. (Debit %s account %s - Credit %s account %s)"), new Object[]{I18n.get((String)"Warning !"), reconcile.getReconcileSeq(), debitMoveLine.getName(), debitMoveLine.getAccount().getLabel(), creditMoveLine.getName(), creditMoveLine.getAccount().getLabel()});
        }
        if (reconcile.getAmount().compareTo(creditMoveLine.getCredit().subtract(creditMoveLine.getAmountPaid())) > 0 || reconcile.getAmount().compareTo(debitMoveLine.getDebit().subtract(debitMoveLine.getAmountPaid())) > 0) {
            throw new AxelorException(5, I18n.get((String)"%s : Reconciliation %s: Reconciliated amount (%s) must be lower or equal to remaining amount to reconciliate from moves lines.") + " " + I18n.get((String)"(Debit %s account %s amount %s - Credit %s account %s amount %s)"), new Object[]{I18n.get((String)"Warning !"), reconcile.getReconcileSeq(), reconcile.getAmount(), debitMoveLine.getName(), debitMoveLine.getAccount().getLabel(), debitMoveLine.getDebit().subtract(debitMoveLine.getAmountPaid()), creditMoveLine.getName(), creditMoveLine.getAccount().getLabel(), creditMoveLine.getCredit().subtract(creditMoveLine.getAmountPaid())});
        }
    }

    @Override
    public void updatePartnerAccountingSituation(Reconcile reconcile) throws AxelorException {
        List<Partner> partnerList = this.getPartners(reconcile);
        if (partnerList != null && !partnerList.isEmpty()) {
            Company company = reconcile.getDebitMoveLine().getMove().getCompany();
            if (AccountingService.getUpdateCustomerAccount()) {
                this.accountCustomerService.updatePartnerAccountingSituation(partnerList, company, true, true, false);
            } else {
                this.accountCustomerService.flagPartners(partnerList, company);
            }
        }
    }

    @Override
    public List<Partner> getPartners(Reconcile reconcile) {
        ArrayList partnerList = Lists.newArrayList();
        Partner debitPartner = reconcile.getDebitMoveLine().getPartner();
        Partner creditPartner = reconcile.getCreditMoveLine().getPartner();
        if (debitPartner != null && creditPartner != null && debitPartner.equals((Object)creditPartner)) {
            partnerList.add(debitPartner);
        } else if (debitPartner != null) {
            partnerList.add(debitPartner);
        } else if (creditPartner != null) {
            partnerList.add(creditPartner);
        }
        return partnerList;
    }

    public void updateInvoiceCompanyInTaxTotalRemaining(Reconcile reconcile) throws AxelorException {
        Invoice debitInvoice = reconcile.getDebitMoveLine().getMove().getInvoice();
        Invoice creditInvoice = reconcile.getCreditMoveLine().getMove().getInvoice();
        if (debitInvoice != null) {
            debitInvoice.setCompanyInTaxTotalRemaining(this.moveToolService.getInTaxTotalRemaining(debitInvoice));
        }
        if (creditInvoice != null) {
            creditInvoice.setCompanyInTaxTotalRemaining(this.moveToolService.getInTaxTotalRemaining(creditInvoice));
        }
    }

    public void updateInvoicePayments(Reconcile reconcile) throws AxelorException {
        MoveLine debitMoveLine = reconcile.getDebitMoveLine();
        MoveLine creditMoveLine = reconcile.getCreditMoveLine();
        Move debitMove = debitMoveLine.getMove();
        Move creditMove = creditMoveLine.getMove();
        Invoice debitInvoice = debitMove.getInvoice();
        Invoice creditInvoice = creditMove.getInvoice();
        BigDecimal amount = reconcile.getAmount();
        if (debitInvoice != null && debitMoveLine.getAccount().getUseForPartnerBalance().booleanValue() && creditMoveLine.getAccount().getUseForPartnerBalance().booleanValue()) {
            InvoicePayment debitInvoicePayment = this.invoicePaymentCreateService.createInvoicePayment(debitInvoice, amount, creditMove);
            debitInvoicePayment.setReconcile(reconcile);
        }
        if (creditInvoice != null && debitMoveLine.getAccount().getUseForPartnerBalance().booleanValue() && creditMoveLine.getAccount().getUseForPartnerBalance().booleanValue()) {
            InvoicePayment creditInvoicePayment = this.invoicePaymentCreateService.createInvoicePayment(creditInvoice, amount, debitMove);
            creditInvoicePayment.setReconcile(reconcile);
        }
    }

    protected void udpatePaymentTax(Reconcile reconcile) throws AxelorException {
        Move debitMove = reconcile.getDebitMoveLine().getMove();
        Move creditMove = reconcile.getCreditMoveLine().getMove();
        Invoice debitInvoice = debitMove.getInvoice();
        Invoice creditInvoice = creditMove.getInvoice();
        if (debitInvoice != null && creditInvoice == null) {
            this.moveLineService.generateTaxPaymentMoveLineList(reconcile.getCreditMoveLine(), debitInvoice, reconcile);
        }
        if (creditInvoice != null && debitInvoice == null) {
            this.moveLineService.generateTaxPaymentMoveLineList(reconcile.getDebitMoveLine(), creditInvoice, reconcile);
        }
    }

    @Override
    public Reconcile reconcile(MoveLine debitMoveLine, MoveLine creditMoveLine, boolean canBeZeroBalanceOk, boolean updateInvoicePayments) throws AxelorException {
        BigDecimal amount = debitMoveLine.getAmountRemaining().min(creditMoveLine.getAmountRemaining());
        Reconcile reconcile = this.createReconcile(debitMoveLine, creditMoveLine, amount, canBeZeroBalanceOk);
        if (reconcile != null) {
            this.confirmReconcile(reconcile, updateInvoicePayments);
            return reconcile;
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void unreconcile(Reconcile reconcile) throws AxelorException {
        this.log.debug("unreconcile : reconcile : {}", (Object)reconcile);
        MoveLine debitMoveLine = reconcile.getDebitMoveLine();
        MoveLine creditMoveLine = reconcile.getCreditMoveLine();
        reconcile.setStatusSelect(3);
        creditMoveLine.setAmountPaid(creditMoveLine.getAmountPaid().subtract(reconcile.getAmount()));
        debitMoveLine.setAmountPaid(debitMoveLine.getAmountPaid().subtract(reconcile.getAmount()));
        this.reconcileRepository.save((Model)((Object)reconcile));
        this.updatePartnerAccountingSituation(reconcile);
        this.updateInvoiceCompanyInTaxTotalRemaining(reconcile);
        this.updateInvoicePaymentsCanceled(reconcile);
        this.reverseTaxPaymentMoveLines(reconcile);
        ((ReconcileGroupService)Beans.get(ReconcileGroupService.class)).remove(reconcile);
    }

    protected void reverseTaxPaymentMoveLines(Reconcile reconcile) throws AxelorException {
        Move debitMove = reconcile.getDebitMoveLine().getMove();
        Move creditMove = reconcile.getCreditMoveLine().getMove();
        Invoice debitInvoice = debitMove.getInvoice();
        Invoice creditInvoice = creditMove.getInvoice();
        if (debitInvoice == null) {
            this.moveLineService.reverseTaxPaymentMoveLines(reconcile.getDebitMoveLine(), reconcile);
        }
        if (creditInvoice == null) {
            this.moveLineService.reverseTaxPaymentMoveLines(reconcile.getCreditMoveLine(), reconcile);
        }
    }

    public void updateInvoicePaymentsCanceled(Reconcile reconcile) throws AxelorException {
        this.log.debug("updateInvoicePaymentsCanceled : reconcile : {}", (Object)reconcile);
        List invoicePaymentList = ((InvoicePaymentRepository)((Object)Beans.get(InvoicePaymentRepository.class))).all().filter("self.reconcile = ?1", new Object[]{reconcile}).fetch();
        for (InvoicePayment invoicePayment : invoicePaymentList) {
            this.invoicePaymentCancelService.updateCancelStatus(invoicePayment);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void canBeZeroBalance(Reconcile reconcile) throws AxelorException {
        MoveLine debitMoveLine = reconcile.getDebitMoveLine();
        BigDecimal debitAmountRemaining = debitMoveLine.getAmountRemaining();
        this.log.debug("Montant \u00e0 payer / \u00e0 lettrer au d\u00e9bit : {}", (Object)debitAmountRemaining);
        if (debitAmountRemaining.compareTo(BigDecimal.ZERO) > 0) {
            Company company = reconcile.getDebitMoveLine().getMove().getCompany();
            AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
            if (debitAmountRemaining.plus().compareTo(accountConfig.getThresholdDistanceFromRegulation()) < 0 || reconcile.getMustBeZeroBalanceOk().booleanValue()) {
                this.log.debug("Seuil respect\u00e9");
                MoveLine creditAdjustMoveLine = this.moveAdjustementService.createAdjustmentCreditMove(debitMoveLine);
                Reconcile newReconcile = this.createReconcile(debitMoveLine, creditAdjustMoveLine, debitAmountRemaining, false);
                if (newReconcile != null) {
                    this.confirmReconcile(newReconcile, true);
                    this.reconcileRepository.save((Model)((Object)newReconcile));
                }
            }
        }
        reconcile.setCanBeZeroBalanceOk(false);
        this.log.debug("Fin de la gestion des \u00e9carts de r\u00e8glement");
    }

    @Override
    public void balanceCredit(MoveLine creditMoveLine) throws AxelorException {
        if (creditMoveLine != null) {
            BigDecimal creditAmountRemaining = creditMoveLine.getAmountRemaining();
            this.log.debug("Montant \u00e0 payer / \u00e0 lettrer au cr\u00e9dit : {}", (Object)creditAmountRemaining);
            if (creditAmountRemaining.compareTo(BigDecimal.ZERO) > 0) {
                AccountConfig accountConfig = this.accountConfigService.getAccountConfig(creditMoveLine.getMove().getCompany());
                if (creditAmountRemaining.plus().compareTo(accountConfig.getThresholdDistanceFromRegulation()) < 0) {
                    this.log.debug("Seuil respect\u00e9");
                    MoveLine debitAdjustmentMoveLine = this.moveAdjustementService.createAdjustmentCreditMove(creditMoveLine);
                    Reconcile newReconcile = this.createReconcile(debitAdjustmentMoveLine, creditMoveLine, creditAmountRemaining, false);
                    if (newReconcile != null) {
                        this.confirmReconcile(newReconcile, true);
                        this.reconcileRepository.save((Model)((Object)newReconcile));
                    }
                }
            }
        }
    }

    @Override
    public List<Reconcile> getReconciles(MoveLine moveLine) {
        List<Reconcile> debitReconcileList = moveLine.getDebitReconcileList();
        List<Reconcile> creditReconcileList = moveLine.getCreditReconcileList();
        if (this.moveToolService.isDebitMoveLine(moveLine)) {
            return debitReconcileList;
        }
        if (debitReconcileList != null && !creditReconcileList.isEmpty()) {
            return creditReconcileList;
        }
        return Lists.newArrayList();
    }
}

