/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.db.repo.ReimbursementRepository;
import com.axelor.apps.account.service.RejectImportService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReimbursementImportService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveService moveService;
    protected MoveRepository moveRepo;
    protected MoveLineService moveLineService;
    protected RejectImportService rejectImportService;
    protected AccountConfigService accountConfigService;
    protected ReimbursementRepository reimbursementRepo;

    @Inject
    public ReimbursementImportService(MoveService moveService, MoveRepository moveRepo, MoveLineService moveLineService, RejectImportService rejectImportService, AccountConfigService accountConfigService, ReimbursementRepository reimbursementRepo) {
        this.moveService = moveService;
        this.moveRepo = moveRepo;
        this.moveLineService = moveLineService;
        this.rejectImportService = rejectImportService;
        this.accountConfigService = accountConfigService;
        this.reimbursementRepo = reimbursementRepo;
    }

    @Transactional(rollbackOn={Exception.class})
    public void runReimbursementImport(Company company) throws AxelorException, IOException {
        this.testCompanyField(company);
        AccountConfig accountConfig = company.getAccountConfig();
        this.createReimbursementRejectMove(this.rejectImportService.getCFONBFile(accountConfig.getReimbursementImportFolderPathCFONB(), accountConfig.getTempReimbImportFolderPathCFONB(), company, 0), company);
    }

    public void createReimbursementRejectMove(List<String[]> rejectList, Company company) throws AxelorException {
        int seq = 1;
        if (rejectList != null && !rejectList.isEmpty()) {
            LocalDate rejectDate = this.rejectImportService.createRejectDate(rejectList.get(0)[0]);
            Move move = this.createMoveReject(company, rejectDate);
            for (String[] reject : rejectList) {
                this.createReimbursementRejectMoveLine(reject, company, seq, move, rejectDate);
                ++seq;
            }
            if (move != null) {
                MoveLine debitMoveLine = this.moveLineService.createMoveLine(move, null, company.getAccountConfig().getReimbursementAccount(), this.getTotalAmount(move), true, rejectDate, seq, null, null);
                move.getMoveLineList().add(debitMoveLine);
                this.validateMove(move);
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public Reimbursement createReimbursementRejectMoveLine(String[] reject, Company company, int seq, Move move, LocalDate rejectDate) throws AxelorException {
        String refReject = reject[1];
        InterbankCodeLine causeReject = this.rejectImportService.getInterbankCodeLine(reject[3], 0);
        MoveLineRepository moveLineRepo = (MoveLineRepository)((Object)Beans.get(MoveLineRepository.class));
        Reimbursement reimbursement = (Reimbursement)((Object)this.reimbursementRepo.all().filter("UPPER(self.ref) = ?1 AND self.company = ?2", new Object[]{refReject, company}).fetchOne());
        if (reimbursement == null) {
            throw new AxelorException(5, I18n.get((String)"No reimbursement found for the ref %s and the company %s."), new Object[]{refReject, company.getName()});
        }
        Partner partner = reimbursement.getPartner();
        BigDecimal amount = reimbursement.getAmountReimbursed();
        MoveLine creditMoveLine = this.moveLineService.createMoveLine(move, partner, company.getAccountConfig().getCustomerAccount(), amount, false, rejectDate, seq, refReject, null);
        move.getMoveLineList().add(creditMoveLine);
        moveLineRepo.save((Model)((Object)creditMoveLine));
        this.moveRepo.save((Model)((Object)move));
        creditMoveLine.setInterbankCodeLine(causeReject);
        reimbursement.setRejectedOk(true);
        reimbursement.setRejectDate(rejectDate);
        reimbursement.setRejectMoveLine(creditMoveLine);
        reimbursement.setInterbankCodeLine(causeReject);
        this.reimbursementRepo.save((Model)((Object)reimbursement));
        return reimbursement;
    }

    @Transactional(rollbackOn={Exception.class})
    public Move createMoveReject(Company company, LocalDate date) throws AxelorException {
        return (Move)((Object)this.moveRepo.save((Model)((Object)this.moveService.getMoveCreateService().createMove(company.getAccountConfig().getRejectJournal(), company, null, null, date, null, 4))));
    }

    public BigDecimal getTotalAmount(Move move) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (MoveLine moveLine : move.getMoveLineList()) {
            totalAmount = totalAmount.add(moveLine.getCredit());
        }
        return totalAmount;
    }

    @Transactional(rollbackOn={Exception.class})
    public MoveLine createOppositeRejectMoveLine(Move move, int seq, LocalDate rejectDate) throws AxelorException {
        MoveLine debitMoveLine = this.moveLineService.createMoveLine(move, null, move.getCompany().getAccountConfig().getReimbursementAccount(), this.getTotalAmount(move), true, rejectDate, seq, null, null);
        move.getMoveLineList().add(debitMoveLine);
        this.moveRepo.save((Model)((Object)move));
        return debitMoveLine;
    }

    @Transactional(rollbackOn={Exception.class})
    public void validateMove(Move move) throws AxelorException {
        this.moveService.getMoveValidateService().validate(move);
        this.moveRepo.save((Model)((Object)move));
    }

    @Transactional
    public void deleteMove(Move move) {
        this.moveRepo.remove((Model)((Object)move));
    }

    public void testCompanyField(Company company) throws AxelorException {
        this.log.debug("Test de la soci\u00e9t\u00e9 {}", (Object)company.getName());
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        this.accountConfigService.getReimbursementAccount(accountConfig);
        this.accountConfigService.getRejectJournal(accountConfig);
        this.accountConfigService.getReimbursementImportFolderPathCFONB(accountConfig);
        this.accountConfigService.getTempReimbImportFolderPathCFONB(accountConfig);
    }
}

