/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class ReimbursementService {
    protected PartnerRepository partnerRepository;
    protected PartnerService partnerService;

    @Inject
    public ReimbursementService(PartnerRepository partnerRepository, PartnerService partnerService) {
        this.partnerRepository = partnerRepository;
        this.partnerService = partnerService;
    }

    @Transactional
    public void updatePartnerCurrentRIB(Reimbursement reimbursement) {
        BankDetails bankDetails = reimbursement.getBankDetails();
        Partner partner = reimbursement.getPartner();
        BankDetails defaultBankDetails = this.partnerService.getDefaultBankDetails(partner);
        if (bankDetails != null && partner != null && !bankDetails.equals((Object)defaultBankDetails)) {
            defaultBankDetails.setIsDefault(false);
            bankDetails.setIsDefault(true);
            partner.addBankDetailsListItem(bankDetails);
            this.partnerRepository.save((Model)((Object)partner));
        }
    }
}

