/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.SubrogationRelease;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.SubrogationReleaseService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class SubrogationReleaseServiceImpl
implements SubrogationReleaseService {
    protected AppBaseService appBaseService;
    protected InvoiceRepository invoiceRepository;

    @Inject
    public SubrogationReleaseServiceImpl(AppBaseService appBaseService, InvoiceRepository invoiceRepository) {
        this.appBaseService = appBaseService;
        this.invoiceRepository = invoiceRepository;
    }

    @Override
    public List<Invoice> retrieveInvoices(Company company) {
        Query query = this.invoiceRepository.all().filter("self.company = :company AND self.partner.factorizedCustomer = TRUE AND self.statusSelect = :invoiceStatusVentilated AND self.id not in (\t\tselect Invoices.id \t\tfrom SubrogationRelease as SR \t\tjoin SR.invoiceSet as Invoices \t\twhere SR.statusSelect in (:subrogationReleaseStatusTransmitted, :subrogationReleaseStatusAccounted, :subrogationReleaseStatusCleared))AND ((self.amountRemaining > 0 AND self.hasPendingPayments = FALSE)\t\t\tOR self.originalInvoice.id in (\t\t\t\tselect Invoices.id \t\t\t\tfrom SubrogationRelease as SR \t\t\t\tjoin SR.invoiceSet as Invoices \t\t\t\twhere SR.statusSelect in (:subrogationReleaseStatusTransmitted, :subrogationReleaseStatusAccounted, :subrogationReleaseStatusCleared)))").order("invoiceDate").order("dueDate").order("invoiceId");
        query.bind("company", (Object)company);
        query.bind("invoiceStatusVentilated", (Object)3);
        query.bind("subrogationReleaseStatusTransmitted", (Object)2);
        query.bind("subrogationReleaseStatusAccounted", (Object)3);
        query.bind("subrogationReleaseStatusCleared", (Object)4);
        List invoiceList = query.fetch();
        return invoiceList;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void transmitRelease(SubrogationRelease subrogationRelease) throws AxelorException {
        SequenceService sequenceService = (SequenceService)Beans.get(SequenceService.class);
        String sequenceNumber = sequenceService.getSequenceNumber("subrogationRelease", subrogationRelease.getCompany());
        if (Strings.isNullOrEmpty((String)sequenceNumber)) {
            throw new AxelorException(Sequence.class, 3, I18n.get((String)"Missing subrogation release sequence for company %s"), new Object[]{subrogationRelease.getCompany().getName()});
        }
        subrogationRelease.setSequenceNumber(sequenceNumber);
        subrogationRelease.setStatusSelect(2);
        subrogationRelease.setTransmissionDate(this.appBaseService.getTodayDate());
    }

    @Override
    public String printToPDF(SubrogationRelease subrogationRelease, String name) throws AxelorException {
        ReportSettings reportSettings = ReportFactory.createReport((String)"SubrogationRelease.rptdesign", (String)name);
        reportSettings.addParam("SubrogationReleaseId", (Object)subrogationRelease.getId());
        reportSettings.addParam("Locale", (Object)ReportSettings.getPrintingLocale(null));
        reportSettings.addFormat("pdf");
        reportSettings.toAttach((Model)((Object)subrogationRelease));
        reportSettings.generate();
        return reportSettings.getFileLink();
    }

    @Override
    public String exportToCSV(SubrogationRelease subrogationRelease) throws AxelorException, IOException {
        ArrayList<String[]> allMoveLineData = new ArrayList<String[]>();
        Comparator byInvoiceDate = (i1, i2) -> i1.getInvoiceDate().compareTo(i2.getInvoiceDate());
        Comparator byDueDate = (i1, i2) -> i1.getDueDate().compareTo(i2.getDueDate());
        Comparator byInvoiceId = (i1, i2) -> i1.getInvoiceId().compareTo(i2.getInvoiceId());
        List releaseDetails = subrogationRelease.getInvoiceSet().stream().sorted(byInvoiceDate.thenComparing(byDueDate).thenComparing(byInvoiceId)).collect(Collectors.toList());
        for (Invoice invoice : releaseDetails) {
            String[] items = new String[6];
            BigDecimal inTaxTotal = invoice.getInTaxTotal().abs();
            if (InvoiceToolService.isOutPayment(invoice)) {
                inTaxTotal = inTaxTotal.negate();
            }
            items[0] = invoice.getPartner().getPartnerSeq();
            items[1] = invoice.getInvoiceId();
            items[2] = invoice.getInvoiceDate().toString();
            items[3] = invoice.getDueDate().toString();
            items[4] = inTaxTotal.toString();
            items[5] = invoice.getCurrency().getCode();
            allMoveLineData.add(items);
        }
        AccountConfigService accountConfigService = (AccountConfigService)Beans.get(AccountConfigService.class);
        String filePath = accountConfigService.getAccountConfig(subrogationRelease.getCompany()).getExportPath();
        if (filePath == null) {
            filePath = com.google.common.io.Files.createTempDir().getAbsolutePath();
        } else {
            new File(filePath).mkdirs();
        }
        String fileName = String.format("%s %s.csv", I18n.get((String)"Subrogation release"), subrogationRelease.getSequenceNumber());
        Files.createDirectories(Paths.get(filePath, new String[0]), new FileAttribute[0]);
        Path path = Paths.get(filePath, fileName);
        CsvTool.csvWriter((String)filePath, (String)fileName, (char)';', null, allMoveLineData);
        try (FileInputStream is = new FileInputStream(path.toFile());){
            ((MetaFiles)Beans.get(MetaFiles.class)).attach((InputStream)is, fileName, (Model)((Object)subrogationRelease));
        }
        return path.toString();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void enterReleaseInTheAccounts(SubrogationRelease subrogationRelease) throws AxelorException {
        MoveService moveService = (MoveService)Beans.get(MoveService.class);
        MoveRepository moveRepository = (MoveRepository)((Object)Beans.get(MoveRepository.class));
        AccountConfigService accountConfigService = (AccountConfigService)Beans.get(AccountConfigService.class);
        AppBaseService appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        Company company = subrogationRelease.getCompany();
        AccountConfig accountConfig = accountConfigService.getAccountConfig(company);
        Journal journal = accountConfigService.getAutoMiscOpeJournal(accountConfig);
        Account factorCreditAccount = accountConfigService.getFactorCreditAccount(accountConfig);
        Account factorDebitAccount = accountConfigService.getFactorDebitAccount(accountConfig);
        if (subrogationRelease.getAccountingDate() == null) {
            subrogationRelease.setAccountingDate(appBaseService.getTodayDate());
        }
        for (Invoice invoice : subrogationRelease.getInvoiceSet()) {
            if (invoice.getCompanyInTaxTotalRemaining().compareTo(BigDecimal.ZERO) == 0) continue;
            boolean isRefund = false;
            if (invoice.getOperationTypeSelect() == 4) {
                isRefund = true;
            }
            LocalDate date = subrogationRelease.getAccountingDate();
            Move move = moveService.getMoveCreateService().createMove(journal, company, company.getCurrency(), invoice.getPartner(), date, null, 2);
            MoveLine debitMoveLine = moveService.getMoveLineService().createMoveLine(move, invoice.getPartner(), factorDebitAccount, invoice.getCompanyInTaxTotalRemaining(), !isRefund, date, null, 1, subrogationRelease.getSequenceNumber(), invoice.getInvoiceId());
            MoveLine creditMoveLine = moveService.getMoveLineService().createMoveLine(move, invoice.getPartner(), factorCreditAccount, invoice.getCompanyInTaxTotalRemaining(), isRefund, date, null, 2, subrogationRelease.getSequenceNumber(), invoice.getInvoiceId());
            move.addMoveLineListItem(debitMoveLine);
            move.addMoveLineListItem(creditMoveLine);
            move = (Move)((Object)moveRepository.save((Model)((Object)move)));
            moveService.getMoveValidateService().validate(move);
            invoice.setSubrogationRelease(subrogationRelease);
            invoice.setSubrogationReleaseMove(move);
            subrogationRelease.addMoveListItem(move);
        }
        subrogationRelease.setStatusSelect(3);
    }

    @Override
    @Transactional
    public void clear(SubrogationRelease subrogationRelease) {
        if (this.isSubrogationReleaseCompletelyPaid(subrogationRelease)) {
            subrogationRelease.setStatusSelect(4);
        }
    }

    @Override
    public boolean isSubrogationReleaseCompletelyPaid(SubrogationRelease subrogationRelease) {
        return subrogationRelease.getInvoiceSet().stream().filter(p -> p.getAmountRemaining().compareTo(BigDecimal.ZERO) == 1).count() == 0L;
    }
}

