/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.ReportedBalanceLine;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.ReportedBalanceLineRepository;
import com.axelor.apps.account.service.PeriodServiceAccountImpl;
import com.axelor.apps.base.db.AdjustHistory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Year;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.db.repo.YearRepository;
import com.axelor.apps.base.service.AdjustHistoryService;
import com.axelor.apps.base.service.YearServiceImpl;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YearServiceAccountImpl
extends YearServiceImpl {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ReportedBalanceLineRepository reportedBalanceLineRepo;
    protected AdjustHistoryService adjustHistoryService;
    protected PartnerRepository partnerRepository;
    protected PeriodServiceAccountImpl periodServiceAccountImpl;

    @Inject
    public YearServiceAccountImpl(PartnerRepository partnerRepository, ReportedBalanceLineRepository reportedBalanceLineRepo, YearRepository yearRepository, AdjustHistoryService adjustHistoryService, PeriodServiceAccountImpl periodServiceAccountImpl) {
        super(yearRepository);
        this.partnerRepository = partnerRepository;
        this.reportedBalanceLineRepo = reportedBalanceLineRepo;
        this.adjustHistoryService = adjustHistoryService;
        this.periodServiceAccountImpl = periodServiceAccountImpl;
    }

    public void closeYearProcess(Year year) throws AxelorException {
        Query q;
        year = (Year)((Object)this.yearRepository.find(year.getId()));
        for (Period period : year.getPeriodList()) {
            if (period.getStatusSelect() == 3) {
                this.adjustHistoryService.setEndDate(period);
            }
            period.setStatusSelect(Integer.valueOf(2));
            period.setClosureDateTime(LocalDateTime.now());
        }
        Company company = year.getCompany();
        if (company == null) {
            throw new AxelorException((Model)((Object)year), 4, I18n.get((String)"%s : You must configure a company for the fiscal year %s"), new Object[]{I18n.get((String)"Warning !"), year.getName()});
        }
        if (year.getStatusSelect() == 3) {
            AdjustHistory adjustHistory = this.adjustHistoryService.setEndDate(year);
            q = JPA.em().createQuery("select DISTINCT(ml.partner) FROM MoveLine as self WHERE self.move.ignoreInAccountingOk = false AND self.move.year = ?1 AND self.move.statusSelect = ?2 AND self.move.adjustingMove = true AND self.date >= ?3 AND self.date <= ?4");
            q.setParameter(1, (Object)year);
            q.setParameter(2, (Object)3);
            q.setParameter(3, (Object)adjustHistory.getStartDate().toLocalDate());
            q.setParameter(4, (Object)adjustHistory.getEndDate().toLocalDate());
        } else {
            q = JPA.em().createQuery("select DISTINCT(ml.partner) FROM MoveLine as self WHERE self.move.ignoreInAccountingOk = false AND self.move.year = ?1 AND self.move.statusSelect = ?2 AND self.date >= ?3 AND self.date <= ?4");
            q.setParameter(1, (Object)year);
            q.setParameter(2, (Object)3);
            q.setParameter(1, (Object)year.getFromDate());
            q.setParameter(2, (Object)year.getToDate());
        }
        q.setParameter(3, (Object)year.getCompany());
        List partnerList = q.getResultList();
        List partnerListAll = this.partnerRepository.all().fetch();
        this.log.debug("Nombre total de tiers : {}", (Object)partnerListAll.size());
        this.log.debug("Nombre de tiers r\u00e9cup\u00e9r\u00e9 : {}", (Object)partnerList.size());
        for (Partner partner : partnerList) {
            partner = (Partner)((Object)this.partnerRepository.find(partner.getId()));
            year = (Year)((Object)this.yearRepository.find(year.getId()));
            this.log.debug("Tiers en cours de traitement : {}", (Object)partner.getName());
            for (AccountingSituation accountingSituation : partner.getAccountingSituationList()) {
                if (!accountingSituation.getCompany().equals((Object)year.getCompany())) continue;
                this.log.debug("On ajoute une ligne \u00e0 la Situation comptable trouv\u00e9e");
                BigDecimal reportedBalanceAmount = this.computeReportedBalance(year.getFromDate(), year.getToDate(), partner, year);
                this.createReportedBalanceLine(accountingSituation, reportedBalanceAmount, year);
                break;
            }
            JPA.clear();
        }
        this.closeYear(year);
    }

    @Transactional
    public void closeYear(Year year) {
        year.setStatusSelect(2);
        year.setClosureDateTime(LocalDateTime.now());
        this.yearRepository.save((Model)((Object)year));
    }

    @Transactional
    public void adjust(Year year) {
        year = (Year)((Object)this.yearRepository.find(year.getId()));
        this.adjustHistoryService.setStartDate(year);
        year.setStatusSelect(3);
        this.yearRepository.save((Model)((Object)year));
    }

    @Transactional
    public ReportedBalanceLine createReportedBalanceLine(AccountingSituation accountingSituation, BigDecimal amount, Year year) {
        ReportedBalanceLine reportedBalanceLine = new ReportedBalanceLine();
        accountingSituation.addReportedBalanceLineListItem(reportedBalanceLine);
        reportedBalanceLine.setAmount(amount);
        reportedBalanceLine.setYear(year);
        this.reportedBalanceLineRepo.save((Model)((Object)reportedBalanceLine));
        return reportedBalanceLine;
    }

    public BigDecimal computeReportedBalance(LocalDate fromDate, LocalDate toDate, Partner partner, Year year) {
        TypedQuery q = JPA.em().createQuery("select SUM(self.debit - self.credit) FROM MoveLine as self WHERE self.partner = ?1 AND self.move.ignoreInAccountingOk = false AND self.date >= ?2 AND self.date <= ?3 AND self.move.year = ?4 AND self.move.statusSelect = ?5 AND self.account.useForPartnerBalance is true", BigDecimal.class);
        q.setParameter(1, (Object)partner);
        q.setParameter(2, (Object)fromDate);
        q.setParameter(3, (Object)toDate);
        q.setParameter(4, (Object)year);
        q.setParameter(5, (Object)3);
        BigDecimal result = (BigDecimal)q.getSingleResult();
        this.log.debug("Annual balance : {} for partner : {}", (Object)result, (Object)partner.getPartnerSeq());
        if (result != null) {
            return result;
        }
        return BigDecimal.ZERO;
    }

    @Deprecated
    public BigDecimal computeReportedBalance2(LocalDate fromDate, LocalDate toDate, Partner partner, Account account) {
        MoveLineRepository moveLineRepo = (MoveLineRepository)((Object)Beans.get(MoveLineRepository.class));
        List moveLineList = moveLineRepo.all().filter("self.partner = ?1 AND self.ignoreInAccountingOk = 'false' AND self.date >= ?2 AND self.date <= ?3 AND self.account = ?4", new Object[]{partner, fromDate, toDate, account}).fetch();
        BigDecimal reportedBalanceAmount = BigDecimal.ZERO;
        for (MoveLine moveLine : moveLineList) {
            if (moveLine.getDebit().compareTo(BigDecimal.ZERO) > 0) {
                reportedBalanceAmount = reportedBalanceAmount.subtract(moveLine.getAmountRemaining());
                continue;
            }
            if (moveLine.getCredit().compareTo(BigDecimal.ZERO) <= 0) continue;
            reportedBalanceAmount = reportedBalanceAmount.add(moveLine.getAmountRemaining());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Solde rapport\u00e9 : {}", (Object)reportedBalanceAmount);
        }
        return reportedBalanceAmount;
    }
}

