/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.app;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.repo.AccountConfigRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.AppAccount;
import com.axelor.apps.base.db.AppBudget;
import com.axelor.apps.base.db.AppInvoice;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.repo.AppAccountRepository;
import com.axelor.apps.base.db.repo.AppBudgetRepository;
import com.axelor.apps.base.db.repo.AppInvoiceRepository;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.service.app.AppBaseServiceImpl;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.List;

@Singleton
public class AppAccountServiceImpl
extends AppBaseServiceImpl
implements AppAccountService {
    @Inject
    private AppAccountRepository appAccountRepo;
    @Inject
    private AppBudgetRepository appBudgetRepo;
    @Inject
    private AppInvoiceRepository appInvoiceRepo;
    @Inject
    private AccountConfigRepository accountConfigRepo;
    @Inject
    private CompanyRepository companyRepo;

    @Override
    public AppAccount getAppAccount() {
        return (AppAccount)((Object)this.appAccountRepo.all().fetchOne());
    }

    @Override
    public AppBudget getAppBudget() {
        return (AppBudget)((Object)this.appBudgetRepo.all().fetchOne());
    }

    @Override
    public AppInvoice getAppInvoice() {
        return (AppInvoice)((Object)this.appInvoiceRepo.all().fetchOne());
    }

    @Override
    @Transactional
    public void generateAccountConfigurations() {
        List companies = this.companyRepo.all().filter("self.accountConfig is null").fetch();
        for (Company company : companies) {
            AccountConfig config = new AccountConfig();
            config.setCompany(company);
            this.accountConfigRepo.save((Model)((Object)config));
        }
    }
}

