/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.bankorder.file.cfonb;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.CfonbConfig;
import com.axelor.apps.account.db.DirectDebitManagement;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.PaymentScheduleLineRepository;
import com.axelor.apps.account.db.repo.ReimbursementRepository;
import com.axelor.apps.account.service.PaymentScheduleService;
import com.axelor.apps.account.service.config.CfonbConfigService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.tool.StringTool;
import com.axelor.apps.tool.file.FileTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class CfonbExportService {
    protected CfonbConfig cfonbConfig;
    protected CfonbConfigService cfonbConfigService;
    protected ReimbursementRepository reimbursementRepo;
    protected PaymentScheduleLineRepository paymentScheduleLineRepo;
    protected InvoiceRepository invoiceRepo;
    protected PartnerService partnerService;
    private boolean sepa;

    @Inject
    public CfonbExportService(CfonbConfigService cfonbConfigService, ReimbursementRepository reimbursementRepo, PaymentScheduleLineRepository paymentScheduleLineRepo, InvoiceRepository invoiceRepo, PartnerService partnerService) {
        this.cfonbConfigService = cfonbConfigService;
        this.reimbursementRepo = reimbursementRepo;
        this.paymentScheduleLineRepo = paymentScheduleLineRepo;
        this.invoiceRepo = invoiceRepo;
        this.partnerService = partnerService;
    }

    private void init(CfonbConfig cfonbConfig) {
        this.cfonbConfig = cfonbConfig;
    }

    public void setSepa(boolean sepa) {
        this.sepa = sepa;
    }

    public void exportCFONB(Company company, ZonedDateTime datetime, List<Reimbursement> reimbursementList, BankDetails bankDetails) throws AxelorException {
        this.testCompanyExportCFONBField(company);
        String senderCFONB = this.createSenderReimbursementCFONB(datetime, bankDetails);
        ArrayList<String> multiRecipientCFONB = new ArrayList<String>();
        for (Reimbursement reimbursement : reimbursementList) {
            reimbursement = (Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()));
            multiRecipientCFONB.add(this.createRecipientCFONB(reimbursement));
        }
        String totalCFONB = this.createReimbursementTotalCFONB(this.getTotalAmountReimbursementExport(reimbursementList));
    }

    public void exportPaymentScheduleCFONB(ZonedDateTime processingDateTime, LocalDate scheduleDate, List<PaymentScheduleLine> paymentScheduleLineList, Company company, BankDetails bankDetails) throws AxelorException {
        if (paymentScheduleLineList == null || paymentScheduleLineList.isEmpty()) {
            return;
        }
        this.testCompanyExportCFONBField(company);
        String senderCFONB = this.createSenderMonthlyExportCFONB(scheduleDate, bankDetails);
        ArrayList<String> multiRecipientCFONB = new ArrayList<String>();
        ArrayList<DirectDebitManagement> directDebitManagementList = new ArrayList<DirectDebitManagement>();
        for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLineList) {
            if ((paymentScheduleLine = (PaymentScheduleLine)((Object)this.paymentScheduleLineRepo.find(paymentScheduleLine.getId()))).getDirectDebitManagement() == null) {
                multiRecipientCFONB.add(this.createRecipientCFONB(paymentScheduleLine, true));
                continue;
            }
            if (directDebitManagementList.contains((Object)paymentScheduleLine.getDirectDebitManagement())) continue;
            directDebitManagementList.add(paymentScheduleLine.getDirectDebitManagement());
        }
        for (DirectDebitManagement directDebitManagement : directDebitManagementList) {
            multiRecipientCFONB.add(this.createRecipientCFONB(directDebitManagement, false));
        }
        String totalCFONB = this.createPaymentScheduleTotalCFONB(company, this.getTotalAmountPaymentSchedule(paymentScheduleLineList));
    }

    public void exportInvoiceCFONB(ZonedDateTime processingDateTime, LocalDate scheduleDate, List<Invoice> invoiceList, Company company, BankDetails bankDetails) throws AxelorException {
        if (invoiceList == null || invoiceList.isEmpty()) {
            return;
        }
        this.testCompanyExportCFONBField(company);
        String senderCFONB = this.createSenderMonthlyExportCFONB(scheduleDate, bankDetails);
        ArrayList<String> multiRecipientCFONB = new ArrayList<String>();
        ArrayList<DirectDebitManagement> directDebitManagementList = new ArrayList<DirectDebitManagement>();
        for (Invoice invoice : invoiceList) {
            if ((invoice = (Invoice)((Object)this.invoiceRepo.find(invoice.getId()))).getDirectDebitManagement() == null) {
                multiRecipientCFONB.add(this.createRecipientCFONB(company, invoice));
                continue;
            }
            if (directDebitManagementList.contains((Object)invoice.getDirectDebitManagement())) continue;
            directDebitManagementList.add(invoice.getDirectDebitManagement());
        }
        for (DirectDebitManagement directDebitManagement : directDebitManagementList) {
            multiRecipientCFONB.add(this.createRecipientCFONB(directDebitManagement, true));
        }
        BigDecimal amount = this.getTotalAmountInvoice(invoiceList);
        String totalCFONB = this.createPaymentScheduleTotalCFONB(company, amount);
    }

    public void exportCFONB(ZonedDateTime processingDateTime, LocalDate scheduleDate, List<PaymentScheduleLine> paymentScheduleLineList, List<Invoice> invoiceList, Company company, BankDetails bankDetails) throws AxelorException {
        if ((paymentScheduleLineList == null || paymentScheduleLineList.isEmpty()) && (invoiceList == null || invoiceList.isEmpty())) {
            return;
        }
        this.testCompanyExportCFONBField(company);
        String senderCFONB = this.createSenderMonthlyExportCFONB(scheduleDate, bankDetails);
        ArrayList<String> multiRecipientCFONB = new ArrayList<String>();
        ArrayList<DirectDebitManagement> directDebitManagementList = new ArrayList<DirectDebitManagement>();
        for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLineList) {
            if ((paymentScheduleLine = (PaymentScheduleLine)((Object)this.paymentScheduleLineRepo.find(paymentScheduleLine.getId()))).getDirectDebitManagement() == null) {
                multiRecipientCFONB.add(this.createRecipientCFONB(paymentScheduleLine, false));
                continue;
            }
            if (directDebitManagementList.contains((Object)paymentScheduleLine.getDirectDebitManagement())) continue;
            directDebitManagementList.add(paymentScheduleLine.getDirectDebitManagement());
        }
        for (DirectDebitManagement directDebitManagement : directDebitManagementList) {
            multiRecipientCFONB.add(this.createRecipientCFONB(directDebitManagement, false));
        }
        directDebitManagementList = new ArrayList();
        for (Invoice invoice : invoiceList) {
            if ((invoice = (Invoice)((Object)this.invoiceRepo.find(invoice.getId()))).getDirectDebitManagement() == null) {
                multiRecipientCFONB.add(this.createRecipientCFONB(company, invoice));
                continue;
            }
            if (directDebitManagementList.contains((Object)invoice.getDirectDebitManagement())) continue;
            directDebitManagementList.add(invoice.getDirectDebitManagement());
        }
        for (DirectDebitManagement directDebitManagement : directDebitManagementList) {
            multiRecipientCFONB.add(this.createRecipientCFONB(directDebitManagement, true));
        }
        BigDecimal amount = this.getTotalAmountPaymentSchedule(paymentScheduleLineList).add(this.getTotalAmountInvoice(invoiceList));
        String totalCFONB = this.createPaymentScheduleTotalCFONB(company, amount);
    }

    private String createSenderReimbursementCFONB(ZonedDateTime zonedDateTime, BankDetails bankDetails) throws AxelorException {
        SimpleDateFormat ddmmFormat = new SimpleDateFormat("ddMM");
        String date = ddmmFormat.format(zonedDateTime.toLocalDate());
        date = date + String.format("%s", StringTool.truncLeft((String)String.format("%s", zonedDateTime.getYear()), (int)1));
        String a = this.cfonbConfig.getSenderRecordCodeExportCFONB();
        String b1 = this.cfonbConfig.getTransferOperationCodeExportCFONB();
        String b2 = "";
        String b3 = this.cfonbConfig.getSenderNumExportCFONB();
        String c1One = "";
        String c1Two = "";
        String c1Three = date;
        String c2 = this.cfonbConfig.getSenderNameCodeExportCFONB();
        String d1One = "";
        String d1Two = "";
        String d2One = "";
        String d2Two = "E";
        String d2Three = "";
        String d3 = bankDetails.getSortCode();
        String d4 = bankDetails.getAccountNbr();
        String e = "";
        String f = "";
        String g1 = bankDetails.getBankCode();
        String g2 = "";
        b2 = StringTool.fillStringRight((String)b2, (char)' ', (int)8);
        b3 = StringTool.fillStringRight((String)b3, (char)' ', (int)6);
        c1One = StringTool.fillStringRight((String)c1One, (char)' ', (int)1);
        c1Two = StringTool.fillStringRight((String)c1Two, (char)' ', (int)6);
        c2 = StringTool.fillStringRight((String)c2, (char)' ', (int)24);
        d1One = StringTool.fillStringRight((String)d1One, (char)' ', (int)7);
        d1Two = StringTool.fillStringRight((String)d1Two, (char)' ', (int)17);
        d2One = StringTool.fillStringRight((String)d2One, (char)' ', (int)2);
        d2Three = StringTool.fillStringRight((String)d2Three, (char)' ', (int)5);
        d4 = StringTool.fillStringRight((String)d4, (char)' ', (int)11);
        e = StringTool.fillStringRight((String)e, (char)' ', (int)16);
        f = StringTool.fillStringRight((String)f, (char)' ', (int)31);
        g2 = StringTool.fillStringRight((String)g2, (char)' ', (int)6);
        a = StringTool.fillStringLeft((String)a, (char)'0', (int)2);
        b1 = StringTool.fillStringLeft((String)b1, (char)'0', (int)2);
        c1Three = StringTool.fillStringLeft((String)c1Three, (char)'0', (int)5);
        d3 = StringTool.fillStringLeft((String)d3, (char)'0', (int)5);
        g1 = StringTool.fillStringLeft((String)g1, (char)'0', (int)5);
        return a + b1 + b2 + b3 + c1One + c1Two + c1Three + c2 + d1One + d1Two + d2One + d2Two + d2Three + d3 + d4 + e + f + g1 + g2;
    }

    private String createSenderMonthlyExportCFONB(LocalDate localDate, BankDetails bankDetails) throws AxelorException {
        SimpleDateFormat ddmmFormat = new SimpleDateFormat("ddMM");
        String date = ddmmFormat.format(localDate.atTime(LocalTime.now()).toLocalDate());
        date = date + String.format("%s", StringTool.truncLeft((String)String.format("%s", localDate.getYear()), (int)1));
        String a = this.cfonbConfig.getSenderRecordCodeExportCFONB();
        String b1 = this.cfonbConfig.getDirectDebitOperationCodeExportCFONB();
        String b2 = "";
        String b3 = this.cfonbConfig.getSenderNumExportCFONB();
        String c1One = "";
        String c1Two = date;
        String c2 = this.cfonbConfig.getSenderNameCodeExportCFONB();
        String d1One = "";
        String d1Two = "";
        String d2 = "";
        String d3 = bankDetails.getSortCode();
        String d4 = bankDetails.getAccountNbr();
        String e = "";
        String f = "";
        String g1 = bankDetails.getBankCode();
        String g2 = "";
        b2 = StringTool.fillStringRight((String)b2, (char)' ', (int)8);
        b3 = StringTool.fillStringRight((String)b3, (char)' ', (int)6);
        c1One = StringTool.fillStringRight((String)c1One, (char)' ', (int)7);
        c2 = StringTool.fillStringRight((String)c2, (char)' ', (int)24);
        d1One = StringTool.fillStringRight((String)d1One, (char)' ', (int)7);
        d1Two = StringTool.fillStringRight((String)d1Two, (char)' ', (int)17);
        d2 = StringTool.fillStringRight((String)d2, (char)' ', (int)8);
        d4 = StringTool.fillStringRight((String)d4, (char)' ', (int)11);
        e = StringTool.fillStringRight((String)e, (char)' ', (int)16);
        f = StringTool.fillStringRight((String)f, (char)' ', (int)31);
        g2 = StringTool.fillStringRight((String)g2, (char)' ', (int)6);
        a = StringTool.fillStringLeft((String)a, (char)'0', (int)2);
        b1 = StringTool.fillStringLeft((String)b1, (char)'0', (int)2);
        c1Two = StringTool.fillStringLeft((String)c1Two, (char)'0', (int)5);
        d3 = StringTool.fillStringLeft((String)d3, (char)'0', (int)5);
        g1 = StringTool.fillStringLeft((String)g1, (char)'0', (int)5);
        return a + b1 + b2 + b3 + c1One + c1Two + c2 + d1One + d1Two + d2 + d3 + d4 + e + f + g1 + g2;
    }

    private String createRecipientCFONB(Reimbursement reimbursement) throws AxelorException {
        BankDetails bankDetails = reimbursement.getBankDetails();
        if (bankDetails == null) {
            throw new AxelorException(4, "%s :\n " + I18n.get((String)"You must configure a RIB for the reimbursement") + " %s", new Object[]{I18n.get((String)"Warning !"), reimbursement.getRef()});
        }
        BigDecimal amount = reimbursement.getAmountReimbursed();
        String ref = reimbursement.getRef();
        String partner = this.getPayeurPartnerName(reimbursement.getPartner());
        String operationCode = this.cfonbConfig.getTransferOperationCodeExportCFONB();
        return this.createRecipientCFONB(amount, ref, partner, bankDetails, operationCode);
    }

    private String createRecipientCFONB(PaymentScheduleLine paymentScheduleLine, boolean mensu) throws AxelorException {
        PaymentSchedule paymentSchedule = paymentScheduleLine.getPaymentSchedule();
        Partner partner = paymentSchedule.getPartner();
        BankDetails bankDetails = ((PaymentScheduleService)Beans.get(PaymentScheduleService.class)).getBankDetails(paymentSchedule);
        BigDecimal amount = paymentScheduleLine.getDirectDebitAmount();
        String ref = paymentScheduleLine.getDebitNumber();
        String partnerName = this.getPayeurPartnerName(partner);
        String operationCode = this.cfonbConfig.getDirectDebitOperationCodeExportCFONB();
        return this.createRecipientCFONB(amount, ref, partnerName, bankDetails, operationCode);
    }

    private String createRecipientCFONB(DirectDebitManagement directDebitManagement, boolean isForInvoice) throws AxelorException {
        Partner partner;
        BankDetails bankDetails = null;
        String partnerName = "";
        if (isForInvoice) {
            Invoice invoice = (Invoice)((Object)directDebitManagement.getInvoiceSet().toArray()[0]);
            partner = invoice.getPartner();
            bankDetails = this.partnerService.getDefaultBankDetails(partner);
            partnerName = this.getPayeurPartnerName(invoice.getPartner());
            if (bankDetails == null) {
                throw new AxelorException(4, I18n.get((String)"%s : You must configure a RIB for the partner %s"), new Object[]{I18n.get((String)"Warning !"), partner.getName()});
            }
        } else {
            PaymentSchedule paymentSchedule = directDebitManagement.getPaymentScheduleLineList().get(0).getPaymentSchedule();
            partner = paymentSchedule.getPartner();
            partnerName = this.getPayeurPartnerName(partner);
            bankDetails = ((PaymentScheduleService)Beans.get(PaymentScheduleService.class)).getBankDetails(paymentSchedule);
        }
        BigDecimal amount = this.getAmount(directDebitManagement, isForInvoice);
        String ref = directDebitManagement.getDebitNumber();
        String operationCode = this.cfonbConfig.getDirectDebitOperationCodeExportCFONB();
        return this.createRecipientCFONB(amount, ref, partnerName, bankDetails, operationCode);
    }

    private BigDecimal getAmount(DirectDebitManagement directDebitManagement, boolean isForInvoice) {
        BigDecimal amount = BigDecimal.ZERO;
        if (isForInvoice) {
            for (Invoice invoice : directDebitManagement.getInvoiceSet()) {
                amount = amount.add(invoice.getDirectDebitAmount());
            }
        } else {
            for (PaymentScheduleLine paymentScheduleLine : directDebitManagement.getPaymentScheduleLineList()) {
                amount = amount.add(paymentScheduleLine.getDirectDebitAmount());
            }
        }
        return amount;
    }

    private String createRecipientCFONB(Company company, Invoice invoice) throws AxelorException {
        Partner partner = invoice.getPartner();
        BankDetails bankDetails = this.partnerService.getDefaultBankDetails(partner);
        if (bankDetails == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a RIB for the partner %s"), new Object[]{I18n.get((String)"Warning !"), partner.getName()});
        }
        BigDecimal amount = invoice.getDirectDebitAmount();
        String ref = invoice.getDebitNumber();
        String partnerName = this.getPayeurPartnerName(partner);
        String operationCode = this.cfonbConfig.getDirectDebitOperationCodeExportCFONB();
        return this.createRecipientCFONB(amount, ref, partnerName, bankDetails, operationCode);
    }

    private String createRecipientCFONB(BigDecimal amount, String ref, String partner, BankDetails bankDetails, String operationCode) throws AxelorException {
        this.testBankDetailsField(bankDetails);
        String amountFixed = amount.setScale(2).toString().replace(".", "");
        String a = this.cfonbConfig.getRecipientRecordCodeExportCFONB();
        String b1 = operationCode;
        String b2 = "";
        String b3 = this.cfonbConfig.getSenderNumExportCFONB();
        String c1 = ref;
        String c2 = partner;
        String d1 = bankDetails.getBankAddress().getAddress();
        String d2 = "";
        String d3 = bankDetails.getSortCode();
        String d4 = bankDetails.getAccountNbr();
        String e = amountFixed;
        String f = ref;
        String g1 = bankDetails.getBankCode();
        String g2 = "";
        b2 = StringTool.fillStringRight((String)b2, (char)' ', (int)8);
        b3 = StringTool.fillStringRight((String)b3, (char)' ', (int)6);
        c1 = StringTool.fillStringRight((String)c1, (char)' ', (int)12);
        c2 = StringTool.fillStringRight((String)c2, (char)' ', (int)24);
        d1 = StringTool.fillStringRight((String)d1, (char)' ', (int)24);
        d2 = StringTool.fillStringRight((String)d2, (char)' ', (int)8);
        d4 = StringTool.fillStringRight((String)d4, (char)' ', (int)11);
        f = StringTool.fillStringRight((String)f, (char)' ', (int)31);
        g2 = StringTool.fillStringRight((String)g2, (char)' ', (int)6);
        a = StringTool.fillStringLeft((String)a, (char)'0', (int)2);
        b1 = StringTool.fillStringLeft((String)b1, (char)'0', (int)2);
        d3 = StringTool.fillStringLeft((String)d3, (char)'0', (int)5);
        e = StringTool.fillStringLeft((String)e, (char)'0', (int)16);
        g1 = StringTool.fillStringLeft((String)g1, (char)'0', (int)5);
        return a + b1 + b2 + b3 + c1 + c2 + d1 + d2 + d3 + d4 + e + f + g1 + g2;
    }

    private String createReimbursementTotalCFONB(BigDecimal amount) {
        String operationCode = this.cfonbConfig.getTransferOperationCodeExportCFONB();
        return this.createTotalCFONB(amount, operationCode);
    }

    private String createPaymentScheduleTotalCFONB(Company company, BigDecimal amount) {
        String operationCode = this.cfonbConfig.getDirectDebitOperationCodeExportCFONB();
        return this.createTotalCFONB(amount, operationCode);
    }

    private String createTotalCFONB(BigDecimal amount, String operationCode) {
        String totalAmount = amount.setScale(2).toString().replace(".", "");
        String a = this.cfonbConfig.getTotalRecordCodeExportCFONB();
        String b1 = operationCode;
        String b2 = "";
        String b3 = this.cfonbConfig.getSenderNumExportCFONB();
        String c1 = "";
        String c2 = "";
        String d1 = "";
        String d2 = "";
        String d3 = "";
        String d4 = "";
        String e = totalAmount;
        String f = "";
        String g1 = "";
        String g2 = "";
        b2 = StringTool.fillStringRight((String)b2, (char)' ', (int)8);
        b3 = StringTool.fillStringRight((String)b3, (char)' ', (int)6);
        c1 = StringTool.fillStringRight((String)c1, (char)' ', (int)12);
        c2 = StringTool.fillStringRight((String)c2, (char)' ', (int)24);
        d1 = StringTool.fillStringRight((String)d1, (char)' ', (int)24);
        d2 = StringTool.fillStringRight((String)d2, (char)' ', (int)8);
        d3 = StringTool.fillStringRight((String)d3, (char)' ', (int)5);
        d4 = StringTool.fillStringRight((String)d4, (char)' ', (int)11);
        f = StringTool.fillStringRight((String)f, (char)' ', (int)31);
        g1 = StringTool.fillStringRight((String)g1, (char)' ', (int)5);
        g2 = StringTool.fillStringRight((String)g2, (char)' ', (int)6);
        a = StringTool.fillStringLeft((String)a, (char)'0', (int)2);
        b1 = StringTool.fillStringLeft((String)b1, (char)'0', (int)2);
        e = StringTool.fillStringLeft((String)e, (char)'0', (int)16);
        return a + b1 + b2 + b3 + c1 + c2 + d1 + d2 + d3 + d4 + e + f + g1 + g2;
    }

    private void createCFONBFile(List<String> cFONB, ZonedDateTime zonedDateTime, String destinationFolder, String prefix) throws AxelorException {
        SimpleDateFormat yyyyMMddHHmmssFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateFileName = yyyyMMddHHmmssFormat.format(zonedDateTime);
        String fileName = String.format("%s%s.dat", prefix, dateFileName);
        try {
            FileTool.writer((String)destinationFolder, (String)fileName, cFONB);
        }
        catch (IOException e) {
            throw new AxelorException(e.getCause(), 4, I18n.get((String)"%s : Error detected during CFONB file's writing : %s"), new Object[]{I18n.get((String)"Warning !"), e});
        }
    }

    private String getPayeurPartnerName(Partner partner) {
        if (partner.getTitleSelect() != null) {
            return String.format("%s %s", partner.getTitleSelect(), partner.getName());
        }
        return String.format("%s", partner.getName());
    }

    private BigDecimal getTotalAmountReimbursementExport(List<Reimbursement> reimbursementList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Reimbursement reimbursement : reimbursementList) {
            reimbursement = (Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()));
            totalAmount = totalAmount.add(reimbursement.getAmountReimbursed());
        }
        return totalAmount;
    }

    private BigDecimal getTotalAmountPaymentSchedule(List<PaymentScheduleLine> paymentScheduleLineList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (PaymentScheduleLine paymentScheduleLine : paymentScheduleLineList) {
            totalAmount = totalAmount.add(((PaymentScheduleLine)((Object)this.paymentScheduleLineRepo.find(paymentScheduleLine.getId()))).getDirectDebitAmount());
        }
        return totalAmount;
    }

    private BigDecimal getTotalAmountInvoice(List<Invoice> invoiceList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Invoice invoice : invoiceList) {
            totalAmount = totalAmount.add(((Invoice)((Object)this.invoiceRepo.find(invoice.getId()))).getDirectDebitAmount());
        }
        return totalAmount;
    }

    public void testCompanyExportCFONBField(Company company) throws AxelorException {
        AccountConfig accountConfig = this.cfonbConfigService.getAccountConfig(company);
        this.cfonbConfigService.getReimbursementExportFolderPathCFONB(accountConfig);
        this.cfonbConfigService.getPaymentScheduleExportFolderPathCFONB(accountConfig);
        this.init(this.cfonbConfigService.getCfonbConfig(company));
        this.cfonbConfigService.getSenderRecordCodeExportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getSenderNumExportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getSenderNameCodeExportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getRecipientRecordCodeExportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getTotalRecordCodeExportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getTransferOperationCodeExportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getDirectDebitOperationCodeExportCFONB(this.cfonbConfig);
    }

    public void testBankDetailsField(BankDetails bankDetails) throws AxelorException {
        if (bankDetails.getSortCode() == null || bankDetails.getSortCode().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Sort Code for the RIB %s of third-payer %s"), new Object[]{I18n.get((String)"Warning !"), bankDetails.getIban(), bankDetails.getPartner().getName()});
        }
        if (bankDetails.getAccountNbr() == null || bankDetails.getAccountNbr().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a number's account for the RIB %s of third-payer %s"), new Object[]{I18n.get((String)"Warning !"), bankDetails.getIban(), bankDetails.getPartner().getName()});
        }
        if (bankDetails.getBankCode() == null || bankDetails.getBankCode().isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Bank Code for the RIB %s of third-payer %s"), new Object[]{I18n.get((String)"Warning !"), bankDetails.getIban(), bankDetails.getPartner().getName()});
        }
        String bankAddress = bankDetails.getBankAddress().getAddress();
        if (bankAddress == null || bankAddress.isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a Bank Address for the RIB %s of third-payer %s"), new Object[]{I18n.get((String)"Warning !"), bankDetails.getIban(), bankDetails.getPartner().getName()});
        }
    }
}

