/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.service.batch.BatchAccountCustomer;
import com.axelor.apps.account.service.batch.BatchCloseAnnualAccounts;
import com.axelor.apps.account.service.batch.BatchCreditTransferCustomerRefund;
import com.axelor.apps.account.service.batch.BatchCreditTransferExpensePayment;
import com.axelor.apps.account.service.batch.BatchCreditTransferPartnerReimbursement;
import com.axelor.apps.account.service.batch.BatchCreditTransferSupplierPayment;
import com.axelor.apps.account.service.batch.BatchDebtRecovery;
import com.axelor.apps.account.service.batch.BatchDoubtfulCustomer;
import com.axelor.apps.account.service.batch.BatchMoveLineExport;
import com.axelor.apps.account.service.batch.BatchRealizeFixedAssetLine;
import com.axelor.apps.account.service.batch.BatchReimbursementExport;
import com.axelor.apps.account.service.batch.BatchReimbursementImport;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.service.administration.AbstractBatchService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;

public class AccountingBatchService
extends AbstractBatchService {
    protected Class<? extends Model> getModelClass() {
        return AccountingBatch.class;
    }

    public Batch run(Model batchModel) throws AxelorException {
        Batch batch;
        AccountingBatch accountingBatch = (AccountingBatch)((Object)batchModel);
        switch (accountingBatch.getActionSelect()) {
            case 11: {
                if (accountingBatch.getReimbursementTypeSelect() == 1) {
                    batch = this.reimbursementExport(accountingBatch);
                } else if (accountingBatch.getReimbursementTypeSelect() == 2) {
                    batch = this.reimbursementImport(accountingBatch);
                }
                batch = null;
                break;
            }
            case 14: {
                batch = this.debtRecovery(accountingBatch);
                break;
            }
            case 16: {
                batch = this.doubtfulCustomer(accountingBatch);
                break;
            }
            case 17: {
                batch = this.accountCustomer(accountingBatch);
                break;
            }
            case 18: {
                batch = this.moveLineExport(accountingBatch);
                break;
            }
            case 19: {
                batch = this.creditTransfer(accountingBatch);
                break;
            }
            case 20: {
                batch = this.realizeFixedAssetLines(accountingBatch);
                break;
            }
            default: {
                throw new AxelorException(5, I18n.get((String)"Unknown action %s for the %s treatment"), new Object[]{accountingBatch.getActionSelect(), accountingBatch.getCode()});
            }
        }
        return batch;
    }

    public Batch debtRecovery(AccountingBatch accountingBatch) {
        return ((BatchDebtRecovery)((Object)Beans.get(BatchDebtRecovery.class))).run(accountingBatch);
    }

    public Batch doubtfulCustomer(AccountingBatch accountingBatch) {
        return ((BatchDoubtfulCustomer)((Object)Beans.get(BatchDoubtfulCustomer.class))).run(accountingBatch);
    }

    public Batch reimbursementExport(AccountingBatch accountingBatch) {
        return ((BatchReimbursementExport)((Object)Beans.get(BatchReimbursementExport.class))).run(accountingBatch);
    }

    public Batch reimbursementImport(AccountingBatch accountingBatch) {
        return ((BatchReimbursementImport)((Object)Beans.get(BatchReimbursementImport.class))).run(accountingBatch);
    }

    public Batch accountCustomer(AccountingBatch accountingBatch) {
        return ((BatchAccountCustomer)((Object)Beans.get(BatchAccountCustomer.class))).run(accountingBatch);
    }

    public Batch moveLineExport(AccountingBatch accountingBatch) {
        return ((BatchMoveLineExport)((Object)Beans.get(BatchMoveLineExport.class))).run(accountingBatch);
    }

    public Batch creditTransfer(AccountingBatch accountingBatch) {
        Class batchStrategyClass;
        block0 : switch (accountingBatch.getCreditTransferTypeSelect()) {
            case 1: {
                batchStrategyClass = BatchCreditTransferExpensePayment.class;
                break;
            }
            case 2: {
                batchStrategyClass = BatchCreditTransferSupplierPayment.class;
                break;
            }
            case 3: {
                switch (accountingBatch.getCustomerReimbursementTypeSelect()) {
                    case 1: {
                        batchStrategyClass = BatchCreditTransferCustomerRefund.class;
                        break block0;
                    }
                    case 2: {
                        batchStrategyClass = BatchCreditTransferPartnerReimbursement.class;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unknown customer reimbursement type");
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown credit transfer type: %d", accountingBatch.getCreditTransferTypeSelect()));
            }
        }
        return ((BatchStrategy)((Object)Beans.get(batchStrategyClass))).run(accountingBatch);
    }

    public Batch directDebit(AccountingBatch accountingBatch) {
        throw new UnsupportedOperationException(I18n.get((String)"This batch requires the bank payment module."));
    }

    public Batch realizeFixedAssetLines(AccountingBatch accountingBatch) {
        return ((BatchRealizeFixedAssetLine)((Object)Beans.get(BatchRealizeFixedAssetLine.class))).run(accountingBatch);
    }

    public Batch closeAnnualAccounts(AccountingBatch accountingBatch) {
        return ((BatchCloseAnnualAccounts)((Object)Beans.get(BatchCloseAnnualAccounts.class))).run(accountingBatch);
    }
}

