/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.repo.AccountingSituationRepository;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.base.db.Company;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchAccountCustomer
extends BatchStrategy {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AccountingSituationRepository accountingSituationRepo;

    @Inject
    public BatchAccountCustomer(AccountCustomerService accountCustomerService, AccountingSituationRepository accountingSituationRepo) {
        super(accountCustomerService);
        this.accountingSituationRepo = accountingSituationRepo;
    }

    protected void start() throws IllegalAccessException {
        super.start();
        this.checkPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        AccountingBatch accountingBatch = this.batch.getAccountingBatch();
        Company company = accountingBatch.getCompany();
        boolean updateCustAccountOk = accountingBatch.getUpdateCustAccountOk();
        boolean updateDueCustAccountOk = accountingBatch.getUpdateDueCustAccountOk();
        boolean updateDueDebtRecoveryCustAccountOk = accountingBatch.getUpdateDueDebtRecoveryCustAccountOk();
        List accountingSituationList = this.accountingSituationRepo.all().filter("self.company = ?1", new Object[]{company}).fetch();
        int i = 0;
        JPA.clear();
        for (AccountingSituation accountingSituation : accountingSituationList) {
            try {
                if ((accountingSituation = this.accountCustomerService.updateAccountingSituationCustomerAccount((AccountingSituation)((Object)this.accountingSituationRepo.find(accountingSituation.getId())), updateCustAccountOk, updateDueCustAccountOk, updateDueDebtRecoveryCustAccountOk)) == null) continue;
                this.updateAccountingSituation(accountingSituation);
                ++i;
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Accounting situation %s"), ((AccountingSituation)((Object)this.accountingSituationRepo.find(accountingSituation.getId()))).getName()), e), (String)"accountCustomer", (long)this.batch.getId());
                this.incrementAnomaly();
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour la situation compable {}", (Object)((AccountingSituation)((Object)this.accountingSituationRepo.find(accountingSituation.getId()))).getName());
            }
            finally {
                if (i % 1 != 0) continue;
                JPA.clear();
            }
        }
    }

    protected void stop() {
        String comment = "";
        comment = I18n.get((String)"Contact's account balances determination's reporting :") + "\n";
        comment = comment + String.format("\t" + I18n.get((String)"* %s Account(s) situation(s) treated") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateAccountingSituationMarked(Company company) {
        int anomaly = 0;
        List accountingSituationList = null;
        accountingSituationList = company != null ? this.accountingSituationRepo.all().filter("self.company = ?1 and self.custAccountMustBeUpdateOk = 'true'", new Object[]{company}).fetch() : this.accountingSituationRepo.all().filter("self.custAccountMustBeUpdateOk = 'true'").fetch();
        int i = 0;
        JPA.clear();
        for (AccountingSituation accountingSituation : accountingSituationList) {
            try {
                if ((accountingSituation = this.accountCustomerService.updateAccountingSituationCustomerAccount((AccountingSituation)((Object)this.accountingSituationRepo.find(accountingSituation.getId())), true, true, false)) == null) continue;
                ++i;
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Accounting situation %s"), ((AccountingSituation)((Object)this.accountingSituationRepo.find(accountingSituation.getId()))).getName()), e), (String)"accountCustomer", (long)this.batch.getId());
                ++anomaly;
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le compte client {}", (Object)this.accountingSituationRepo.find(accountingSituation.getId()));
            }
            finally {
                if (i % 5 != 0) continue;
                JPA.clear();
            }
        }
        if (anomaly != 0) {
            return String.format(I18n.get((String)"Account balances of %s accounting situation has not been updated, you must run the contact account batch update."), anomaly);
        }
        return String.format(I18n.get((String)"Account balances from all accounts situations (%s) has been updated."), i);
    }
}

