/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.service.AccountingCloseAnnualService;
import com.axelor.apps.account.service.AccountingReportService;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Year;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.db.repo.YearRepository;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.time.LocalDate;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCloseAnnualAccounts
extends BatchStrategy {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected PartnerRepository partnerRepository;
    protected YearRepository yearRepository;
    protected AccountRepository accountRepository;
    protected AccountingCloseAnnualService accountingCloseAnnualService;
    protected boolean stop = false;

    @Inject
    public BatchCloseAnnualAccounts(PartnerRepository partnerRepository, YearRepository yearRepository, AccountRepository accountRepository, AccountingCloseAnnualService accountingCloseAnnualService) {
        this.partnerRepository = partnerRepository;
        this.yearRepository = yearRepository;
        this.accountRepository = accountRepository;
        this.accountingCloseAnnualService = accountingCloseAnnualService;
    }

    protected void start() throws IllegalAccessException {
        super.start();
        try {
            ((AccountingReportService)Beans.get(AccountingReportService.class)).testReportedDateField(this.batch.getAccountingBatch().getYear().getReportedBalanceDate());
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), ""), (String)"reportedBalance", (long)this.batch.getId());
            this.incrementAnomaly();
            this.stop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        if (!this.stop) {
            AccountingBatch accountingBatch = this.batch.getAccountingBatch();
            boolean allocatePerPartner = accountingBatch.getAllocatePerPartner();
            boolean closeYear = accountingBatch.getCloseYear();
            boolean openYear = accountingBatch.getOpenYear();
            Year year = accountingBatch.getYear();
            LocalDate endOfYearDate = year.getToDate();
            LocalDate reportedBalanceDate = year.getReportedBalanceDate();
            String origin = accountingBatch.getCode();
            String moveDescription = accountingBatch.getMoveDescription();
            List<Long> accountIdList = this.accountingCloseAnnualService.getAllAccountOfYear(accountingBatch.getAccountSet(), year);
            List<Pair<Long, Long>> accountAndPartnerPairList = this.accountingCloseAnnualService.assignPartner(accountIdList, year, allocatePerPartner);
            Account account = null;
            Partner partner = null;
            for (Pair<Long, Long> accountAndPartnerPair : accountAndPartnerPairList) {
                try {
                    account = (Account)((Object)this.accountRepository.find((Long)accountAndPartnerPair.getLeft()));
                    partner = accountAndPartnerPair.getRight() != null ? (Partner)((Object)this.partnerRepository.find((Long)accountAndPartnerPair.getRight())) : null;
                    List<Move> generateMoves = this.accountingCloseAnnualService.generateCloseAnnualAccount((Year)((Object)this.yearRepository.find(year.getId())), account, partner, endOfYearDate, reportedBalanceDate, origin, moveDescription, closeYear, openYear, allocatePerPartner);
                    if (generateMoves == null || generateMoves.isEmpty()) continue;
                    this.updateAccount(account);
                    for (Move move : generateMoves) {
                        this.updateAccountMove(move, false);
                    }
                }
                catch (AxelorException e) {
                    TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Account") + " %s", new Object[]{account.getCode()}), null, (long)this.batch.getId());
                    this.incrementAnomaly();
                    break;
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Account") + " %s", account.getCode()), e), null, (long)this.batch.getId());
                    this.incrementAnomaly();
                    LOG.error("Anomaly generated for the account {}", (Object)account.getCode());
                    break;
                }
                finally {
                    JPA.clear();
                }
            }
        }
    }

    protected void stop() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.get((String)"Report for close/open annual accounts batch:")).append(" ");
        sb.append(String.format(I18n.get((String)"%d account treated successfully,", (String)"%d accounts treated successfully,", (int)this.batch.getDone()) + " ", this.batch.getDone()));
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)this.batch.getAnomaly()), this.batch.getAnomaly()));
        this.addComment(sb.toString());
        super.stop();
    }
}

