/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.account.service.ReimbursementExportService;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCreditTransferPartnerReimbursement
extends BatchStrategy {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected PartnerRepository partnerRepo;
    protected PartnerService partnerService;
    protected ReimbursementExportService reimbursementExportService;

    @Inject
    public BatchCreditTransferPartnerReimbursement(PartnerRepository partnerRepo, PartnerService partnerService, ReimbursementExportService reimbursementExportService) {
        this.partnerRepo = partnerRepo;
        this.partnerService = partnerService;
        this.reimbursementExportService = reimbursementExportService;
    }

    protected void process() {
        AccountingBatch accountingBatch = this.batch.getAccountingBatch();
        TypedQuery partnerQuery = JPA.em().createQuery("SELECT self FROM Partner self JOIN self.accountingSituationList accountingSituation WHERE accountingSituation.company = :company AND accountingSituation.balanceCustAccount < 0", Partner.class);
        partnerQuery.setParameter("company", (Object)accountingBatch.getCompany());
        List partnerList = partnerQuery.getResultList();
        for (Partner partner : partnerList) {
            try {
                partner = (Partner)((Object)this.partnerRepo.find(partner.getId()));
                Reimbursement reimbursement = this.createReimbursement(partner, accountingBatch.getCompany());
                if (reimbursement != null) {
                    this.incrementDone();
                }
            }
            catch (Exception ex) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)ex, (String)"creditTransfer", (long)this.batch.getId());
                ex.printStackTrace();
                this.log.error(String.format("Credit transfer batch for partner credit balance reimbursement: anomaly for partner %s", partner.getName()));
            }
            JPA.clear();
        }
    }

    protected void stop() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.get((String)"Report for credit transfer batch:")).append(" ");
        sb.append(String.format(I18n.get((String)"%d reimbursement created successfully,", (String)"%d reimbursements created successfully,", (int)this.batch.getDone()) + " ", this.batch.getDone()));
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)this.batch.getAnomaly()), this.batch.getAnomaly()));
        this.addComment(sb.toString());
        super.stop();
    }

    @Transactional(rollbackOn={Exception.class})
    protected Reimbursement createReimbursement(Partner partner, Company company) throws AxelorException {
        List moveLineList = this.moveLineRepo.all().filter("self.account.reconcileOk = true AND (self.move.statusSelect = ?1 OR self.move.statusSelect = ?2) AND self.amountRemaining > 0 AND self.credit > 0 AND self.move.partner = ?3 AND self.move.company = ?4 AND self.reimbursementStatusSelect = ?5", new Object[]{3, 2, partner, company, 0}).fetch();
        Reimbursement reimbursement = this.reimbursementExportService.runCreateReimbursement(moveLineList, company, partner);
        return reimbursement;
    }
}

