/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.service.AccountingService;
import com.axelor.apps.account.service.batch.BatchAccountCustomer;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.account.service.debtrecovery.DoubtfulCustomerService;
import com.axelor.apps.base.db.Company;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDoubtfulCustomer
extends BatchStrategy {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean stop = false;
    protected String updateCustomerAccountLog = "";
    protected AccountRepository accountRepo;

    @Inject
    public BatchDoubtfulCustomer(DoubtfulCustomerService doubtfulCustomerService, BatchAccountCustomer batchAccountCustomer, AccountRepository accountRepo) {
        super(doubtfulCustomerService, batchAccountCustomer);
        this.accountRepo = accountRepo;
        AccountingService.setUpdateCustomerAccount(false);
    }

    protected void start() throws IllegalAccessException {
        super.start();
        Company company = this.batch.getAccountingBatch().getCompany();
        try {
            this.doubtfulCustomerService.testCompanyField(company);
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), ""), (String)"doubtfulCustomer", (long)this.batch.getId());
            this.incrementAnomaly();
            this.stop = true;
        }
        this.checkPoint();
    }

    protected void process() {
        if (!this.stop) {
            Company company = this.batch.getAccountingBatch().getCompany();
            AccountConfig accountConfig = company.getAccountConfig();
            Account doubtfulCustomerAccount = accountConfig.getDoubtfulCustomerAccount();
            String sixMonthDebtPassReason = accountConfig.getSixMonthDebtPassReason();
            String threeMonthDebtPassReason = accountConfig.getThreeMonthDebtPassReason();
            List<Move> moveList = this.doubtfulCustomerService.getMove(0, doubtfulCustomerAccount, company);
            this.log.debug("Nombre d'\u00e9critures de facture concern\u00e9es (Cr\u00e9ance de + 6 mois) au 411 : {} ", (Object)moveList.size());
            this.createDoubtFulCustomerMove(moveList, doubtfulCustomerAccount, sixMonthDebtPassReason);
            moveList = this.doubtfulCustomerService.getMove(1, doubtfulCustomerAccount, company);
            this.log.debug("Nombre d'\u00e9critures de facture concern\u00e9es (Cr\u00e9ance de + 3 mois) au 411 : {} ", (Object)moveList.size());
            this.createDoubtFulCustomerMove(moveList, doubtfulCustomerAccount, threeMonthDebtPassReason);
            List<MoveLine> moveLineList = this.doubtfulCustomerService.getRejectMoveLine(0, doubtfulCustomerAccount, company);
            this.log.debug("Nombre de lignes d'\u00e9criture de rejet concern\u00e9es (Cr\u00e9ance de + 6 mois) au 411 : {} ", (Object)moveLineList.size());
            this.createDoubtFulCustomerRejectMove(moveLineList, doubtfulCustomerAccount, sixMonthDebtPassReason);
            moveLineList = this.doubtfulCustomerService.getRejectMoveLine(1, doubtfulCustomerAccount, company);
            this.log.debug("Nombre de lignes d'\u00e9criture de rejet concern\u00e9es (Cr\u00e9ance de + 3 mois) au 411 : {} ", (Object)moveLineList.size());
            this.createDoubtFulCustomerRejectMove(moveLineList, doubtfulCustomerAccount, threeMonthDebtPassReason);
            this.updateCustomerAccountLog = this.updateCustomerAccountLog + this.batchAccountCustomer.updateAccountingSituationMarked((Company)((Object)this.companyRepo.find(company.getId())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDoubtFulCustomerMove(List<Move> moveList, Account doubtfulCustomerAccount, String debtPassReason) {
        int i = 0;
        for (Move move : moveList) {
            try {
                this.doubtfulCustomerService.createDoubtFulCustomerMove((Move)((Object)this.moveRepo.find(move.getId())), (Account)((Object)this.accountRepo.find(doubtfulCustomerAccount.getId())), debtPassReason);
                this.updateInvoice(((Move)((Object)this.moveRepo.find(move.getId()))).getInvoice());
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Invoice") + " %s", new Object[]{move.getInvoice().getInvoiceId()}), (String)"doubtfulCustomer", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Invoice") + " %s", move.getInvoice().getInvoiceId()), e), (String)"doubtfulCustomer", (long)this.batch.getId());
                this.incrementAnomaly();
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour la facture {}", (Object)((Move)((Object)this.moveRepo.find(move.getId()))).getInvoice().getInvoiceId());
            }
            finally {
                if (i % 10 != 0) continue;
                JPA.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDoubtFulCustomerRejectMove(List<MoveLine> moveLineList, Account doubtfulCustomerAccount, String debtPassReason) {
        int i = 0;
        for (MoveLine moveLine : moveLineList) {
            try {
                this.doubtfulCustomerService.createDoubtFulCustomerRejectMove((MoveLine)((Object)this.moveLineRepo.find(moveLine.getId())), (Account)((Object)this.accountRepo.find(doubtfulCustomerAccount.getId())), debtPassReason);
                this.updateInvoice(((MoveLine)((Object)this.moveLineRepo.find(moveLine.getId()))).getInvoiceReject());
                ++i;
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Invoice") + " %s", new Object[]{moveLine.getInvoiceReject().getInvoiceId()}), (String)"doubtfulCustomer", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Invoice") + " %s", moveLine.getInvoiceReject().getInvoiceId()), e), (String)"doubtfulCustomer", (long)this.batch.getId());
                this.incrementAnomaly();
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour la facture {}", (Object)((MoveLine)((Object)this.moveLineRepo.find(moveLine.getId()))).getInvoiceReject().getInvoiceId());
            }
            finally {
                if (i % 10 != 0) continue;
                JPA.clear();
            }
        }
    }

    protected void stop() {
        AccountingService.setUpdateCustomerAccount(true);
        String comment = I18n.get((String)"Doubtful account's determination's reporting") + " :\n";
        comment = comment + String.format("\t" + I18n.get((String)"* %s Invoice(s) treated") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        comment = comment + String.format("\t* ------------------------------- \n", new Object[0]);
        comment = comment + String.format("\t* %s ", this.updateCustomerAccountLog);
        super.stop();
        this.addComment(comment);
    }
}

