/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.AccountingReport;
import com.axelor.apps.account.db.repo.AccountingReportRepository;
import com.axelor.apps.account.service.MoveLineExportService;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.base.db.Company;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchMoveLineExport
extends BatchStrategy {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean stop = false;
    protected long moveLineDone = 0L;
    protected long moveDone = 0L;
    protected BigDecimal debit = BigDecimal.ZERO;
    protected BigDecimal credit = BigDecimal.ZERO;
    protected BigDecimal balance = BigDecimal.ZERO;
    protected AccountingReportRepository accountingReportRepository;

    @Inject
    public BatchMoveLineExport(MoveLineExportService moveLineExportService, AccountingReportRepository accountingReportRepository) {
        super(moveLineExportService);
        this.accountingReportRepository = accountingReportRepository;
    }

    protected void start() throws IllegalAccessException {
        super.start();
        try {
            this.testAccountingBatchField();
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), ""), (String)"moveLineExport", (long)this.batch.getId());
            this.incrementAnomaly();
            this.stop = true;
        }
        this.checkPoint();
    }

    protected void process() {
        if (!this.stop) {
            try {
                Company company = this.batch.getAccountingBatch().getCompany();
                LocalDate startDate = this.batch.getAccountingBatch().getStartDate();
                LocalDate endDate = this.batch.getAccountingBatch().getEndDate();
                int exportTypeSelect = this.batch.getAccountingBatch().getMoveLineExportTypeSelect();
                AccountingReport accountingReport = this.moveLineExportService.createAccountingReport(company, exportTypeSelect, startDate, endDate);
                this.moveLineExportService.exportMoveLine(accountingReport);
                JPA.clear();
                accountingReport = (AccountingReport)((Object)this.accountingReportRepository.find(accountingReport.getId()));
                this.moveLineDone = this.moveLineRepo.all().filter("self.move.accountingReport = ?1", new Object[]{accountingReport}).count();
                this.moveDone = this.moveRepo.all().filter("self.accountingReport = ?1", new Object[]{accountingReport}).count();
                this.debit = accountingReport.getTotalDebit();
                this.credit = accountingReport.getTotalCredit();
                this.balance = accountingReport.getBalance();
                this.updateAccountingReport(accountingReport);
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), String.format("%s", new Object[]{e})), (String)"moveLineExport", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format("%s", e), e), (String)"moveLineExport", (long)this.batch.getId());
                this.incrementAnomaly();
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le batch {}", (Object)this.batch.getId());
            }
        }
    }

    public void testAccountingBatchField() throws AxelorException {
        AccountingBatch accountingBatch = this.batch.getAccountingBatch();
        if (accountingBatch.getCompany() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Error : You must configure a company for the batch configurator %s"), new Object[]{I18n.get((String)"Warning !"), accountingBatch.getCode()});
        }
        if (accountingBatch.getEndDate() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Error : You must configure a due date for the batch configurator %s"), new Object[]{I18n.get((String)"Warning !"), accountingBatch.getCode()});
        }
        if (accountingBatch.getMoveLineExportTypeSelect() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : Error : You must configure an export type for the batch configurator %s"), new Object[]{I18n.get((String)"Warning !"), accountingBatch.getCode()});
        }
    }

    protected void stop() {
        String comment = I18n.get((String)"Moves export batch's reporting :") + "\n";
        comment = comment + String.format("\t* %s (%s)" + I18n.get((String)"Moves Lines (Moves) exported") + "\n", this.moveLineDone, this.moveDone);
        comment = comment + String.format("\t* " + I18n.get((String)"Debit") + " : %s\n", this.debit);
        comment = comment + String.format("\t* " + I18n.get((String)"Credit") + " : %s\n", this.credit);
        comment = comment + String.format("\t* " + I18n.get((String)"Balance") + " : %s\n", this.balance);
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

