/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.FixedAssetLine;
import com.axelor.apps.account.db.repo.FixedAssetLineRepository;
import com.axelor.apps.account.service.FixedAssetLineService;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.time.LocalDate;
import java.util.List;

public class BatchRealizeFixedAssetLine
extends AbstractBatch {
    private FixedAssetLineService fixedAssetLineService;
    @Inject
    FixedAssetLineRepository fixedAssetLineRepo;

    @Inject
    public BatchRealizeFixedAssetLine(FixedAssetLineService fixedAssetLineService) {
        this.fixedAssetLineService = fixedAssetLineService;
    }

    protected void process() {
        List fixedAssetLineList = ((FixedAssetLineRepository)((Object)Beans.get(FixedAssetLineRepository.class))).all().filter("self.statusSelect = ?1 and self.depreciationDate < ?2", new Object[]{1, LocalDate.now()}).fetch();
        for (FixedAssetLine fixedAssetLine : fixedAssetLineList) {
            try {
                fixedAssetLine = (FixedAssetLine)((Object)this.fixedAssetLineRepo.find(fixedAssetLine.getId()));
                if (fixedAssetLine.getFixedAsset().getStatusSelect() > 1) {
                    this.fixedAssetLineService.realize(fixedAssetLine);
                    this.incrementDone();
                }
            }
            catch (Exception e) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)e);
            }
            JPA.clear();
        }
    }

    protected void stop() {
        String comment = String.format("\t* %s " + I18n.get((String)"Realized fixed asset lines") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        this.addComment(comment);
        super.stop();
    }
}

