/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.account.service.AccountingService;
import com.axelor.apps.account.service.ReimbursementImportService;
import com.axelor.apps.account.service.RejectImportService;
import com.axelor.apps.account.service.batch.BatchAccountCustomer;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.base.db.Company;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchReimbursementImport
extends BatchStrategy {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean stop = false;
    protected BigDecimal totalAmount = BigDecimal.ZERO;
    protected String updateCustomerAccountLog = "";

    @Inject
    public BatchReimbursementImport(ReimbursementImportService reimbursementImportService, RejectImportService rejectImportService, BatchAccountCustomer batchAccountCustomer) {
        super(reimbursementImportService, rejectImportService, batchAccountCustomer);
        AccountingService.setUpdateCustomerAccount(false);
    }

    protected void start() throws IllegalAccessException {
        super.start();
        Company company = this.batch.getAccountingBatch().getCompany();
        company = (Company)((Object)this.companyRepo.find(company.getId()));
        try {
            this.reimbursementImportService.testCompanyField(company);
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), ""), (String)"reimbursement", (long)this.batch.getId());
            this.incrementAnomaly();
            this.stop = true;
        }
        this.checkPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        if (!this.stop) {
            Company company = this.batch.getAccountingBatch().getCompany();
            company = (Company)((Object)this.companyRepo.find(company.getId()));
            AccountConfig accountConfig = company.getAccountConfig();
            Map<List<String[]>, String> data = null;
            try {
                this.rejectImportService.createFilePath(accountConfig.getReimbursementImportFolderPathCFONB());
                data = this.rejectImportService.getCFONBFileByLot(accountConfig.getReimbursementImportFolderPathCFONB(), accountConfig.getTempReimbImportFolderPathCFONB(), company, 0);
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Reimbursement's import's batch %s"), new Object[]{this.batch.getId()}), (String)"reimbursement", (long)this.batch.getId());
                this.incrementAnomaly();
                this.stop();
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Reimbursement's import's batch %s"), this.batch.getId()), e), (String)"reimbursement", (long)this.batch.getId());
                this.incrementAnomaly();
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le batch d'import des remboursements {}", (Object)this.batch.getId());
                this.stop();
            }
            int seq = 1;
            int i = 0;
            for (Map.Entry<List<String[]>, String> entry : data.entrySet()) {
                LocalDate rejectDate = this.rejectImportService.createRejectDate(entry.getValue());
                Move move = this.createMove(company, rejectDate);
                for (String[] reject : entry.getKey()) {
                    try {
                        Reimbursement reimbursement = this.reimbursementImportService.createReimbursementRejectMoveLine(reject, (Company)((Object)this.companyRepo.find(company.getId())), seq, (Move)((Object)this.moveRepo.find(move.getId())), rejectDate);
                        if (reimbursement == null) continue;
                        this.log.debug("Remboursement n\u00b0 {} trait\u00e9", (Object)reimbursement.getRef());
                        ++seq;
                        ++i;
                        this.updateReimbursement(reimbursement);
                    }
                    catch (AxelorException e) {
                        TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Reimbursement reject %s"), new Object[]{reject[1]}), (String)"reimbursement", (long)this.batch.getId());
                        this.incrementAnomaly();
                    }
                    catch (Exception e) {
                        TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Reimbursement reject %s"), reject[1]), e), (String)"reimbursement", (long)this.batch.getId());
                        this.incrementAnomaly();
                        this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le rejet de remboursement {}", (Object)reject[1]);
                    }
                    finally {
                        if (i % 10 != 0) continue;
                        JPA.clear();
                    }
                }
                this.validateMove(move, rejectDate, seq);
            }
            this.updateCustomerAccountLog = this.updateCustomerAccountLog + this.batchAccountCustomer.updateAccountingSituationMarked(company);
        }
    }

    public Move createMove(Company company, LocalDate rejectDate) {
        Move move = null;
        try {
            move = this.reimbursementImportService.createMoveReject((Company)((Object)this.companyRepo.find(company.getId())), rejectDate);
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Reimbursement's import's batch %s"), new Object[]{this.batch.getId()}), (String)"reimbursement", (long)this.batch.getId());
            this.incrementAnomaly();
            this.stop();
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Reimbursement's import's batch %s"), this.batch.getId()), e), (String)"reimbursement", (long)this.batch.getId());
            this.incrementAnomaly();
            this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le batch d'import des remboursements {}", (Object)this.batch.getId());
            this.stop();
        }
        return move;
    }

    public void validateMove(Move move, LocalDate rejectDate, int seq) {
        try {
            if (seq != 1) {
                MoveLine oppositeMoveLine = this.reimbursementImportService.createOppositeRejectMoveLine((Move)((Object)this.moveRepo.find(move.getId())), seq, rejectDate);
                this.reimbursementImportService.validateMove((Move)((Object)this.moveRepo.find(move.getId())));
                this.totalAmount = this.totalAmount.add(((MoveLine)((Object)this.moveLineRepo.find(oppositeMoveLine.getId()))).getDebit());
            } else {
                this.reimbursementImportService.deleteMove((Move)((Object)this.moveRepo.find(move.getId())));
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Reimbursement's import's batch %s"), new Object[]{this.batch.getId()}), (String)"reimbursement", (long)this.batch.getId());
            this.incrementAnomaly();
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Reimbursement's import's batch %s"), this.batch.getId()), e), (String)"reimbursement", (long)this.batch.getId());
            this.incrementAnomaly();
            this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le batch d'import des remboursements {}", (Object)this.batch.getId());
        }
    }

    protected void stop() {
        AccountingService.setUpdateCustomerAccount(true);
        String comment = "";
        comment = I18n.get((String)"Reporting to reimbursement reject's import :") + "\n";
        comment = comment + String.format("\t* %s " + I18n.get((String)"Reimbursement(s) rejected") + "\n", this.batch.getDone());
        comment = comment + String.format("\t* " + I18n.get((String)"Total Amount") + " : %s \n", this.totalAmount);
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        comment = comment + String.format("\t* ------------------------------- \n", new Object[0]);
        comment = comment + String.format("\t* %s ", this.updateCustomerAccountLog);
        super.stop();
        this.addComment(comment);
    }
}

